/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server;

import java.util.Set;
import java.util.function.Supplier;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.server.ApiVersionManager;
import org.apache.kafka.server.BrokerFeatures;
import org.apache.kafka.server.common.FinalizedFeatures;

public class SimpleApiVersionManager
implements ApiVersionManager {
    private final ApiMessageType.ListenerType listenerType;
    private final Features<SupportedVersionRange> brokerFeatures;
    private final boolean enableUnstableLastVersion;
    private final Supplier<FinalizedFeatures> featuresProvider;
    private final ApiVersionsResponseData.ApiVersionCollection apiVersions;

    public SimpleApiVersionManager(ApiMessageType.ListenerType listenerType, boolean enableUnstableLastVersion, Supplier<FinalizedFeatures> featuresProvider) {
        this.listenerType = listenerType;
        this.brokerFeatures = BrokerFeatures.defaultSupportedFeatures(enableUnstableLastVersion);
        this.enableUnstableLastVersion = enableUnstableLastVersion;
        this.featuresProvider = featuresProvider;
        this.apiVersions = ApiVersionsResponse.collectApis((ApiMessageType.ListenerType)listenerType, (Set)ApiKeys.apisForListener((ApiMessageType.ListenerType)listenerType), (boolean)enableUnstableLastVersion);
    }

    @Override
    public boolean enableUnstableLastVersion() {
        return this.enableUnstableLastVersion;
    }

    @Override
    public ApiMessageType.ListenerType listenerType() {
        return this.listenerType;
    }

    @Override
    public ApiVersionsResponse apiVersionResponse(int throttleTimeMs, boolean alterFeatureLevel0) {
        FinalizedFeatures currentFeatures = this.features();
        return new ApiVersionsResponse.Builder().setThrottleTimeMs(throttleTimeMs).setApiVersions(this.apiVersions).setSupportedFeatures(this.brokerFeatures).setFinalizedFeatures(currentFeatures.finalizedFeatures()).setFinalizedFeaturesEpoch(currentFeatures.finalizedFeaturesEpoch()).setAlterFeatureLevel0(alterFeatureLevel0).build();
    }

    @Override
    public FinalizedFeatures features() {
        return this.featuresProvider.get();
    }
}

