/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.server.log.remote.storage.RemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadataUpdate;
import org.apache.kafka.server.log.remote.storage.RemotePartitionDeleteMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteStorageException;
import org.apache.kafka.storage.internals.log.StorageAction;

public class ClassLoaderAwareRemoteLogMetadataManager
implements RemoteLogMetadataManager {
    private final RemoteLogMetadataManager delegate;
    private final ClassLoader loader;

    public ClassLoaderAwareRemoteLogMetadataManager(RemoteLogMetadataManager delegate, ClassLoader loader) {
        this.delegate = delegate;
        this.loader = loader;
    }

    public CompletableFuture<Void> addRemoteLogSegmentMetadata(RemoteLogSegmentMetadata remoteLogSegmentMetadata) throws RemoteStorageException {
        return this.withClassLoader(() -> this.delegate.addRemoteLogSegmentMetadata(remoteLogSegmentMetadata));
    }

    public CompletableFuture<Void> updateRemoteLogSegmentMetadata(RemoteLogSegmentMetadataUpdate remoteLogSegmentMetadataUpdate) throws RemoteStorageException {
        return this.withClassLoader(() -> this.delegate.updateRemoteLogSegmentMetadata(remoteLogSegmentMetadataUpdate));
    }

    public Optional<RemoteLogSegmentMetadata> remoteLogSegmentMetadata(TopicIdPartition topicIdPartition, int epochForOffset, long offset) throws RemoteStorageException {
        return this.withClassLoader(() -> this.delegate.remoteLogSegmentMetadata(topicIdPartition, epochForOffset, offset));
    }

    public Optional<Long> highestOffsetForEpoch(TopicIdPartition topicIdPartition, int leaderEpoch) throws RemoteStorageException {
        return this.withClassLoader(() -> this.delegate.highestOffsetForEpoch(topicIdPartition, leaderEpoch));
    }

    public CompletableFuture<Void> putRemotePartitionDeleteMetadata(RemotePartitionDeleteMetadata remotePartitionDeleteMetadata) throws RemoteStorageException {
        return this.withClassLoader(() -> this.delegate.putRemotePartitionDeleteMetadata(remotePartitionDeleteMetadata));
    }

    public Iterator<RemoteLogSegmentMetadata> listRemoteLogSegments(TopicIdPartition topicIdPartition) throws RemoteStorageException {
        return this.withClassLoader(() -> this.delegate.listRemoteLogSegments(topicIdPartition));
    }

    public Iterator<RemoteLogSegmentMetadata> listRemoteLogSegments(TopicIdPartition topicIdPartition, int leaderEpoch) throws RemoteStorageException {
        return this.withClassLoader(() -> this.delegate.listRemoteLogSegments(topicIdPartition, leaderEpoch));
    }

    public void onPartitionLeadershipChanges(Set<TopicIdPartition> leaderPartitions, Set<TopicIdPartition> followerPartitions) {
        this.withClassLoader(() -> {
            this.delegate.onPartitionLeadershipChanges(leaderPartitions, followerPartitions);
            return null;
        });
    }

    public void onStopPartitions(Set<TopicIdPartition> partitions) {
        this.withClassLoader(() -> {
            this.delegate.onStopPartitions(partitions);
            return null;
        });
    }

    public void configure(Map<String, ?> configs) {
        this.withClassLoader(() -> {
            this.delegate.configure(configs);
            return null;
        });
    }

    public void close() throws IOException {
        this.withClassLoader(() -> {
            this.delegate.close();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, E extends Exception> T withClassLoader(StorageAction<T, E> action) throws E {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.loader);
        try {
            T t = action.execute();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }
}

