/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.KeyValue;

@InterfaceStability.Evolving
public class ConsumerRecordFactory<K, V> {
    private final String topicName;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private long timeMs;
    private final long advanceMs;

    public ConsumerRecordFactory(Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this(null, keySerializer, valueSerializer, System.currentTimeMillis());
    }

    public ConsumerRecordFactory(String defaultTopicName, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this(defaultTopicName, keySerializer, valueSerializer, System.currentTimeMillis());
    }

    public ConsumerRecordFactory(Serializer<K> keySerializer, Serializer<V> valueSerializer, long startTimestampMs) {
        this(null, keySerializer, valueSerializer, startTimestampMs, 0L);
    }

    public ConsumerRecordFactory(String defaultTopicName, Serializer<K> keySerializer, Serializer<V> valueSerializer, long startTimestampMs) {
        this(defaultTopicName, keySerializer, valueSerializer, startTimestampMs, 0L);
    }

    public ConsumerRecordFactory(Serializer<K> keySerializer, Serializer<V> valueSerializer, long startTimestampMs, long autoAdvanceMs) {
        this(null, keySerializer, valueSerializer, startTimestampMs, autoAdvanceMs);
    }

    public ConsumerRecordFactory(String defaultTopicName, Serializer<K> keySerializer, Serializer<V> valueSerializer, long startTimestampMs, long autoAdvanceMs) {
        Objects.requireNonNull(keySerializer, "keySerializer cannot be null");
        Objects.requireNonNull(valueSerializer, "valueSerializer cannot be null");
        this.topicName = defaultTopicName;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.timeMs = startTimestampMs;
        this.advanceMs = autoAdvanceMs;
    }

    public void advanceTimeMs(long advanceMs) {
        if (advanceMs < 0L) {
            throw new IllegalArgumentException("advanceMs must be positive");
        }
        this.timeMs += advanceMs;
    }

    public ConsumerRecord<byte[], byte[]> create(String topicName, K key, V value, Headers headers, long timestampMs) {
        Objects.requireNonNull(topicName, "topicName cannot be null.");
        Objects.requireNonNull(headers, "headers cannot be null.");
        byte[] serializedKey = this.keySerializer.serialize(topicName, key);
        byte[] serializedValue = this.valueSerializer.serialize(topicName, value);
        return new ConsumerRecord(topicName, -1, -1L, timestampMs, TimestampType.CREATE_TIME, Long.valueOf(-1L), serializedKey == null ? 0 : serializedKey.length, serializedValue == null ? 0 : serializedValue.length, (Object)serializedKey, (Object)serializedValue, headers);
    }

    public ConsumerRecord<byte[], byte[]> create(String topicName, K key, V value, long timestampMs) {
        return this.create(topicName, key, value, (Headers)new RecordHeaders(), timestampMs);
    }

    public ConsumerRecord<byte[], byte[]> create(K key, V value, long timestampMs) {
        return this.create(key, value, (Headers)new RecordHeaders(), timestampMs);
    }

    public ConsumerRecord<byte[], byte[]> create(K key, V value, Headers headers, long timestampMs) {
        if (this.topicName == null) {
            throw new IllegalStateException("ConsumerRecordFactory was created without defaultTopicName. Use #create(String topicName, K key, V value, long timestampMs) instead.");
        }
        return this.create(this.topicName, key, value, headers, timestampMs);
    }

    public ConsumerRecord<byte[], byte[]> create(String topicName, K key, V value) {
        long timestamp = this.timeMs;
        this.timeMs += this.advanceMs;
        return this.create(topicName, key, value, (Headers)new RecordHeaders(), timestamp);
    }

    public ConsumerRecord<byte[], byte[]> create(String topicName, K key, V value, Headers headers) {
        long timestamp = this.timeMs;
        this.timeMs += this.advanceMs;
        return this.create(topicName, key, value, headers, timestamp);
    }

    public ConsumerRecord<byte[], byte[]> create(K key, V value) {
        return this.create(key, value, (Headers)new RecordHeaders());
    }

    public ConsumerRecord<byte[], byte[]> create(K key, V value, Headers headers) {
        if (this.topicName == null) {
            throw new IllegalStateException("ConsumerRecordFactory was created without defaultTopicName. Use #create(String topicName, K key, V value) instead.");
        }
        return this.create(this.topicName, key, value, headers);
    }

    public ConsumerRecord<byte[], byte[]> create(String topicName, V value, long timestampMs) {
        return this.create(topicName, null, value, (Headers)new RecordHeaders(), timestampMs);
    }

    public ConsumerRecord<byte[], byte[]> create(String topicName, V value, Headers headers, long timestampMs) {
        return this.create(topicName, null, value, headers, timestampMs);
    }

    public ConsumerRecord<byte[], byte[]> create(V value, long timestampMs) {
        return this.create(value, (Headers)new RecordHeaders(), timestampMs);
    }

    public ConsumerRecord<byte[], byte[]> create(V value, Headers headers, long timestampMs) {
        if (this.topicName == null) {
            throw new IllegalStateException("ConsumerRecordFactory was created without defaultTopicName. Use #create(String topicName, V value, long timestampMs) instead.");
        }
        return this.create(this.topicName, value, headers, timestampMs);
    }

    public ConsumerRecord<byte[], byte[]> create(String topicName, V value, Headers headers) {
        return this.create(topicName, null, value, headers);
    }

    public ConsumerRecord<byte[], byte[]> create(String topicName, V value) {
        return this.create(topicName, null, value, (Headers)new RecordHeaders());
    }

    public ConsumerRecord<byte[], byte[]> create(V value) {
        return this.create(value, (Headers)new RecordHeaders());
    }

    public ConsumerRecord<byte[], byte[]> create(V value, Headers headers) {
        if (this.topicName == null) {
            throw new IllegalStateException("ConsumerRecordFactory was created without defaultTopicName. Use #create(String topicName, V value, long timestampMs) instead.");
        }
        return this.create(this.topicName, value, headers);
    }

    public List<ConsumerRecord<byte[], byte[]>> create(String topicName, List<KeyValue<K, V>> keyValues) {
        ArrayList<ConsumerRecord<byte[], byte[]>> records = new ArrayList<ConsumerRecord<byte[], byte[]>>(keyValues.size());
        for (KeyValue<K, V> keyValue : keyValues) {
            records.add(this.create(topicName, keyValue.key, keyValue.value));
        }
        return records;
    }

    public List<ConsumerRecord<byte[], byte[]>> create(List<KeyValue<K, V>> keyValues) {
        if (this.topicName == null) {
            throw new IllegalStateException("ConsumerRecordFactory was created without defaultTopicName. Use #create(String topicName, List<KeyValue<K, V>> keyValues) instead.");
        }
        return this.create(this.topicName, keyValues);
    }

    public List<ConsumerRecord<byte[], byte[]>> create(String topicName, List<KeyValue<K, V>> keyValues, long startTimestamp, long advanceMs) {
        if (advanceMs < 0L) {
            throw new IllegalArgumentException("advanceMs must be positive");
        }
        ArrayList<ConsumerRecord<byte[], byte[]>> records = new ArrayList<ConsumerRecord<byte[], byte[]>>(keyValues.size());
        long timestamp = startTimestamp;
        for (KeyValue<K, V> keyValue : keyValues) {
            records.add(this.create(topicName, keyValue.key, keyValue.value, (Headers)new RecordHeaders(), timestamp));
            timestamp += advanceMs;
        }
        return records;
    }

    public List<ConsumerRecord<byte[], byte[]>> create(List<KeyValue<K, V>> keyValues, long startTimestamp, long advanceMs) {
        if (this.topicName == null) {
            throw new IllegalStateException("ConsumerRecordFactory was created without defaultTopicName. Use #create(String topicName, List<KeyValue<K, V>> keyValues, long startTimestamp, long advanceMs) instead.");
        }
        return this.create(this.topicName, keyValues, startTimestamp, advanceMs);
    }

    public List<ConsumerRecord<byte[], byte[]>> create(String topicName, List<KeyValue<K, V>> keyValues, long startTimestamp) {
        return this.create(topicName, keyValues, startTimestamp, 1L);
    }

    public List<ConsumerRecord<byte[], byte[]>> create(List<KeyValue<K, V>> keyValues, long startTimestamp) {
        if (this.topicName == null) {
            throw new IllegalStateException("ConsumerRecordFactory was created without defaultTopicName. Use #create(String topicName, List<KeyValue<K, V>> keyValues, long startTimestamp) instead.");
        }
        return this.create(this.topicName, keyValues, startTimestamp, 1L);
    }
}

