/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.test;

import java.util.Objects;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Headers;

public class OutputVerifier {
    public static <K, V> void compareValue(ProducerRecord<K, V> record, V expectedValue) throws AssertionError {
        Objects.requireNonNull(record);
        Object recordValue = record.value();
        AssertionError error = new AssertionError((Object)("Expected value=" + expectedValue + " but was value=" + recordValue));
        if (recordValue != null ? !recordValue.equals(expectedValue) : expectedValue != null) {
            throw error;
        }
    }

    public static <K, V> void compareValue(ProducerRecord<K, V> record, ProducerRecord<K, V> expectedRecord) throws AssertionError {
        Objects.requireNonNull(expectedRecord);
        OutputVerifier.compareValue(record, expectedRecord.value());
    }

    public static <K, V> void compareKeyValue(ProducerRecord<K, V> record, K expectedKey, V expectedValue) throws AssertionError {
        Objects.requireNonNull(record);
        Object recordKey = record.key();
        Object recordValue = record.value();
        AssertionError error = new AssertionError((Object)("Expected <" + expectedKey + ", " + expectedValue + "> but was <" + recordKey + ", " + recordValue + ">"));
        if (recordKey != null ? !recordKey.equals(expectedKey) : expectedKey != null) {
            throw error;
        }
        if (recordValue != null ? !recordValue.equals(expectedValue) : expectedValue != null) {
            throw error;
        }
    }

    public static <K, V> void compareKeyValue(ProducerRecord<K, V> record, ProducerRecord<K, V> expectedRecord) throws AssertionError {
        Objects.requireNonNull(expectedRecord);
        OutputVerifier.compareKeyValue(record, expectedRecord.key(), expectedRecord.value());
    }

    public static <K, V> void compareValueTimestamp(ProducerRecord<K, V> record, V expectedValue, long expectedTimestamp) throws AssertionError {
        Objects.requireNonNull(record);
        Object recordValue = record.value();
        long recordTimestamp = record.timestamp();
        AssertionError error = new AssertionError((Object)("Expected value=" + expectedValue + " with timestamp=" + expectedTimestamp + " but was value=" + recordValue + " with timestamp=" + recordTimestamp));
        if (recordValue != null ? !recordValue.equals(expectedValue) : expectedValue != null) {
            throw error;
        }
        if (recordTimestamp != expectedTimestamp) {
            throw error;
        }
    }

    public static <K, V> void compareValueTimestamp(ProducerRecord<K, V> record, ProducerRecord<K, V> expectedRecord) throws AssertionError {
        Objects.requireNonNull(expectedRecord);
        OutputVerifier.compareValueTimestamp(record, expectedRecord.value(), expectedRecord.timestamp());
    }

    public static <K, V> void compareKeyValueTimestamp(ProducerRecord<K, V> record, K expectedKey, V expectedValue, long expectedTimestamp) throws AssertionError {
        Objects.requireNonNull(record);
        Object recordKey = record.key();
        Object recordValue = record.value();
        long recordTimestamp = record.timestamp();
        AssertionError error = new AssertionError((Object)("Expected <" + expectedKey + ", " + expectedValue + "> with timestamp=" + expectedTimestamp + " but was <" + recordKey + ", " + recordValue + "> with timestamp=" + recordTimestamp));
        if (recordKey != null ? !recordKey.equals(expectedKey) : expectedKey != null) {
            throw error;
        }
        if (recordValue != null ? !recordValue.equals(expectedValue) : expectedValue != null) {
            throw error;
        }
        if (recordTimestamp != expectedTimestamp) {
            throw error;
        }
    }

    public static <K, V> void compareKeyValueTimestamp(ProducerRecord<K, V> record, ProducerRecord<K, V> expectedRecord) throws AssertionError {
        Objects.requireNonNull(expectedRecord);
        OutputVerifier.compareKeyValueTimestamp(record, expectedRecord.key(), expectedRecord.value(), expectedRecord.timestamp());
    }

    public static <K, V> void compareValueHeaders(ProducerRecord<K, V> record, V expectedValue, Headers expectedHeaders) throws AssertionError {
        Objects.requireNonNull(record);
        Object recordValue = record.value();
        Headers recordHeaders = record.headers();
        AssertionError error = new AssertionError((Object)("Expected value=" + expectedValue + " with headers=" + expectedHeaders + " but was value=" + recordValue + " with headers=" + recordHeaders));
        if (recordValue != null ? !recordValue.equals(expectedValue) : expectedValue != null) {
            throw error;
        }
        if (recordHeaders != null ? !recordHeaders.equals(expectedHeaders) : expectedHeaders != null) {
            throw error;
        }
    }

    public static <K, V> void compareValueHeaders(ProducerRecord<K, V> record, ProducerRecord<K, V> expectedRecord) throws AssertionError {
        Objects.requireNonNull(expectedRecord);
        OutputVerifier.compareValueHeaders(record, expectedRecord.value(), expectedRecord.headers());
    }

    public static <K, V> void compareKeyValueHeaders(ProducerRecord<K, V> record, K expectedKey, V expectedValue, Headers expectedHeaders) throws AssertionError {
        Objects.requireNonNull(record);
        Object recordKey = record.key();
        Object recordValue = record.value();
        Headers recordHeaders = record.headers();
        AssertionError error = new AssertionError((Object)("Expected <" + expectedKey + ", " + expectedValue + "> with headers=" + expectedHeaders + " but was <" + recordKey + ", " + recordValue + "> with headers=" + recordHeaders));
        if (recordKey != null ? !recordKey.equals(expectedKey) : expectedKey != null) {
            throw error;
        }
        if (recordValue != null ? !recordValue.equals(expectedValue) : expectedValue != null) {
            throw error;
        }
        if (recordHeaders != null ? !recordHeaders.equals(expectedHeaders) : expectedHeaders != null) {
            throw error;
        }
    }

    public static <K, V> void compareKeyValueHeaders(ProducerRecord<K, V> record, ProducerRecord<K, V> expectedRecord) throws AssertionError {
        Objects.requireNonNull(expectedRecord);
        OutputVerifier.compareKeyValueHeaders(record, expectedRecord.key(), expectedRecord.value(), expectedRecord.headers());
    }

    public static <K, V> void compareKeyValueHeadersTimestamp(ProducerRecord<K, V> record, K expectedKey, V expectedValue, Headers expectedHeaders, long expectedTimestamp) throws AssertionError {
        Objects.requireNonNull(record);
        Object recordKey = record.key();
        Object recordValue = record.value();
        Headers recordHeaders = record.headers();
        long recordTimestamp = record.timestamp();
        AssertionError error = new AssertionError((Object)("Expected <" + expectedKey + ", " + expectedValue + "> with timestamp=" + expectedTimestamp + " and headers=" + expectedHeaders + " but was <" + recordKey + ", " + recordValue + "> with timestamp=" + recordTimestamp + " and headers=" + recordHeaders));
        if (recordKey != null ? !recordKey.equals(expectedKey) : expectedKey != null) {
            throw error;
        }
        if (recordValue != null ? !recordValue.equals(expectedValue) : expectedValue != null) {
            throw error;
        }
        if (recordHeaders != null ? !recordHeaders.equals(expectedHeaders) : expectedHeaders != null) {
            throw error;
        }
        if (recordTimestamp != expectedTimestamp) {
            throw error;
        }
    }

    public static <K, V> void compareKeyValueHeadersTimestamp(ProducerRecord<K, V> record, ProducerRecord<K, V> expectedRecord) throws AssertionError {
        Objects.requireNonNull(expectedRecord);
        OutputVerifier.compareKeyValueHeadersTimestamp(record, expectedRecord.key(), expectedRecord.value(), expectedRecord.headers(), expectedRecord.timestamp());
    }
}

