/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.internals.KStreamImpl;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableSource;
import org.apache.kafka.streams.processor.TopologyBuilder;

public class KStreamBuilder
extends TopologyBuilder {
    private final AtomicInteger index = new AtomicInteger(0);

    public <K, V> KStream<K, V> stream(String ... topics) {
        return this.stream((Serde<K>)null, (Serde<V>)null, topics);
    }

    public <K, V> KStream<K, V> stream(Serde<K> keySerde, Serde<V> valSerde, String ... topics) {
        String name = this.newName("KSTREAM-SOURCE-");
        this.addSource(name, keySerde == null ? null : keySerde.deserializer(), valSerde == null ? null : valSerde.deserializer(), topics);
        return new KStreamImpl(this, name, Collections.singleton(name));
    }

    public <K, V> KTable<K, V> table(String topic) {
        return this.table(null, null, topic);
    }

    public <K, V> KTable<K, V> table(Serde<K> keySerde, Serde<V> valSerde, String topic) {
        String source = this.newName("KSTREAM-SOURCE-");
        String name = this.newName("KTABLE-SOURCE-");
        this.addSource(source, keySerde == null ? null : keySerde.deserializer(), valSerde == null ? null : valSerde.deserializer(), topic);
        KTableSource processorSupplier = new KTableSource(topic);
        this.addProcessor(name, processorSupplier, source);
        return new KTableImpl(this, name, processorSupplier, Collections.singleton(source), keySerde, valSerde);
    }

    public <K, V> KStream<K, V> merge(KStream<K, V> ... streams) {
        return KStreamImpl.merge(this, streams);
    }

    public String newName(String prefix) {
        return prefix + String.format("%010d", this.index.getAndIncrement());
    }
}

