/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorSupplier;

class KStreamFlatMap<K, V, K1, V1>
implements ProcessorSupplier<K, V> {
    private final KeyValueMapper<K, V, Iterable<KeyValue<K1, V1>>> mapper;

    KStreamFlatMap(KeyValueMapper<K, V, Iterable<KeyValue<K1, V1>>> mapper) {
        this.mapper = mapper;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamFlatMapProcessor();
    }

    private class KStreamFlatMapProcessor
    extends AbstractProcessor<K, V> {
        private KStreamFlatMapProcessor() {
        }

        @Override
        public void process(K key, V value) {
            for (KeyValue newPair : (Iterable)KStreamFlatMap.this.mapper.apply(key, value)) {
                this.context().forward(newPair.key, newPair.value);
            }
        }
    }
}

