/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Map;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Reducer;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;

public class KStreamWindowReduce<K, V, W extends Window>
implements KStreamAggProcessorSupplier<K, Windowed<K>, V, V> {
    private final String storeName;
    private final Windows<W> windows;
    private final Reducer<V> reducer;
    private boolean sendOldValues = false;

    public KStreamWindowReduce(Windows<W> windows, String storeName, Reducer<V> reducer) {
        this.windows = windows;
        this.storeName = storeName;
        this.reducer = reducer;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamWindowReduceProcessor();
    }

    @Override
    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    @Override
    public KTableValueGetterSupplier<Windowed<K>, V> view() {
        return new KTableValueGetterSupplier<Windowed<K>, V>(){

            @Override
            public KTableValueGetter<Windowed<K>, V> get() {
                return new KStreamAggregateValueGetter();
            }
        };
    }

    private class KStreamAggregateValueGetter
    implements KTableValueGetter<Windowed<K>, V> {
        private WindowStore<K, V> windowStore;

        private KStreamAggregateValueGetter() {
        }

        @Override
        public void init(ProcessorContext context) {
            this.windowStore = (WindowStore)context.getStateStore(KStreamWindowReduce.this.storeName);
        }

        @Override
        public V get(Windowed<K> windowedKey) {
            Object key = windowedKey.key();
            Window window = windowedKey.window();
            WindowStoreIterator iter = this.windowStore.fetch(key, window.start(), window.start());
            return ((KeyValue)iter.next()).value;
        }
    }

    private class KStreamWindowReduceProcessor
    extends AbstractProcessor<K, V> {
        private WindowStore<K, V> windowStore;

        private KStreamWindowReduceProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.windowStore = (WindowStore)context.getStateStore(KStreamWindowReduce.this.storeName);
        }

        @Override
        public void process(K key, V value) {
            if (key == null) {
                return;
            }
            long timestamp = this.context().timestamp();
            Map matchedWindows = KStreamWindowReduce.this.windows.windowsFor(timestamp);
            long timeFrom = Long.MAX_VALUE;
            long timeTo = Long.MIN_VALUE;
            for (long windowStartMs : matchedWindows.keySet()) {
                timeFrom = windowStartMs < timeFrom ? windowStartMs : timeFrom;
                timeTo = windowStartMs > timeTo ? windowStartMs : timeTo;
            }
            WindowStoreIterator iter = this.windowStore.fetch(key, timeFrom, timeTo);
            while (iter.hasNext()) {
                KeyValue entry = (KeyValue)iter.next();
                Window window = (Window)matchedWindows.get(entry.key);
                if (window == null) continue;
                Object oldAgg = entry.value;
                Object newAgg = oldAgg;
                newAgg = newAgg == null ? value : KStreamWindowReduce.this.reducer.apply(newAgg, value);
                this.windowStore.put(key, newAgg, window.start());
                if (KStreamWindowReduce.this.sendOldValues) {
                    this.context().forward(new Windowed(key, window), new Change(newAgg, oldAgg));
                } else {
                    this.context().forward(new Windowed(key, window), new Change<Object>(newAgg, null));
                }
                matchedWindows.remove(entry.key);
            }
            iter.close();
            for (long windowStartMs : matchedWindows.keySet()) {
                this.windowStore.put(key, value, windowStartMs);
                this.context().forward(new Windowed(key, (Window)matchedWindows.get(windowStartMs)), new Change<Object>(value, null));
            }
        }
    }
}

