/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.File;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.errors.TopologyBuilderException;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.StreamTask;

public class ProcessorContextImpl
implements ProcessorContext,
RecordCollector.Supplier {
    public static final String NONEXIST_TOPIC = "__null_topic__";
    private final TaskId id;
    private final StreamTask task;
    private final StreamsMetrics metrics;
    private final RecordCollector collector;
    private final ProcessorStateManager stateMgr;
    private final Serde<?> keySerde;
    private final Serde<?> valSerde;
    private boolean initialized;

    public ProcessorContextImpl(TaskId id, StreamTask task, StreamsConfig config, RecordCollector collector, ProcessorStateManager stateMgr, StreamsMetrics metrics) {
        this.id = id;
        this.task = task;
        this.metrics = metrics;
        this.collector = collector;
        this.stateMgr = stateMgr;
        this.keySerde = config.keySerde();
        this.valSerde = config.valueSerde();
        this.initialized = false;
    }

    public void initialized() {
        this.initialized = true;
    }

    public ProcessorStateManager getStateMgr() {
        return this.stateMgr;
    }

    @Override
    public TaskId taskId() {
        return this.id;
    }

    @Override
    public String applicationId() {
        return this.task.applicationId();
    }

    @Override
    public RecordCollector recordCollector() {
        return this.collector;
    }

    @Override
    public Serde<?> keySerde() {
        return this.keySerde;
    }

    @Override
    public Serde<?> valueSerde() {
        return this.valSerde;
    }

    @Override
    public File stateDir() {
        return this.stateMgr.baseDir();
    }

    @Override
    public StreamsMetrics metrics() {
        return this.metrics;
    }

    @Override
    public void register(StateStore store, boolean loggingEnabled, StateRestoreCallback stateRestoreCallback) {
        if (this.initialized) {
            throw new IllegalStateException("Can only create state stores during initialization.");
        }
        this.stateMgr.register(store, loggingEnabled, stateRestoreCallback);
    }

    @Override
    public StateStore getStateStore(String name) {
        ProcessorNode node = this.task.node();
        if (node == null) {
            throw new TopologyBuilderException("Accessing from an unknown node");
        }
        return this.stateMgr.getStore(name);
    }

    @Override
    public String topic() {
        if (this.task.record() == null) {
            throw new IllegalStateException("This should not happen as topic() should only be called while a record is processed");
        }
        String topic = this.task.record().topic();
        if (topic.equals(NONEXIST_TOPIC)) {
            return null;
        }
        return topic;
    }

    @Override
    public int partition() {
        if (this.task.record() == null) {
            throw new IllegalStateException("This should not happen as partition() should only be called while a record is processed");
        }
        return this.task.record().partition();
    }

    @Override
    public long offset() {
        if (this.task.record() == null) {
            throw new IllegalStateException("This should not happen as offset() should only be called while a record is processed");
        }
        return this.task.record().offset();
    }

    @Override
    public long timestamp() {
        if (this.task.record() == null) {
            throw new IllegalStateException("This should not happen as timestamp() should only be called while a record is processed");
        }
        return this.task.record().timestamp;
    }

    @Override
    public <K, V> void forward(K key, V value) {
        this.task.forward(key, value);
    }

    @Override
    public <K, V> void forward(K key, V value, int childIndex) {
        this.task.forward(key, value, childIndex);
    }

    @Override
    public <K, V> void forward(K key, V value, String childName) {
        this.task.forward(key, value, childName);
    }

    @Override
    public void commit() {
        this.task.needCommit();
    }

    @Override
    public void schedule(long interval) {
        this.task.schedule(interval);
    }
}

