/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.AbstractTask;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.StandbyContextImpl;

public class StandbyTask
extends AbstractTask {
    private final Map<TopicPartition, Long> checkpointedOffsets;

    public StandbyTask(TaskId id, String applicationId, Collection<TopicPartition> partitions, ProcessorTopology topology, Consumer<byte[], byte[]> consumer, Consumer<byte[], byte[]> restoreConsumer, StreamsConfig config, StreamsMetrics metrics) {
        super(id, applicationId, partitions, topology, consumer, restoreConsumer, config, true);
        this.processorContext = new StandbyContextImpl(id, applicationId, config, this.stateMgr, metrics);
        this.initializeStateStores();
        ((StandbyContextImpl)this.processorContext).initialized();
        this.checkpointedOffsets = Collections.unmodifiableMap(this.stateMgr.checkpointedOffsets());
    }

    public Map<TopicPartition, Long> checkpointedOffsets() {
        return this.checkpointedOffsets;
    }

    public Collection<TopicPartition> changeLogPartitions() {
        return this.checkpointedOffsets.keySet();
    }

    public List<ConsumerRecord<byte[], byte[]>> update(TopicPartition partition, List<ConsumerRecord<byte[], byte[]>> records) {
        return this.stateMgr.updateStandbyStates(partition, records);
    }

    @Override
    public void commit() {
        this.stateMgr.flush();
        this.initializeOffsetLimits();
    }
}

