/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreSupplier;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueLoggedStore;
import org.apache.kafka.streams.state.internals.MeteredKeyValueStore;

public class InMemoryKeyValueStoreSupplier<K, V>
implements StateStoreSupplier {
    private final String name;
    private final Time time;
    private final Serde<K> keySerde;
    private final Serde<V> valueSerde;

    public InMemoryKeyValueStoreSupplier(String name, Serde<K> keySerde, Serde<V> valueSerde) {
        this(name, keySerde, valueSerde, null);
    }

    public InMemoryKeyValueStoreSupplier(String name, Serde<K> keySerde, Serde<V> valueSerde, Time time) {
        this.name = name;
        this.time = time;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public StateStore get() {
        return new MeteredKeyValueStore<K, V>(new MemoryStore<K, V>(this.name, this.keySerde, this.valueSerde).enableLogging(), "in-memory-state", this.time);
    }

    private static class MemoryStore<K, V>
    implements KeyValueStore<K, V> {
        private final String name;
        private final Serde<K> keySerde;
        private final Serde<V> valueSerde;
        private final NavigableMap<K, V> map;

        public MemoryStore(String name, Serde<K> keySerde, Serde<V> valueSerde) {
            this.name = name;
            this.keySerde = keySerde;
            this.valueSerde = valueSerde;
            this.map = new TreeMap();
        }

        public KeyValueStore<K, V> enableLogging() {
            return new InMemoryKeyValueLoggedStore<K, V>(this.name, this, this.keySerde, this.valueSerde);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public void init(ProcessorContext context, StateStore root) {
        }

        @Override
        public boolean persistent() {
            return false;
        }

        @Override
        public V get(K key) {
            return this.map.get(key);
        }

        @Override
        public void put(K key, V value) {
            this.map.put(key, value);
        }

        @Override
        public V putIfAbsent(K key, V value) {
            V originalValue = this.get(key);
            if (originalValue == null) {
                this.put(key, value);
            }
            return originalValue;
        }

        @Override
        public void putAll(List<KeyValue<K, V>> entries) {
            for (KeyValue<K, V> entry : entries) {
                this.put(entry.key, entry.value);
            }
        }

        @Override
        public V delete(K key) {
            return this.map.remove(key);
        }

        @Override
        public KeyValueIterator<K, V> range(K from, K to) {
            return new MemoryStoreIterator(this.map.subMap(from, true, to, false).entrySet().iterator());
        }

        @Override
        public KeyValueIterator<K, V> all() {
            return new MemoryStoreIterator(this.map.entrySet().iterator());
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        private static class MemoryStoreIterator<K, V>
        implements KeyValueIterator<K, V> {
            private final Iterator<Map.Entry<K, V>> iter;

            public MemoryStoreIterator(Iterator<Map.Entry<K, V>> iter) {
                this.iter = iter;
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public KeyValue<K, V> next() {
                Map.Entry<K, V> entry = this.iter.next();
                return new KeyValue<K, V>(entry.getKey(), entry.getValue());
            }

            @Override
            public void remove() {
                this.iter.remove();
            }

            @Override
            public void close() {
            }
        }
    }
}

