/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.List;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;

public class MeteredKeyValueStore<K, V>
implements KeyValueStore<K, V> {
    protected final KeyValueStore<K, V> inner;
    protected final String metricScope;
    protected final Time time;
    private Sensor putTime;
    private Sensor putIfAbsentTime;
    private Sensor getTime;
    private Sensor deleteTime;
    private Sensor putAllTime;
    private Sensor allTime;
    private Sensor rangeTime;
    private Sensor flushTime;
    private Sensor restoreTime;
    private StreamsMetrics metrics;

    public MeteredKeyValueStore(KeyValueStore<K, V> inner, String metricScope, Time time) {
        this.inner = inner;
        this.metricScope = metricScope;
        this.time = time != null ? time : new SystemTime();
    }

    @Override
    public String name() {
        return this.inner.name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(ProcessorContext context, StateStore root) {
        String name = this.name();
        this.metrics = context.metrics();
        this.putTime = this.metrics.addLatencySensor(this.metricScope, name, "put", new String[0]);
        this.putIfAbsentTime = this.metrics.addLatencySensor(this.metricScope, name, "put-if-absent", new String[0]);
        this.getTime = this.metrics.addLatencySensor(this.metricScope, name, "get", new String[0]);
        this.deleteTime = this.metrics.addLatencySensor(this.metricScope, name, "delete", new String[0]);
        this.putAllTime = this.metrics.addLatencySensor(this.metricScope, name, "put-all", new String[0]);
        this.allTime = this.metrics.addLatencySensor(this.metricScope, name, "all", new String[0]);
        this.rangeTime = this.metrics.addLatencySensor(this.metricScope, name, "range", new String[0]);
        this.flushTime = this.metrics.addLatencySensor(this.metricScope, name, "flush", new String[0]);
        this.restoreTime = this.metrics.addLatencySensor(this.metricScope, name, "restore", new String[0]);
        long startNs = this.time.nanoseconds();
        try {
            this.inner.init(context, root);
        }
        finally {
            this.metrics.recordLatency(this.restoreTime, startNs, this.time.nanoseconds());
        }
    }

    @Override
    public boolean persistent() {
        return this.inner.persistent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        long startNs = this.time.nanoseconds();
        try {
            V v = this.inner.get(key);
            return v;
        }
        finally {
            this.metrics.recordLatency(this.getTime, startNs, this.time.nanoseconds());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value) {
        long startNs = this.time.nanoseconds();
        try {
            this.inner.put(key, value);
        }
        finally {
            this.metrics.recordLatency(this.putTime, startNs, this.time.nanoseconds());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        long startNs = this.time.nanoseconds();
        try {
            V v = this.inner.putIfAbsent(key, value);
            return v;
        }
        finally {
            this.metrics.recordLatency(this.putIfAbsentTime, startNs, this.time.nanoseconds());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(List<KeyValue<K, V>> entries) {
        long startNs = this.time.nanoseconds();
        try {
            this.inner.putAll(entries);
        }
        finally {
            this.metrics.recordLatency(this.putAllTime, startNs, this.time.nanoseconds());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V delete(K key) {
        long startNs = this.time.nanoseconds();
        try {
            V v = this.inner.delete(key);
            return v;
        }
        finally {
            this.metrics.recordLatency(this.deleteTime, startNs, this.time.nanoseconds());
        }
    }

    @Override
    public KeyValueIterator<K, V> range(K from, K to) {
        return new MeteredKeyValueIterator<K, V>(this.inner.range(from, to), this.rangeTime);
    }

    @Override
    public KeyValueIterator<K, V> all() {
        return new MeteredKeyValueIterator<K, V>(this.inner.all(), this.allTime);
    }

    @Override
    public void close() {
        this.inner.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        long startNs = this.time.nanoseconds();
        try {
            this.inner.flush();
        }
        finally {
            this.metrics.recordLatency(this.flushTime, startNs, this.time.nanoseconds());
        }
    }

    private class MeteredKeyValueIterator<K1, V1>
    implements KeyValueIterator<K1, V1> {
        private final KeyValueIterator<K1, V1> iter;
        private final Sensor sensor;
        private final long startNs;

        public MeteredKeyValueIterator(KeyValueIterator<K1, V1> iter, Sensor sensor) {
            this.iter = iter;
            this.sensor = sensor;
            this.startNs = MeteredKeyValueStore.this.time.nanoseconds();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public KeyValue<K1, V1> next() {
            return (KeyValue)this.iter.next();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            try {
                this.iter.close();
            }
            finally {
                MeteredKeyValueStore.this.metrics.recordLatency(this.sensor, this.startNs, MeteredKeyValueStore.this.time.nanoseconds());
            }
        }
    }
}

