/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreSupplier;
import org.apache.kafka.streams.state.internals.MeteredWindowStore;
import org.apache.kafka.streams.state.internals.RocksDBWindowStore;

public class RocksDBWindowStoreSupplier<K, V>
implements StateStoreSupplier {
    private final String name;
    private final long retentionPeriod;
    private final boolean retainDuplicates;
    private final int numSegments;
    private final Serde<K> keySerde;
    private final Serde<V> valueSerde;
    private final Time time;

    public RocksDBWindowStoreSupplier(String name, long retentionPeriod, int numSegments, boolean retainDuplicates, Serde<K> keySerde, Serde<V> valueSerde) {
        this(name, retentionPeriod, numSegments, retainDuplicates, keySerde, valueSerde, null);
    }

    public RocksDBWindowStoreSupplier(String name, long retentionPeriod, int numSegments, boolean retainDuplicates, Serde<K> keySerde, Serde<V> valueSerde, Time time) {
        this.name = name;
        this.retentionPeriod = retentionPeriod;
        this.retainDuplicates = retainDuplicates;
        this.numSegments = numSegments;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.time = time;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public StateStore get() {
        return new MeteredWindowStore<K, V>(new RocksDBWindowStore<K, V>(this.name, this.retentionPeriod, this.numSegments, this.retainDuplicates, this.keySerde, this.valueSerde).enableLogging(), "rocksdb-window", this.time);
    }
}

