/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.internals.KStreamImpl;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableSource;
import org.apache.kafka.streams.processor.TopologyBuilder;
import org.apache.kafka.streams.state.internals.RocksDBKeyValueStoreSupplier;

public class KStreamBuilder
extends TopologyBuilder {
    private final AtomicInteger index = new AtomicInteger(0);

    public <K, V> KStream<K, V> stream(String ... topics) {
        return this.stream((Serde<K>)null, (Serde<V>)null, topics);
    }

    public <K, V> KStream<K, V> stream(Pattern topicPattern) {
        return this.stream(null, null, topicPattern);
    }

    public <K, V> KStream<K, V> stream(Serde<K> keySerde, Serde<V> valSerde, String ... topics) {
        String name = this.newName("KSTREAM-SOURCE-");
        this.addSource(name, keySerde == null ? null : keySerde.deserializer(), valSerde == null ? null : valSerde.deserializer(), topics);
        return new KStreamImpl(this, name, Collections.singleton(name), false);
    }

    public <K, V> KStream<K, V> stream(Serde<K> keySerde, Serde<V> valSerde, Pattern topicPattern) {
        String name = this.newName("KSTREAM-SOURCE-");
        this.addSource(name, keySerde == null ? null : keySerde.deserializer(), valSerde == null ? null : valSerde.deserializer(), topicPattern);
        return new KStreamImpl(this, name, Collections.singleton(name), false);
    }

    public <K, V> KTable<K, V> table(String topic, String storeName) {
        return this.table(null, null, topic, storeName);
    }

    public <K, V> KTable<K, V> table(Serde<K> keySerde, Serde<V> valSerde, String topic, String storeName) {
        String source = this.newName("KSTREAM-SOURCE-");
        String name = this.newName("KTABLE-SOURCE-");
        KTableSource processorSupplier = new KTableSource(storeName);
        this.addSource(source, keySerde == null ? null : keySerde.deserializer(), valSerde == null ? null : valSerde.deserializer(), topic);
        this.addProcessor(name, processorSupplier, source);
        KTableImpl kTable = new KTableImpl(this, name, processorSupplier, Collections.singleton(source), keySerde, valSerde, storeName);
        RocksDBKeyValueStoreSupplier<K, V> storeSupplier = new RocksDBKeyValueStoreSupplier<K, V>(storeName, keySerde, valSerde, false, Collections.emptyMap(), true);
        this.addStateStore(storeSupplier, name);
        this.connectSourceStoreAndTopic(storeName, topic);
        return kTable;
    }

    public <K, V> KStream<K, V> merge(KStream<K, V> ... streams) {
        return KStreamImpl.merge(this, streams);
    }

    public String newName(String prefix) {
        return prefix + String.format("%010d", this.index.getAndIncrement());
    }
}

