/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.streams.kstream.KStreamBuilder;
import org.apache.kafka.streams.kstream.ValueJoiner;

public abstract class AbstractStream<K> {
    protected final KStreamBuilder topology;
    protected final String name;
    protected final Set<String> sourceNodes;

    public AbstractStream(AbstractStream<K> stream) {
        this.topology = stream.topology;
        this.name = stream.name;
        this.sourceNodes = stream.sourceNodes;
    }

    public AbstractStream(KStreamBuilder topology, String name, Set<String> sourceNodes) {
        if (sourceNodes == null || sourceNodes.isEmpty()) {
            throw new IllegalArgumentException("parameter <sourceNodes> must not be null or empty");
        }
        this.topology = topology;
        this.name = name;
        this.sourceNodes = sourceNodes;
    }

    protected Set<String> ensureJoinableWith(AbstractStream<K> other) {
        HashSet<String> allSourceNodes = new HashSet<String>();
        allSourceNodes.addAll(this.sourceNodes);
        allSourceNodes.addAll(other.sourceNodes);
        this.topology.copartitionSources(allSourceNodes);
        return allSourceNodes;
    }

    public static <T2, T1, R> ValueJoiner<T2, T1, R> reverseJoiner(final ValueJoiner<T1, T2, R> joiner) {
        return new ValueJoiner<T2, T1, R>(){

            @Override
            public R apply(T2 value2, T1 value1) {
                return joiner.apply(value1, value2);
            }
        };
    }
}

