/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Unstable
public abstract class Window {
    protected final long startMs;
    protected final long endMs;

    public Window(long startMs, long endMs) throws IllegalArgumentException {
        if (startMs < 0L) {
            throw new IllegalArgumentException("Window startMs time cannot be negative.");
        }
        if (endMs < startMs) {
            throw new IllegalArgumentException("Window endMs time cannot be smaller than window startMs time.");
        }
        this.startMs = startMs;
        this.endMs = endMs;
    }

    public long start() {
        return this.startMs;
    }

    public long end() {
        return this.endMs;
    }

    public abstract boolean overlap(Window var1);

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Window other = (Window)obj;
        return this.startMs == other.startMs && this.endMs == other.endMs;
    }

    public int hashCode() {
        return (int)((this.startMs << 32 | this.endMs) % 0xFFFFFFFFL);
    }

    public String toString() {
        return "Window{start=" + this.startMs + ", end=" + this.endMs + '}';
    }
}

