/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Map;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.AbstractStoreSupplier;
import org.apache.kafka.streams.state.internals.MemoryNavigableLRUCache;
import org.apache.kafka.streams.state.internals.MeteredKeyValueStore;

public class InMemoryLRUCacheStoreSupplier<K, V>
extends AbstractStoreSupplier<K, V, KeyValueStore> {
    private final int capacity;

    public InMemoryLRUCacheStoreSupplier(String name, int capacity, Serde<K> keySerde, Serde<V> valueSerde, boolean logged, Map<String, String> logConfig) {
        this(name, capacity, keySerde, valueSerde, null, logged, logConfig);
    }

    public InMemoryLRUCacheStoreSupplier(String name, int capacity, Serde<K> keySerde, Serde<V> valueSerde, Time time, boolean logged, Map<String, String> logConfig) {
        super(name, keySerde, valueSerde, time, logged, logConfig);
        this.capacity = capacity;
    }

    @Override
    public KeyValueStore get() {
        MemoryNavigableLRUCache cache = new MemoryNavigableLRUCache(this.name, this.capacity, this.keySerde, this.valueSerde);
        return new MeteredKeyValueStore(this.logged ? cache.enableLogging() : cache, "in-memory-lru-state", this.time);
    }
}

