/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.AbstractProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.StateManager;
import org.apache.kafka.streams.state.internals.ThreadCache;

public class GlobalProcessorContextImpl
extends AbstractProcessorContext {
    public GlobalProcessorContextImpl(StreamsConfig config, StateManager stateMgr, StreamsMetrics metrics, ThreadCache cache) {
        super(new TaskId(-1, -1), config.getString("application.id"), config, metrics, stateMgr, cache);
    }

    @Override
    public StateStore getStateStore(String name) {
        return this.stateManager.getGlobalStore(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> void forward(K key, V value) {
        ProcessorNode previousNode = this.currentNode();
        try {
            for (ProcessorNode<?, ?> child : this.currentNode().children()) {
                this.setCurrentNode(child);
                child.process(key, value);
            }
        }
        finally {
            this.setCurrentNode(previousNode);
        }
    }

    @Override
    public <K, V> void forward(K key, V value, int childIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <K, V> void forward(K key, V value, String childName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void commit() {
    }

    @Override
    public void schedule(long interval) {
        throw new UnsupportedOperationException();
    }
}

