/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorSupplier;

class KStreamMapValues<K, V, V1>
implements ProcessorSupplier<K, V> {
    private final ValueMapper<V, V1> mapper;

    public KStreamMapValues(ValueMapper<V, V1> mapper) {
        this.mapper = mapper;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamMapProcessor();
    }

    private class KStreamMapProcessor
    extends AbstractProcessor<K, V> {
        private KStreamMapProcessor() {
        }

        @Override
        public void process(K key, V value) {
            Object newValue = KStreamMapValues.this.mapper.apply(value);
            this.context().forward(key, newValue);
        }
    }
}

