/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.InvalidOffsetException;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Count;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.SampledStat;
import org.apache.kafka.common.metrics.stats.Sum;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.errors.TaskIdFormatException;
import org.apache.kafka.streams.processor.PartitionGrouper;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.TopologyBuilder;
import org.apache.kafka.streams.processor.internals.AbstractTask;
import org.apache.kafka.streams.processor.internals.AssignedTasks;
import org.apache.kafka.streams.processor.internals.ChangelogReader;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.StandbyTask;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StoreChangelogReader;
import org.apache.kafka.streams.processor.internals.StreamPartitionAssignor;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.StreamsMetadataState;
import org.apache.kafka.streams.processor.internals.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.ThreadStateTransitionValidator;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(StreamThread.class);
    private static final AtomicInteger STREAM_THREAD_ID_SEQUENCE = new AtomicInteger(1);
    private volatile State state = State.CREATED;
    private final Object stateLock = new Object();
    private StateListener stateListener = null;
    final PartitionGrouper partitionGrouper;
    private final StreamsMetadataState streamsMetadataState;
    public final String applicationId;
    public final String clientId;
    public final UUID processId;
    protected final StreamsConfig config;
    protected final TopologyBuilder builder;
    Producer<byte[], byte[]> threadProducer;
    private final KafkaClientSupplier clientSupplier;
    protected final Consumer<byte[], byte[]> consumer;
    final Consumer<byte[], byte[]> restoreConsumer;
    private final String logPrefix;
    private final String threadClientId;
    private final Pattern sourceTopicPattern;
    private final AssignedTasks<StreamTask> active;
    private final AssignedTasks<StandbyTask> standby;
    private final Time time;
    private final long pollTimeMs;
    private final long commitTimeMs;
    private final StreamsMetricsThreadImpl streamsMetrics;
    final StateDirectory stateDirectory;
    private String originalReset;
    private StreamPartitionAssignor partitionAssignor;
    private long timerStartedMs;
    private long lastCommitMs;
    private Throwable rebalanceException = null;
    private final boolean eosEnabled;
    private Map<TopicPartition, List<ConsumerRecord<byte[], byte[]>>> standbyRecords;
    private boolean processStandbyRecords = false;
    private final ThreadCache cache;
    final StoreChangelogReader storeChangelogReader;
    private final TaskCreator taskCreator = new TaskCreator();
    final ConsumerRebalanceListener rebalanceListener;
    private static final int UNLIMITED_RECORDS = -1;

    public StreamThread(TopologyBuilder builder, StreamsConfig config, KafkaClientSupplier clientSupplier, String applicationId, String clientId, UUID processId, Metrics metrics, Time time, StreamsMetadataState streamsMetadataState, long cacheSizeBytes, StateDirectory stateDirectory) {
        super(clientId + "-StreamThread-" + STREAM_THREAD_ID_SEQUENCE.getAndIncrement());
        this.applicationId = applicationId;
        this.config = config;
        this.builder = builder;
        this.clientSupplier = clientSupplier;
        this.sourceTopicPattern = builder.sourceTopicPattern();
        this.clientId = clientId;
        this.processId = processId;
        this.partitionGrouper = (PartitionGrouper)config.getConfiguredInstance("partition.grouper", PartitionGrouper.class);
        this.streamsMetadataState = streamsMetadataState;
        this.threadClientId = this.getName();
        this.logPrefix = String.format("stream-thread [%s]", this.threadClientId);
        this.streamsMetrics = new StreamsMetricsThreadImpl(metrics, "stream-metrics", "thread." + this.threadClientId, Collections.singletonMap("client-id", this.threadClientId));
        if (config.getLong("cache.max.bytes.buffering") < 0L) {
            log.warn("{} Negative cache size passed in thread. Reverting to cache size of 0 bytes", (Object)this.logPrefix);
        }
        this.cache = new ThreadCache(this.threadClientId, cacheSizeBytes, this.streamsMetrics);
        this.eosEnabled = "exactly_once".equals(config.getString("processing.guarantee"));
        log.info("{} Creating consumer client", (Object)this.logPrefix);
        Map<String, Object> consumerConfigs = config.getConsumerConfigs(this, applicationId, this.threadClientId);
        if (!builder.latestResetTopicsPattern().pattern().equals("") || !builder.earliestResetTopicsPattern().pattern().equals("")) {
            this.originalReset = (String)consumerConfigs.get("auto.offset.reset");
            log.info("{} Custom offset resets specified updating configs original auto offset reset {}", (Object)this.logPrefix, (Object)this.originalReset);
            consumerConfigs.put("auto.offset.reset", "none");
        }
        this.consumer = clientSupplier.getConsumer(consumerConfigs);
        log.info("{} Creating restore consumer client", (Object)this.logPrefix);
        this.restoreConsumer = clientSupplier.getRestoreConsumer(config.getRestoreConsumerConfigs(this.threadClientId));
        this.standbyRecords = new HashMap<TopicPartition, List<ConsumerRecord<byte[], byte[]>>>();
        this.stateDirectory = stateDirectory;
        this.pollTimeMs = config.getLong("poll.ms");
        this.commitTimeMs = config.getLong("commit.interval.ms");
        this.time = time;
        this.lastCommitMs = this.timerStartedMs = time.milliseconds();
        this.rebalanceListener = new RebalanceListener(time);
        this.active = new AssignedTasks(this.logPrefix, "stream task", Time.SYSTEM);
        this.standby = new AssignedTasks(this.logPrefix, "standby task", Time.SYSTEM);
        this.storeChangelogReader = new StoreChangelogReader(this.getName(), this.restoreConsumer);
    }

    @Override
    public void run() {
        log.info("{} Starting", (Object)this.logPrefix);
        this.setState(State.RUNNING);
        boolean cleanRun = false;
        try {
            this.runLoop();
            cleanRun = true;
        }
        catch (KafkaException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("{} Encountered the following error during processing:", (Object)this.logPrefix, (Object)e);
            throw e;
        }
        finally {
            this.shutdown(cleanRun);
        }
    }

    private void runLoop() {
        long recordsProcessedBeforeCommit = -1L;
        this.consumer.subscribe(this.sourceTopicPattern, this.rebalanceListener);
        while (this.stillRunning()) {
            recordsProcessedBeforeCommit = this.runOnce(recordsProcessedBeforeCommit);
        }
        log.info("{} Shutting down at user request", (Object)this.logPrefix);
    }

    long runOnce(long recordsProcessedBeforeCommit) {
        ConsumerRecords<byte[], byte[]> records;
        this.timerStartedMs = this.time.milliseconds();
        if (this.state == State.PARTITIONS_ASSIGNED) {
            records = this.pollRequests(0L);
            this.tryTransitToRunning();
        } else {
            records = this.pollRequests(this.pollTimeMs);
            if (this.state == State.PARTITIONS_ASSIGNED) {
                this.tryTransitToRunning();
            }
        }
        if (records != null && !records.isEmpty() && this.active.hasRunningTasks()) {
            this.streamsMetrics.pollTimeSensor.record((double)this.computeLatency(), this.timerStartedMs);
            this.addRecordsToTasks(records);
            long totalProcessed = this.processAndPunctuate(recordsProcessedBeforeCommit);
            if (totalProcessed > 0L) {
                long processLatency = this.computeLatency();
                this.streamsMetrics.processTimeSensor.record((double)processLatency / (double)totalProcessed, this.timerStartedMs);
                recordsProcessedBeforeCommit = this.adjustRecordsProcessedBeforeCommit(recordsProcessedBeforeCommit, totalProcessed, processLatency, this.commitTimeMs);
            }
        }
        this.maybeCommit(this.timerStartedMs);
        this.maybeUpdateStandbyTasks(this.timerStartedMs);
        return recordsProcessedBeforeCommit;
    }

    private void tryTransitToRunning() {
        this.active.initializeNewTasks();
        this.standby.initializeNewTasks();
        Collection<TopicPartition> restored = this.storeChangelogReader.restore();
        Set<TopicPartition> resumed = this.active.updateRestored(restored);
        if (!resumed.isEmpty()) {
            log.trace("{} resuming partitions {}", (Object)this.logPrefix, resumed);
            this.consumer.resume(resumed);
        }
        if (this.active.allTasksRunning()) {
            this.assignStandbyPartitions();
            this.setState(State.RUNNING);
        }
    }

    private ConsumerRecords<byte[], byte[]> pollRequests(long pollTimeMs) {
        ConsumerRecords records = null;
        try {
            records = this.consumer.poll(pollTimeMs);
        }
        catch (InvalidOffsetException e) {
            this.resetInvalidOffsets(e);
        }
        if (this.rebalanceException != null && !(this.rebalanceException instanceof ProducerFencedException)) {
            throw new StreamsException(this.logPrefix + " Failed to rebalance.", this.rebalanceException);
        }
        return records;
    }

    private void resetInvalidOffsets(InvalidOffsetException e) {
        Set partitions = e.partitions();
        HashSet<String> loggedTopics = new HashSet<String>();
        HashSet<TopicPartition> seekToBeginning = new HashSet<TopicPartition>();
        HashSet<TopicPartition> seekToEnd = new HashSet<TopicPartition>();
        for (TopicPartition partition : partitions) {
            if (this.builder.earliestResetTopicsPattern().matcher(partition.topic()).matches()) {
                this.addToResetList(partition, seekToBeginning, "{} Setting topic '{}' to consume from {} offset", "earliest", loggedTopics);
                continue;
            }
            if (this.builder.latestResetTopicsPattern().matcher(partition.topic()).matches()) {
                this.addToResetList(partition, seekToEnd, "{} Setting topic '{}' to consume from {} offset", "latest", loggedTopics);
                continue;
            }
            if (this.originalReset == null || !this.originalReset.equals("earliest") && !this.originalReset.equals("latest")) {
                this.setState(State.PENDING_SHUTDOWN);
                String errorMessage = "No valid committed offset found for input topic %s (partition %s) and no valid reset policy configured. You need to set configuration parameter \"auto.offset.reset\" or specify a topic specific reset policy via KStreamBuilder#stream(StreamsConfig.AutoOffsetReset offsetReset, ...) or KStreamBuilder#table(StreamsConfig.AutoOffsetReset offsetReset, ...)";
                throw new StreamsException(String.format("No valid committed offset found for input topic %s (partition %s) and no valid reset policy configured. You need to set configuration parameter \"auto.offset.reset\" or specify a topic specific reset policy via KStreamBuilder#stream(StreamsConfig.AutoOffsetReset offsetReset, ...) or KStreamBuilder#table(StreamsConfig.AutoOffsetReset offsetReset, ...)", partition.topic(), partition.partition()), e);
            }
            if (this.originalReset.equals("earliest")) {
                this.addToResetList(partition, seekToBeginning, "{} No custom setting defined for topic '{}' using original config '{}' for offset reset", "earliest", loggedTopics);
                continue;
            }
            if (!this.originalReset.equals("latest")) continue;
            this.addToResetList(partition, seekToEnd, "{} No custom setting defined for topic '{}' using original config '{}' for offset reset", "latest", loggedTopics);
        }
        if (!seekToBeginning.isEmpty()) {
            this.consumer.seekToBeginning(seekToBeginning);
        }
        if (!seekToEnd.isEmpty()) {
            this.consumer.seekToEnd(seekToEnd);
        }
    }

    private void addToResetList(TopicPartition partition, Set<TopicPartition> partitions, String logMessage, String resetPolicy, Set<String> loggedTopics) {
        String topic = partition.topic();
        if (loggedTopics.add(topic)) {
            log.info(logMessage, new Object[]{this.logPrefix, topic, resetPolicy});
        }
        partitions.add(partition);
    }

    private void addRecordsToTasks(ConsumerRecords<byte[], byte[]> records) {
        if (records != null && !records.isEmpty()) {
            int numAddedRecords = 0;
            for (TopicPartition partition : records.partitions()) {
                StreamTask task = this.active.runningTaskFor(partition);
                numAddedRecords += task.addRecords(partition, records.records(partition));
            }
            this.streamsMetrics.skippedRecordsSensor.record((double)(records.count() - numAddedRecords), this.timerStartedMs);
        }
    }

    private long processAndPunctuate(long recordsProcessedBeforeCommit) {
        int processed;
        long totalProcessedSinceLastMaybeCommit = 0L;
        do {
            processed = this.active.process();
            if (recordsProcessedBeforeCommit == -1L || (totalProcessedSinceLastMaybeCommit += (long)processed) < recordsProcessedBeforeCommit) continue;
            totalProcessedSinceLastMaybeCommit = 0L;
            long processLatency = this.computeLatency();
            this.streamsMetrics.processTimeSensor.record((double)processLatency / (double)totalProcessedSinceLastMaybeCommit, this.timerStartedMs);
            this.maybeCommit(this.timerStartedMs);
        } while (processed != 0);
        this.active.punctuateAndCommit(this.streamsMetrics.commitTimeSensor, this.streamsMetrics.punctuateTimeSensor);
        return totalProcessedSinceLastMaybeCommit;
    }

    private long adjustRecordsProcessedBeforeCommit(long prevRecordsProcessedBeforeCommit, long totalProcessed, long processLatency, long commitTime) {
        long recordsProcessedBeforeCommit = -1L;
        if (processLatency > 0L && processLatency > commitTime) {
            recordsProcessedBeforeCommit = Math.max(1L, commitTime * totalProcessed / processLatency);
            log.debug("{} processing latency {} > commit time {} for {} records. Adjusting down recordsProcessedBeforeCommit={}", new Object[]{this.logPrefix, processLatency, commitTime, totalProcessed, recordsProcessedBeforeCommit});
        } else if (prevRecordsProcessedBeforeCommit != -1L && processLatency > 0L) {
            recordsProcessedBeforeCommit = Math.max(1L, commitTime * totalProcessed / processLatency);
            log.debug("{} processing latency {} < commit time {} for {} records. Adjusting up recordsProcessedBeforeCommit={}", new Object[]{this.logPrefix, processLatency, commitTime, totalProcessed, recordsProcessedBeforeCommit});
        }
        return recordsProcessedBeforeCommit;
    }

    protected void maybeCommit(long now) {
        if (this.commitTimeMs >= 0L && this.lastCommitMs + this.commitTimeMs < now) {
            if (log.isTraceEnabled()) {
                log.trace("{} Committing all active tasks {} and standby tasks {} since {}ms has elapsed (commit interval is {}ms)", new Object[]{this.logPrefix, this.active.runningTaskIds(), this.standby.runningTaskIds(), now - this.lastCommitMs, this.commitTimeMs});
            }
            this.commitAll();
            if (log.isDebugEnabled()) {
                log.info("{} Committed all active tasks {} and standby tasks {} in {}ms", new Object[]{this.logPrefix, this.active.runningTaskIds(), this.standby.runningTaskIds(), this.timerStartedMs - now});
            }
            this.lastCommitMs = now;
            this.processStandbyRecords = true;
        }
    }

    private void commitAll() {
        this.active.commit();
        this.standby.commit();
    }

    private void assignStandbyPartitions() {
        Collection<StandbyTask> running = this.standby.runningTasks();
        HashMap<TopicPartition, Long> checkpointedOffsets = new HashMap<TopicPartition, Long>();
        for (StandbyTask standbyTask : running) {
            checkpointedOffsets.putAll(standbyTask.checkpointedOffsets());
        }
        ArrayList assignment = new ArrayList(checkpointedOffsets.keySet());
        this.restoreConsumer.assign(assignment);
        for (Map.Entry entry : checkpointedOffsets.entrySet()) {
            TopicPartition partition = (TopicPartition)entry.getKey();
            long offset = (Long)entry.getValue();
            if (offset >= 0L) {
                this.restoreConsumer.seek(partition, offset);
                continue;
            }
            this.restoreConsumer.seekToBeginning(Collections.singleton(partition));
        }
        log.trace("{} assigned {} partitions to restore consumer for standby tasks {}", new Object[]{this.logPrefix, assignment, this.standby.runningTaskIds()});
    }

    private void maybeUpdateStandbyTasks(long now) {
        if (this.state == State.RUNNING && this.standby.hasRunningTasks()) {
            ConsumerRecords records;
            List<ConsumerRecord<byte[], byte[]>> remaining;
            if (this.processStandbyRecords) {
                if (!this.standbyRecords.isEmpty()) {
                    HashMap<TopicPartition, List<ConsumerRecord<byte[], byte[]>>> remainingStandbyRecords = new HashMap<TopicPartition, List<ConsumerRecord<byte[], byte[]>>>();
                    for (Map.Entry entry : this.standbyRecords.entrySet()) {
                        TopicPartition partition = (TopicPartition)entry.getKey();
                        remaining = (List<ConsumerRecord<byte[], byte[]>>)entry.getValue();
                        if (remaining == null) continue;
                        StandbyTask task = this.standby.runningTaskFor(partition);
                        remaining = task.update(partition, remaining);
                        if (remaining != null) {
                            remainingStandbyRecords.put(partition, remaining);
                            continue;
                        }
                        this.restoreConsumer.resume(Collections.singleton(partition));
                    }
                    this.standbyRecords = remainingStandbyRecords;
                    log.debug("{} Updated standby tasks {} in {}ms", new Object[]{this.logPrefix, this.standby.runningTaskIds(), this.time.milliseconds() - now});
                }
                this.processStandbyRecords = false;
            }
            if (!(records = this.restoreConsumer.poll(0L)).isEmpty()) {
                for (TopicPartition topicPartition : records.partitions()) {
                    StandbyTask task = this.standby.runningTaskFor(topicPartition);
                    if (task == null) {
                        throw new StreamsException(this.logPrefix + " Missing standby task for partition " + topicPartition);
                    }
                    remaining = task.update(topicPartition, records.records(topicPartition));
                    if (remaining == null) continue;
                    this.restoreConsumer.pause(Collections.singleton(topicPartition));
                    this.standbyRecords.put(topicPartition, remaining);
                }
            }
        }
    }

    private long computeLatency() {
        long previousTimeMs = this.timerStartedMs;
        this.timerStartedMs = this.time.milliseconds();
        return Math.max(this.timerStartedMs - previousTimeMs, 0L);
    }

    public synchronized void close() {
        log.info("{} Informed thread to shut down", (Object)this.logPrefix);
        this.setState(State.PENDING_SHUTDOWN);
    }

    public boolean isInitialized() {
        return this.state == State.RUNNING;
    }

    public boolean stillRunning() {
        return this.state.isRunning();
    }

    public Map<TaskId, StreamTask> tasks() {
        return this.active.runningTaskMap();
    }

    public Set<TaskId> prevActiveTasks() {
        return Collections.unmodifiableSet(this.active.previousTaskIds());
    }

    public Set<TaskId> cachedTasks() {
        HashSet<TaskId> tasks = new HashSet<TaskId>();
        File[] stateDirs = this.stateDirectory.listTaskDirectories();
        if (stateDirs != null) {
            for (File dir : stateDirs) {
                try {
                    TaskId id = TaskId.parse(dir.getName());
                    if (!new File(dir, ".checkpoint").exists()) continue;
                    tasks.add(id);
                }
                catch (TaskIdFormatException e) {
                    // empty catch block
                }
            }
        }
        return tasks;
    }

    public void setStateListener(StateListener listener) {
        this.stateListener = listener;
    }

    public State state() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setState(State newState) {
        State oldState;
        Object object = this.stateLock;
        synchronized (object) {
            oldState = this.state;
            if (newState != State.DEAD && (this.state == State.PENDING_SHUTDOWN || this.state == State.DEAD)) {
                return false;
            }
            if (!this.state.isValidTransition(newState)) {
                log.warn("{} Unexpected state transition from {} to {}.", new Object[]{this.logPrefix, oldState, newState});
                throw new StreamsException(this.logPrefix + " Unexpected state transition from " + oldState + " to " + newState);
            }
            log.info("{} State transition from {} to {}.", new Object[]{this.logPrefix, oldState, newState});
            this.state = newState;
        }
        if (this.stateListener != null) {
            this.stateListener.onChange(this, this.state, oldState);
        }
        return true;
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder().append(indent).append("StreamsThread appId: ").append(this.applicationId).append("\n").append(indent).append("\tStreamsThread clientId: ").append(this.clientId).append("\n").append(indent).append("\tStreamsThread threadId: ").append(this.getName()).append("\n");
        sb.append(indent).append("\tActive tasks:\n");
        sb.append(this.active.toString(indent + "\t\t"));
        sb.append(indent).append("\tStandby tasks:\n");
        sb.append(this.standby.toString(indent + "\t\t"));
        sb.append("\n");
        return sb.toString();
    }

    String threadClientId() {
        return this.threadClientId;
    }

    void setPartitionAssignor(StreamPartitionAssignor partitionAssignor) {
        this.partitionAssignor = partitionAssignor;
    }

    void shutdown(boolean cleanRun) {
        log.info("{} Shutting down", (Object)this.logPrefix);
        this.setState(State.PENDING_SHUTDOWN);
        this.shutdownTasksAndState(cleanRun);
        if (this.threadProducer != null) {
            try {
                this.threadProducer.close();
            }
            catch (Throwable e) {
                log.error("{} Failed to close producer due to the following error:", (Object)this.logPrefix, (Object)e);
            }
        }
        try {
            this.consumer.close();
        }
        catch (Throwable e) {
            log.error("{} Failed to close consumer due to the following error:", (Object)this.logPrefix, (Object)e);
        }
        try {
            this.restoreConsumer.close();
        }
        catch (Throwable e) {
            log.error("{} Failed to close restore consumer due to the following error:", (Object)this.logPrefix, (Object)e);
        }
        try {
            this.partitionAssignor.close();
        }
        catch (Throwable e) {
            log.error("{} Failed to close KafkaStreamClient due to the following error:", (Object)this.logPrefix, (Object)e);
        }
        this.active.clear();
        this.standby.clear();
        log.info("{} Stream thread shutdown complete", (Object)this.logPrefix);
        this.setState(State.DEAD);
        this.streamsMetrics.removeAllSensors();
    }

    private void shutdownTasksAndState(boolean cleanRun) {
        log.debug("{} Shutting down all active tasks {}, standby tasks {}, suspended tasks {}, and suspended standby tasks {}", new Object[]{this.logPrefix, this.active.runningTaskIds(), this.standby.runningTaskIds(), this.active.previousTaskIds(), this.standby.previousTaskIds()});
        for (AbstractTask task : this.allTasks()) {
            try {
                task.close(cleanRun, false);
            }
            catch (RuntimeException e) {
                log.error("{} Failed while closing {} {} due to the following error:", new Object[]{this.logPrefix, task.getClass().getSimpleName(), task.id(), e});
            }
        }
        this.unAssignChangeLogPartitions();
    }

    private void suspendTasksAndState() {
        log.debug("{} Suspending all active tasks {} and standby tasks {}", new Object[]{this.logPrefix, this.active.runningTaskIds(), this.standby.runningTaskIds()});
        AtomicReference<Object> firstException = new AtomicReference<Object>(null);
        firstException.compareAndSet(null, this.active.suspend());
        firstException.compareAndSet(null, this.standby.suspend());
        firstException.compareAndSet(null, this.unAssignChangeLogPartitions());
        if (firstException.get() != null) {
            throw new StreamsException(this.logPrefix + " failed to suspend stream tasks", firstException.get());
        }
    }

    private RuntimeException unAssignChangeLogPartitions() {
        try {
            this.restoreConsumer.assign(Collections.emptyList());
        }
        catch (RuntimeException e) {
            log.error("{} Failed to un-assign change log partitions due to the following error:", (Object)this.logPrefix, (Object)e);
            return e;
        }
        return null;
    }

    private List<AbstractTask> allTasks() {
        List<AbstractTask> tasks = this.active.allInitializedTasks();
        tasks.addAll(this.standby.allInitializedTasks());
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeNonAssignedSuspendedTasks() {
        Map<TaskId, Set<TopicPartition>> newTaskAssignment = this.partitionAssignor.activeTasks();
        Iterator<StreamTask> suspendedTaskIterator = this.active.suspendedTasks().iterator();
        while (suspendedTaskIterator.hasNext()) {
            StreamTask task = suspendedTaskIterator.next();
            Set<TopicPartition> assignedPartitionsForTask = newTaskAssignment.get(task.id);
            if (task.partitions().equals(assignedPartitionsForTask)) continue;
            log.debug("{} Closing suspended and not re-assigned task {}", (Object)this.logPrefix, (Object)task.id());
            try {
                task.closeSuspended(true, false, null);
            }
            catch (Exception e) {
                log.error("{} Failed to close suspended task {} due to the following error:", new Object[]{this.logPrefix, task.id, e});
            }
            finally {
                suspendedTaskIterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeNonAssignedSuspendedStandbyTasks() {
        Set<TaskId> newStandbyTaskIds = this.partitionAssignor.standbyTasks().keySet();
        Iterator<StandbyTask> standByTaskIterator = this.standby.suspendedTasks().iterator();
        while (standByTaskIterator.hasNext()) {
            StandbyTask task = standByTaskIterator.next();
            if (newStandbyTaskIds.contains(task.id)) continue;
            log.debug("{} Closing suspended and not re-assigned standby task {}", (Object)this.logPrefix, (Object)task.id());
            try {
                task.close(true, false);
            }
            catch (Exception e) {
                log.error("{} Failed to remove suspended standby task {} due to the following error:", new Object[]{this.logPrefix, task.id(), e});
            }
            finally {
                standByTaskIterator.remove();
            }
        }
    }

    protected StreamTask createStreamTask(TaskId id, Collection<TopicPartition> partitions) {
        this.streamsMetrics.taskCreatedSensor.record();
        return new StreamTask(id, this.applicationId, partitions, this.builder.build(id.topicGroupId), this.consumer, this.storeChangelogReader, this.config, this.streamsMetrics, this.stateDirectory, this.cache, this.time, this.createProducer(id));
    }

    private Producer<byte[], byte[]> createProducer(TaskId id) {
        Producer<byte[], byte[]> producer;
        if (this.eosEnabled) {
            Map<String, Object> producerConfigs = this.config.getProducerConfigs(this.threadClientId + "-" + id);
            log.info("{} Creating producer client for task {}", (Object)this.logPrefix, (Object)id);
            producerConfigs.put("transactional.id", this.applicationId + "-" + id);
            producer = this.clientSupplier.getProducer(producerConfigs);
        } else {
            if (this.threadProducer == null) {
                Map<String, Object> producerConfigs = this.config.getProducerConfigs(this.threadClientId);
                log.info("{} Creating shared producer client", (Object)this.logPrefix);
                this.threadProducer = this.clientSupplier.getProducer(producerConfigs);
            }
            producer = this.threadProducer;
        }
        return producer;
    }

    private void addStreamTasks(Collection<TopicPartition> assignment) {
        if (this.partitionAssignor == null) {
            throw new IllegalStateException(this.logPrefix + " Partition assignor has not been initialized while adding stream tasks: this should not happen.");
        }
        HashMap<TaskId, Set<TopicPartition>> newTasks = new HashMap<TaskId, Set<TopicPartition>>();
        log.debug("{} Adding assigned tasks as active: {}", (Object)this.logPrefix, this.partitionAssignor.activeTasks());
        for (Map.Entry<TaskId, Set<TopicPartition>> entry : this.partitionAssignor.activeTasks().entrySet()) {
            TaskId taskId = entry.getKey();
            Set<TopicPartition> partitions = entry.getValue();
            if (assignment.containsAll(partitions)) {
                try {
                    if (this.active.maybeResumeSuspendedTask(taskId, partitions)) continue;
                    newTasks.put(taskId, partitions);
                    continue;
                }
                catch (StreamsException e) {
                    log.error("{} Failed to create an active task {} due to the following error:", new Object[]{this.logPrefix, taskId, e});
                    throw e;
                }
            }
            log.warn("{} Task {} owned partitions {} are not contained in the assignment {}", new Object[]{this.logPrefix, taskId, partitions, assignment});
        }
        log.trace("{} New active tasks to be created: {}", (Object)this.logPrefix, newTasks);
        this.taskCreator.createTasks(newTasks);
    }

    protected StandbyTask createStandbyTask(TaskId id, Collection<TopicPartition> partitions) {
        this.streamsMetrics.taskCreatedSensor.record();
        ProcessorTopology topology = this.builder.build(id.topicGroupId);
        if (!topology.stateStores().isEmpty()) {
            return new StandbyTask(id, this.applicationId, partitions, topology, this.consumer, (ChangelogReader)this.storeChangelogReader, this.config, this.streamsMetrics, this.stateDirectory);
        }
        log.trace("{} Skipped standby task {} with assigned partitions {} since it does not have any state stores to materialize", new Object[]{this.logPrefix, id, partitions});
        return null;
    }

    private void addStandbyTasks() {
        if (this.partitionAssignor == null) {
            throw new IllegalStateException(this.logPrefix + " Partition assignor has not been initialized while adding standby tasks: this should not happen.");
        }
        HashMap<TaskId, Set<TopicPartition>> newStandbyTasks = new HashMap<TaskId, Set<TopicPartition>>();
        log.debug("{} Adding assigned standby tasks {}", (Object)this.logPrefix, this.partitionAssignor.standbyTasks());
        for (Map.Entry<TaskId, Set<TopicPartition>> entry : this.partitionAssignor.standbyTasks().entrySet()) {
            Set<TopicPartition> partitions;
            TaskId taskId = entry.getKey();
            if (this.standby.maybeResumeSuspendedTask(taskId, partitions = entry.getValue())) continue;
            newStandbyTasks.put(taskId, partitions);
        }
        log.trace("{} New standby tasks to be created: {}", (Object)this.logPrefix, newStandbyTasks);
        new StandbyTaskCreator().createTasks(newStandbyTasks);
    }

    private class StreamsMetricsThreadImpl
    extends StreamsMetricsImpl {
        final Sensor commitTimeSensor;
        final Sensor pollTimeSensor;
        final Sensor processTimeSensor;
        final Sensor punctuateTimeSensor;
        final Sensor taskCreatedSensor;
        final Sensor tasksClosedSensor;
        final Sensor skippedRecordsSensor;

        StreamsMetricsThreadImpl(Metrics metrics, String groupName, String prefix, Map<String, String> tags) {
            super(metrics, groupName, tags);
            this.commitTimeSensor = metrics.sensor(prefix + ".commit-latency", Sensor.RecordingLevel.INFO);
            this.commitTimeSensor.add(metrics.metricName("commit-latency-avg", this.groupName, "The average commit time in ms", this.tags), (MeasurableStat)new Avg());
            this.commitTimeSensor.add(metrics.metricName("commit-latency-max", this.groupName, "The maximum commit time in ms", this.tags), (MeasurableStat)new Max());
            this.commitTimeSensor.add(metrics.metricName("commit-rate", this.groupName, "The average per-second number of commit calls", this.tags), (MeasurableStat)new Rate((SampledStat)new Count()));
            this.pollTimeSensor = metrics.sensor(prefix + ".poll-latency", Sensor.RecordingLevel.INFO);
            this.pollTimeSensor.add(metrics.metricName("poll-latency-avg", this.groupName, "The average poll time in ms", this.tags), (MeasurableStat)new Avg());
            this.pollTimeSensor.add(metrics.metricName("poll-latency-max", this.groupName, "The maximum poll time in ms", this.tags), (MeasurableStat)new Max());
            this.pollTimeSensor.add(metrics.metricName("poll-rate", this.groupName, "The average per-second number of record-poll calls", this.tags), (MeasurableStat)new Rate((SampledStat)new Count()));
            this.processTimeSensor = metrics.sensor(prefix + ".process-latency", Sensor.RecordingLevel.INFO);
            this.processTimeSensor.add(metrics.metricName("process-latency-avg", this.groupName, "The average process time in ms", this.tags), (MeasurableStat)new Avg());
            this.processTimeSensor.add(metrics.metricName("process-latency-max", this.groupName, "The maximum process time in ms", this.tags), (MeasurableStat)new Max());
            this.processTimeSensor.add(metrics.metricName("process-rate", this.groupName, "The average per-second number of process calls", this.tags), (MeasurableStat)new Rate((SampledStat)new Count()));
            this.punctuateTimeSensor = metrics.sensor(prefix + ".punctuate-latency", Sensor.RecordingLevel.INFO);
            this.punctuateTimeSensor.add(metrics.metricName("punctuate-latency-avg", this.groupName, "The average punctuate time in ms", this.tags), (MeasurableStat)new Avg());
            this.punctuateTimeSensor.add(metrics.metricName("punctuate-latency-max", this.groupName, "The maximum punctuate time in ms", this.tags), (MeasurableStat)new Max());
            this.punctuateTimeSensor.add(metrics.metricName("punctuate-rate", this.groupName, "The average per-second number of punctuate calls", this.tags), (MeasurableStat)new Rate((SampledStat)new Count()));
            this.taskCreatedSensor = metrics.sensor(prefix + ".task-created", Sensor.RecordingLevel.INFO);
            this.taskCreatedSensor.add(metrics.metricName("task-created-rate", this.groupName, "The average per-second number of newly created tasks", this.tags), (MeasurableStat)new Rate((SampledStat)new Count()));
            this.tasksClosedSensor = metrics.sensor(prefix + ".task-closed", Sensor.RecordingLevel.INFO);
            this.tasksClosedSensor.add(metrics.metricName("task-closed-rate", this.groupName, "The average per-second number of closed tasks", this.tags), (MeasurableStat)new Rate((SampledStat)new Count()));
            this.skippedRecordsSensor = metrics.sensor(prefix + ".skipped-records");
            this.skippedRecordsSensor.add(metrics.metricName("skipped-records-rate", this.groupName, "The average per-second number of skipped records.", this.tags), (MeasurableStat)new Rate((SampledStat)new Sum()));
        }

        @Override
        public void recordLatency(Sensor sensor, long startNs, long endNs) {
            sensor.record((double)(endNs - startNs), StreamThread.this.timerStartedMs);
        }

        void removeAllSensors() {
            this.removeSensor(this.commitTimeSensor);
            this.removeSensor(this.pollTimeSensor);
            this.removeSensor(this.processTimeSensor);
            this.removeSensor(this.punctuateTimeSensor);
            this.removeSensor(this.taskCreatedSensor);
            this.removeSensor(this.tasksClosedSensor);
            this.removeSensor(this.skippedRecordsSensor);
        }
    }

    class StandbyTaskCreator
    extends AbstractTaskCreator {
        StandbyTaskCreator() {
        }

        @Override
        void createTask(TaskId taskId, Set<TopicPartition> partitions) {
            StandbyTask task = StreamThread.this.createStandbyTask(taskId, partitions);
            if (task != null) {
                StreamThread.this.standby.addNewTask(task);
            }
        }
    }

    class TaskCreator
    extends AbstractTaskCreator {
        TaskCreator() {
        }

        @Override
        void createTask(TaskId taskId, Set<TopicPartition> partitions) {
            StreamThread.this.active.addNewTask(StreamThread.this.createStreamTask(taskId, partitions));
        }
    }

    abstract class AbstractTaskCreator {
        AbstractTaskCreator() {
        }

        void createTasks(Map<TaskId, Set<TopicPartition>> tasksToBeCreated) {
            for (Map.Entry<TaskId, Set<TopicPartition>> newTaskAndPartitions : tasksToBeCreated.entrySet()) {
                TaskId taskId = newTaskAndPartitions.getKey();
                Set<TopicPartition> partitions = newTaskAndPartitions.getValue();
                this.createTask(taskId, partitions);
            }
        }

        abstract void createTask(TaskId var1, Set<TopicPartition> var2);
    }

    private class RebalanceListener
    implements ConsumerRebalanceListener {
        private final Time time;

        RebalanceListener(Time time) {
            this.time = time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPartitionsAssigned(Collection<TopicPartition> assignment) {
            long start;
            block5: {
                log.debug("{} at state {}: new partitions {} assigned at the end of consumer rebalance.\n\tassigned active tasks: {}\n\tassigned standby tasks: {}\n\tcurrent suspended active tasks: {}\n\tcurrent suspended standby tasks: {}\n", new Object[]{StreamThread.this.logPrefix, StreamThread.this.state, assignment, StreamThread.this.partitionAssignor.activeTasks().keySet(), StreamThread.this.partitionAssignor.standbyTasks().keySet(), StreamThread.this.active.previousTaskIds(), StreamThread.this.standby.previousTaskIds()});
                start = this.time.milliseconds();
                if (StreamThread.this.setState(State.PARTITIONS_ASSIGNED)) break block5;
                log.info("{} partition assignment took {} ms.\n\tcurrent active tasks: {}\n\tcurrent standby tasks: {}\n\tprevious active tasks: {}\n", new Object[]{StreamThread.this.logPrefix, this.time.milliseconds() - start, StreamThread.this.active.allAssignedTaskIds(), StreamThread.this.standby.allAssignedTaskIds(), StreamThread.this.active.previousTaskIds()});
                return;
            }
            try {
                StreamThread.this.closeNonAssignedSuspendedStandbyTasks();
                StreamThread.this.closeNonAssignedSuspendedTasks();
                StreamThread.this.addStreamTasks(assignment);
                StreamThread.this.addStandbyTasks();
                StreamThread.this.streamsMetadataState.onChange(StreamThread.this.partitionAssignor.getPartitionsByHostState(), StreamThread.this.partitionAssignor.clusterMetadata());
                StreamThread.this.storeChangelogReader.reset();
                Set<TopicPartition> partitions = StreamThread.this.active.uninitializedPartitions();
                log.trace("{} pausing partitions: {}", (Object)StreamThread.this.logPrefix, partitions);
                StreamThread.this.consumer.pause(partitions);
            }
            catch (Throwable t) {
                try {
                    log.error("{} Error caught during partition assignment, will abort the current process and re-throw at the end of rebalance: {}", (Object)StreamThread.this.logPrefix, (Object)t.getMessage());
                    StreamThread.this.rebalanceException = t;
                }
                catch (Throwable throwable) {
                    log.info("{} partition assignment took {} ms.\n\tcurrent active tasks: {}\n\tcurrent standby tasks: {}\n\tprevious active tasks: {}\n", new Object[]{StreamThread.this.logPrefix, this.time.milliseconds() - start, StreamThread.this.active.allAssignedTaskIds(), StreamThread.this.standby.allAssignedTaskIds(), StreamThread.this.active.previousTaskIds()});
                    throw throwable;
                }
                log.info("{} partition assignment took {} ms.\n\tcurrent active tasks: {}\n\tcurrent standby tasks: {}\n\tprevious active tasks: {}\n", new Object[]{StreamThread.this.logPrefix, this.time.milliseconds() - start, StreamThread.this.active.allAssignedTaskIds(), StreamThread.this.standby.allAssignedTaskIds(), StreamThread.this.active.previousTaskIds()});
            }
            log.info("{} partition assignment took {} ms.\n\tcurrent active tasks: {}\n\tcurrent standby tasks: {}\n\tprevious active tasks: {}\n", new Object[]{StreamThread.this.logPrefix, this.time.milliseconds() - start, StreamThread.this.active.allAssignedTaskIds(), StreamThread.this.standby.allAssignedTaskIds(), StreamThread.this.active.previousTaskIds()});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPartitionsRevoked(Collection<TopicPartition> assignment) {
            log.debug("{} at state {}: partitions {} revoked at the beginning of consumer rebalance.\n\tcurrent assigned active tasks: {}\n\tcurrent assigned standby tasks: {}\n", new Object[]{StreamThread.this.logPrefix, StreamThread.this.state, assignment, StreamThread.this.active.runningTaskIds(), StreamThread.this.standby.runningTaskIds()});
            long start = this.time.milliseconds();
            try {
                StreamThread.this.setState(State.PARTITIONS_REVOKED);
                StreamThread.this.suspendTasksAndState();
                StreamThread.this.streamsMetadataState.onChange(Collections.emptyMap(), StreamThread.this.partitionAssignor.clusterMetadata());
                StreamThread.this.standbyRecords.clear();
            }
            catch (Throwable t) {
                try {
                    log.error("{} Error caught during partition revocation, will abort the current process and re-throw at the end of rebalance: {}", (Object)StreamThread.this.logPrefix, (Object)t.getMessage());
                    StreamThread.this.rebalanceException = t;
                    StreamThread.this.streamsMetadataState.onChange(Collections.emptyMap(), StreamThread.this.partitionAssignor.clusterMetadata());
                    StreamThread.this.standbyRecords.clear();
                }
                catch (Throwable throwable) {
                    StreamThread.this.streamsMetadataState.onChange(Collections.emptyMap(), StreamThread.this.partitionAssignor.clusterMetadata());
                    StreamThread.this.standbyRecords.clear();
                    log.info("{} partition revocation took {} ms.\n\tsuspended active tasks: {}\n\tsuspended standby tasks: {}", new Object[]{StreamThread.this.logPrefix, this.time.milliseconds() - start, StreamThread.this.active.suspendedTaskIds(), StreamThread.this.standby.suspendedTaskIds()});
                    throw throwable;
                }
                log.info("{} partition revocation took {} ms.\n\tsuspended active tasks: {}\n\tsuspended standby tasks: {}", new Object[]{StreamThread.this.logPrefix, this.time.milliseconds() - start, StreamThread.this.active.suspendedTaskIds(), StreamThread.this.standby.suspendedTaskIds()});
            }
            log.info("{} partition revocation took {} ms.\n\tsuspended active tasks: {}\n\tsuspended standby tasks: {}", new Object[]{StreamThread.this.logPrefix, this.time.milliseconds() - start, StreamThread.this.active.suspendedTaskIds(), StreamThread.this.standby.suspendedTaskIds()});
        }
    }

    public static interface StateListener {
        public void onChange(Thread var1, ThreadStateTransitionValidator var2, ThreadStateTransitionValidator var3);
    }

    public static enum State implements ThreadStateTransitionValidator
    {
        CREATED(1, 4),
        RUNNING(2, 4),
        PARTITIONS_REVOKED(2, 3, 4),
        PARTITIONS_ASSIGNED(1, 2, 4),
        PENDING_SHUTDOWN(5),
        DEAD(new Integer[0]);

        private final Set<Integer> validTransitions = new HashSet<Integer>();

        private State(Integer ... validTransitions) {
            this.validTransitions.addAll(Arrays.asList(validTransitions));
        }

        public boolean isRunning() {
            return !this.equals(PENDING_SHUTDOWN) && !this.equals(CREATED) && !this.equals(DEAD);
        }

        @Override
        public boolean isValidTransition(ThreadStateTransitionValidator newState) {
            State tmpState = (State)newState;
            return this.validTransitions.contains(tmpState.ordinal());
        }
    }
}

