/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.InnerMeteredKeyValueStore;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

public class MeteredKeyValueBytesStore<K, V>
extends WrappedStateStore.AbstractStateStore
implements KeyValueStore<K, V> {
    private final Serde<K> keySerde;
    private final Serde<V> valueSerde;
    private StateSerdes<K, V> serdes;
    private final InnerMeteredKeyValueStore<K, Bytes, V, byte[]> innerMetered;

    public MeteredKeyValueBytesStore(KeyValueStore<Bytes, byte[]> inner, String metricScope, Time time, Serde<K> keySerde, Serde<V> valueSerde) {
        super(inner);
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.innerMetered = new InnerMeteredKeyValueStore(inner, metricScope, new InnerMeteredKeyValueStore.TypeConverter<K, Bytes, V, byte[]>(){

            @Override
            public Bytes innerKey(K key) {
                return Bytes.wrap((byte[])MeteredKeyValueBytesStore.this.serdes.rawKey(key));
            }

            @Override
            public byte[] innerValue(V value) {
                if (value == null) {
                    return null;
                }
                return MeteredKeyValueBytesStore.this.serdes.rawValue(value);
            }

            @Override
            public List<KeyValue<Bytes, byte[]>> innerEntries(List<KeyValue<K, V>> from) {
                ArrayList<KeyValue<Bytes, byte[]>> byteEntries = new ArrayList<KeyValue<Bytes, byte[]>>();
                for (KeyValue entry : from) {
                    byteEntries.add(KeyValue.pair(this.innerKey((K)entry.key), MeteredKeyValueBytesStore.this.serdes.rawValue(entry.value)));
                }
                return byteEntries;
            }

            @Override
            public V outerValue(byte[] value) {
                return MeteredKeyValueBytesStore.this.serdes.valueFrom(value);
            }

            @Override
            public KeyValue<K, V> outerKeyValue(KeyValue<Bytes, byte[]> from) {
                return KeyValue.pair(MeteredKeyValueBytesStore.this.serdes.keyFrom(((Bytes)from.key).get()), MeteredKeyValueBytesStore.this.serdes.valueFrom((byte[])from.value));
            }

            @Override
            public K outerKey(Bytes key) {
                return MeteredKeyValueBytesStore.this.serdes.keyFrom(key.get());
            }
        }, time);
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.serdes = new StateSerdes(ProcessorStateManager.storeChangelogTopic(context.applicationId(), this.name()), (Serde<?>)(this.keySerde == null ? context.keySerde() : this.keySerde), (Serde<?>)(this.valueSerde == null ? context.valueSerde() : this.valueSerde));
        this.innerMetered.init(context, root);
    }

    @Override
    public long approximateNumEntries() {
        return this.innerMetered.approximateNumEntries();
    }

    @Override
    public V get(K key) {
        return this.innerMetered.get(key);
    }

    @Override
    public void put(K key, V value) {
        this.innerMetered.put(key, value);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.innerMetered.putIfAbsent(key, value);
    }

    @Override
    public void putAll(List<KeyValue<K, V>> entries) {
        this.innerMetered.putAll(entries);
    }

    @Override
    public V delete(K key) {
        return this.innerMetered.delete(key);
    }

    @Override
    public KeyValueIterator<K, V> range(K from, K to) {
        return this.innerMetered.range(from, to);
    }

    @Override
    public KeyValueIterator<K, V> all() {
        return this.innerMetered.all();
    }

    @Override
    public void flush() {
        this.innerMetered.flush();
    }
}

