/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Objects;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.MeteredWindowedKeyValueIterator;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

public class MeteredSessionStore<K, V>
extends WrappedStateStore.AbstractStateStore
implements SessionStore<K, V> {
    private final SessionStore<Bytes, byte[]> inner;
    private final String metricScope;
    private final Serde<K> keySerde;
    private final Serde<V> valueSerde;
    private final Time time;
    private StateSerdes<K, V> serdes;
    private StreamsMetrics metrics;
    private Sensor putTime;
    private Sensor fetchTime;
    private Sensor flushTime;
    private Sensor removeTime;

    MeteredSessionStore(SessionStore<Bytes, byte[]> inner, String metricScope, Serde<K> keySerde, Serde<V> valueSerde, Time time) {
        super(inner);
        this.inner = inner;
        this.metricScope = metricScope;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.time = time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.serdes = new StateSerdes(ProcessorStateManager.storeChangelogTopic(context.applicationId(), this.name()), (Serde<?>)(this.keySerde == null ? context.keySerde() : this.keySerde), (Serde<?>)(this.valueSerde == null ? context.valueSerde() : this.valueSerde));
        String tagKey = "task-id";
        String tagValue = context.taskId().toString();
        this.metrics = context.metrics();
        this.putTime = this.metrics.addLatencyAndThroughputSensor(this.metricScope, this.name(), "put", Sensor.RecordingLevel.DEBUG, "task-id", tagValue);
        this.fetchTime = this.metrics.addLatencyAndThroughputSensor(this.metricScope, this.name(), "fetch", Sensor.RecordingLevel.DEBUG, "task-id", tagValue);
        this.flushTime = this.metrics.addLatencyAndThroughputSensor(this.metricScope, this.name(), "flush", Sensor.RecordingLevel.DEBUG, "task-id", tagValue);
        this.removeTime = this.metrics.addLatencyAndThroughputSensor(this.metricScope, this.name(), "remove", Sensor.RecordingLevel.DEBUG, "task-id", tagValue);
        Sensor restoreTime = this.metrics.addLatencyAndThroughputSensor(this.metricScope, this.name(), "restore", Sensor.RecordingLevel.DEBUG, "task-id", tagValue);
        long startNs = this.time.nanoseconds();
        try {
            this.inner.init(context, root);
        }
        finally {
            this.metrics.recordLatency(restoreTime, startNs, this.time.nanoseconds());
        }
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> findSessions(K key, long earliestSessionEndTime, long latestSessionStartTime) {
        Objects.requireNonNull(key, "key cannot be null");
        Bytes bytesKey = this.keyBytes(key);
        return new MeteredWindowedKeyValueIterator<K, V>(this.inner.findSessions(bytesKey, earliestSessionEndTime, latestSessionStartTime), this.fetchTime, this.metrics, this.serdes, this.time);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> findSessions(K keyFrom, K keyTo, long earliestSessionEndTime, long latestSessionStartTime) {
        Objects.requireNonNull(keyFrom, "keyFrom cannot be null");
        Objects.requireNonNull(keyTo, "keyTo cannot be null");
        Bytes bytesKeyFrom = this.keyBytes(keyFrom);
        Bytes bytesKeyTo = this.keyBytes(keyTo);
        return new MeteredWindowedKeyValueIterator<K, V>(this.inner.findSessions(bytesKeyFrom, bytesKeyTo, earliestSessionEndTime, latestSessionStartTime), this.fetchTime, this.metrics, this.serdes, this.time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Windowed<K> sessionKey) {
        Objects.requireNonNull(sessionKey, "sessionKey can't be null");
        long startNs = this.time.nanoseconds();
        try {
            Bytes key = this.keyBytes(sessionKey.key());
            this.inner.remove(new Windowed<Bytes>(key, sessionKey.window()));
        }
        finally {
            this.metrics.recordLatency(this.removeTime, startNs, this.time.nanoseconds());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Windowed<K> sessionKey, V aggregate) {
        Objects.requireNonNull(sessionKey, "sessionKey can't be null");
        long startNs = this.time.nanoseconds();
        try {
            Bytes key = this.keyBytes(sessionKey.key());
            this.inner.put(new Windowed<Bytes>(key, sessionKey.window()), this.serdes.rawValue(aggregate));
        }
        finally {
            this.metrics.recordLatency(this.putTime, startNs, this.time.nanoseconds());
        }
    }

    private Bytes keyBytes(K key) {
        return Bytes.wrap((byte[])this.serdes.rawKey(key));
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetch(K key) {
        Objects.requireNonNull(key, "key cannot be null");
        return this.findSessions(key, 0L, Long.MAX_VALUE);
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetch(K from, K to) {
        Objects.requireNonNull(from, "from cannot be null");
        Objects.requireNonNull(to, "to cannot be null");
        return this.findSessions(from, to, 0L, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        long startNs = this.time.nanoseconds();
        try {
            this.inner.flush();
        }
        finally {
            this.metrics.recordLatency(this.flushTime, startNs, this.time.nanoseconds());
        }
    }
}

