/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.kafka.streams.kstream.internals.StreamsTopologyGraph;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;

abstract class StreamsGraphNode {
    private StreamsGraphNode parentNode;
    private final Collection<StreamsGraphNode> childNodes = new LinkedHashSet<StreamsGraphNode>();
    private final String processorNodeName;
    private String parentProcessorNodeName;
    private boolean repartitionRequired;
    private boolean triggersRepartitioning;
    private Integer id;
    private StreamsTopologyGraph streamsTopologyGraph;

    StreamsGraphNode(String parentProcessorNodeName, String processorNodeName, boolean repartitionRequired) {
        this.parentProcessorNodeName = parentProcessorNodeName;
        this.processorNodeName = processorNodeName;
        this.repartitionRequired = repartitionRequired;
    }

    StreamsGraphNode parentNode() {
        return this.parentNode;
    }

    String parentProcessorNodeName() {
        return this.parentProcessorNodeName;
    }

    void setParentProcessorNodeName(String parentProcessorNodeName) {
        this.parentProcessorNodeName = parentProcessorNodeName;
    }

    void setParentNode(StreamsGraphNode parentNode) {
        this.parentNode = parentNode;
    }

    Collection<StreamsGraphNode> children() {
        return new LinkedHashSet<StreamsGraphNode>(this.childNodes);
    }

    void addChildNode(StreamsGraphNode node) {
        this.childNodes.add(node);
    }

    String processorNodeName() {
        return this.processorNodeName;
    }

    boolean repartitionRequired() {
        return this.repartitionRequired;
    }

    void setRepartitionRequired(boolean repartitionRequired) {
        this.repartitionRequired = repartitionRequired;
    }

    public boolean triggersRepartitioning() {
        return this.triggersRepartitioning;
    }

    public void setTriggersRepartitioning(boolean triggersRepartitioning) {
        this.triggersRepartitioning = triggersRepartitioning;
    }

    void setId(int id) {
        this.id = id;
    }

    Integer id() {
        return this.id;
    }

    public void setStreamsTopologyGraph(StreamsTopologyGraph streamsTopologyGraph) {
        this.streamsTopologyGraph = streamsTopologyGraph;
    }

    StreamsTopologyGraph streamsTopologyGraph() {
        return this.streamsTopologyGraph;
    }

    abstract void writeToTopology(InternalTopologyBuilder var1);
}

