/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.streams.processor.internals.InternalTopicConfig;

public class RepartitionTopicConfig
extends InternalTopicConfig {
    private static final Map<String, String> REPARTITION_TOPIC_DEFAULT_OVERRIDES;

    public RepartitionTopicConfig(String name, Map<String, String> topicConfigs) {
        super(name, topicConfigs);
    }

    @Override
    public Map<String, String> getProperties(Map<String, String> defaultProperties, long additionalRetentionMs) {
        HashMap<String, String> topicConfig = new HashMap<String, String>(REPARTITION_TOPIC_DEFAULT_OVERRIDES);
        topicConfig.putAll(defaultProperties);
        topicConfig.putAll(this.topicConfigs);
        return topicConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepartitionTopicConfig that = (RepartitionTopicConfig)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.topicConfigs, that.topicConfigs);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.topicConfigs);
    }

    @Override
    public String toString() {
        return "RepartitionTopicConfig(name=" + this.name + ", topicConfigs=" + this.topicConfigs + ")";
    }

    static {
        HashMap<String, String> tempTopicDefaultOverrides = new HashMap<String, String>();
        tempTopicDefaultOverrides.put("cleanup.policy", "delete");
        tempTopicDefaultOverrides.put("segment.index.bytes", "52428800");
        tempTopicDefaultOverrides.put("segment.bytes", "52428800");
        tempTopicDefaultOverrides.put("segment.ms", "600000");
        tempTopicDefaultOverrides.put("retention.ms", String.valueOf(Long.MAX_VALUE));
        REPARTITION_TOPIC_DEFAULT_OVERRIDES = Collections.unmodifiableMap(tempTopicDefaultOverrides);
    }
}

