/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.util.Map;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.internals.InternalNameProvider;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.StoreSupplier;

public class MaterializedInternal<K, V, S extends StateStore>
extends Materialized<K, V, S> {
    private final boolean queriable = this.storeName() != null;

    public MaterializedInternal(Materialized<K, V, S> materialized) {
        super(materialized);
    }

    public void generateStoreNameIfNeeded(InternalNameProvider nameProvider, String generatedStorePrefix) {
        if (this.storeName() == null) {
            this.storeName = nameProvider.newStoreName(generatedStorePrefix);
        }
    }

    public String storeName() {
        if (this.storeSupplier != null) {
            return this.storeSupplier.name();
        }
        return this.storeName;
    }

    public StoreSupplier<S> storeSupplier() {
        return this.storeSupplier;
    }

    public Serde<K> keySerde() {
        return this.keySerde;
    }

    public Serde<V> valueSerde() {
        return this.valueSerde;
    }

    public boolean loggingEnabled() {
        return this.loggingEnabled;
    }

    Map<String, String> logConfig() {
        return this.topicConfig;
    }

    public boolean cachingEnabled() {
        return this.cachingEnabled;
    }

    public boolean isQueryable() {
        return this.queriable;
    }

    Duration retention() {
        return this.retention;
    }
}

