/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Merger;
import org.apache.kafka.streams.kstream.Reducer;
import org.apache.kafka.streams.kstream.SessionWindowedKStream;
import org.apache.kafka.streams.kstream.SessionWindows;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.WindowedSerdes;
import org.apache.kafka.streams.kstream.internals.AbstractStream;
import org.apache.kafka.streams.kstream.internals.GroupedStreamAggregateBuilder;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.kstream.internals.KStreamSessionWindowAggregate;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.kstream.internals.graph.StreamsGraphNode;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;

public class SessionWindowedKStreamImpl<K, V>
extends AbstractStream<K, V>
implements SessionWindowedKStream<K, V> {
    private final SessionWindows windows;
    private final GroupedStreamAggregateBuilder<K, V> aggregateBuilder;
    private final Merger<K, Long> countMerger = (aggKey, aggOne, aggTwo) -> aggOne + aggTwo;

    SessionWindowedKStreamImpl(SessionWindows windows, InternalStreamsBuilder builder, Set<String> sourceNodes, String name, Serde<K> keySerde, Serde<V> valSerde, GroupedStreamAggregateBuilder<K, V> aggregateBuilder, StreamsGraphNode streamsGraphNode) {
        super(name, keySerde, valSerde, sourceNodes, streamsGraphNode, builder);
        Objects.requireNonNull(windows, "windows can't be null");
        this.windows = windows;
        this.aggregateBuilder = aggregateBuilder;
    }

    @Override
    public KTable<Windowed<K>, Long> count() {
        return this.doCount(Materialized.with(this.keySerde, Serdes.Long()));
    }

    @Override
    public KTable<Windowed<K>, Long> count(Materialized<K, Long, SessionStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(materialized, "materialized can't be null");
        if (new MaterializedInternal<K, Long, SessionStore<Bytes, byte[]>>(materialized).storeName() == null) {
            this.builder.newStoreName("KSTREAM-AGGREGATE-");
        }
        return this.doCount(materialized);
    }

    private KTable<Windowed<K>, Long> doCount(Materialized<K, Long, SessionStore<Bytes, byte[]>> materialized) {
        MaterializedInternal<K, Long, SessionStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, Long, SessionStore<Bytes, byte[]>>(materialized);
        materializedInternal.generateStoreNameIfNeeded(this.builder, "KSTREAM-AGGREGATE-");
        if (materializedInternal.keySerde() == null) {
            materializedInternal.withKeySerde(this.keySerde);
        }
        if (materializedInternal.valueSerde() == null) {
            materializedInternal.withValueSerde((Serde<Long>)Serdes.Long());
        }
        return this.aggregateBuilder.build("KSTREAM-AGGREGATE-", (StoreBuilder<StateStore>)this.materialize(materializedInternal), new KStreamSessionWindowAggregate(this.windows, materializedInternal.storeName(), this.aggregateBuilder.countInitializer, this.aggregateBuilder.countAggregator, this.countMerger), materializedInternal.isQueryable(), materializedInternal.keySerde() != null ? new WindowedSerdes.SessionWindowedSerde<K>(materializedInternal.keySerde()) : null, materializedInternal.valueSerde());
    }

    @Override
    public KTable<Windowed<K>, V> reduce(Reducer<V> reducer) {
        return this.reduce(reducer, Materialized.with(this.keySerde, this.valSerde));
    }

    @Override
    public KTable<Windowed<K>, V> reduce(Reducer<V> reducer, Materialized<K, V, SessionStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(reducer, "reducer can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        Aggregator<K, V, V> reduceAggregator = this.aggregatorForReducer(reducer);
        MaterializedInternal<K, V, SessionStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, V, SessionStore<Bytes, byte[]>>(materialized);
        materializedInternal.generateStoreNameIfNeeded(this.builder, "KSTREAM-REDUCE-");
        if (materializedInternal.keySerde() == null) {
            materializedInternal.withKeySerde(this.keySerde);
        }
        if (materializedInternal.valueSerde() == null) {
            materializedInternal.withValueSerde(this.valSerde);
        }
        return this.aggregateBuilder.build("KSTREAM-REDUCE-", (StoreBuilder<StateStore>)this.materialize(materializedInternal), new KStreamSessionWindowAggregate(this.windows, materializedInternal.storeName(), this.aggregateBuilder.reduceInitializer, reduceAggregator, this.mergerForAggregator(reduceAggregator)), materializedInternal.isQueryable(), materializedInternal.keySerde() != null ? new WindowedSerdes.SessionWindowedSerde<K>(materializedInternal.keySerde()) : null, materializedInternal.valueSerde());
    }

    @Override
    public <T> KTable<Windowed<K>, T> aggregate(Initializer<T> initializer, Aggregator<? super K, ? super V, T> aggregator, Merger<? super K, T> sessionMerger) {
        return this.aggregate(initializer, aggregator, sessionMerger, Materialized.with(this.keySerde, null));
    }

    @Override
    public <VR> KTable<Windowed<K>, VR> aggregate(Initializer<VR> initializer, Aggregator<? super K, ? super V, VR> aggregator, Merger<? super K, VR> sessionMerger, Materialized<K, VR, SessionStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(initializer, "initializer can't be null");
        Objects.requireNonNull(aggregator, "aggregator can't be null");
        Objects.requireNonNull(sessionMerger, "sessionMerger can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        MaterializedInternal<K, VR, SessionStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, VR, SessionStore<Bytes, byte[]>>(materialized);
        materializedInternal.generateStoreNameIfNeeded(this.builder, "KSTREAM-AGGREGATE-");
        if (materializedInternal.keySerde() == null) {
            materializedInternal.withKeySerde(this.keySerde);
        }
        return this.aggregateBuilder.build("KSTREAM-AGGREGATE-", (StoreBuilder<StateStore>)this.materialize(materializedInternal), new KStreamSessionWindowAggregate<K, V, VR>(this.windows, materializedInternal.storeName(), initializer, aggregator, sessionMerger), materializedInternal.isQueryable(), materializedInternal.keySerde() != null ? new WindowedSerdes.SessionWindowedSerde<K>(materializedInternal.keySerde()) : null, materializedInternal.valueSerde());
    }

    private <VR> StoreBuilder<SessionStore<K, VR>> materialize(MaterializedInternal<K, VR, SessionStore<Bytes, byte[]>> materialized) {
        SessionBytesStoreSupplier supplier = (SessionBytesStoreSupplier)materialized.storeSupplier();
        if (supplier == null) {
            long retentionPeriod;
            long l = retentionPeriod = materialized.retention() != null ? materialized.retention().toMillis() : this.windows.maintainMs();
            if (this.windows.inactivityGap() + this.windows.gracePeriodMs() > retentionPeriod) {
                throw new IllegalArgumentException("The retention period of the session store " + materialized.storeName() + " must be no smaller than the session inactivity gap plus the" + " grace period." + " Got gap=[" + this.windows.inactivityGap() + "]," + " grace=[" + this.windows.gracePeriodMs() + "]," + " retention=[" + retentionPeriod + "]");
            }
            supplier = Stores.persistentSessionStore(materialized.storeName(), retentionPeriod);
        }
        StoreBuilder<SessionStore<K, VR>> builder = Stores.sessionStoreBuilder(supplier, materialized.keySerde(), materialized.valueSerde());
        if (materialized.loggingEnabled()) {
            builder.withLoggingEnabled(materialized.logConfig());
        } else {
            builder.withLoggingDisabled();
        }
        if (materialized.cachingEnabled()) {
            builder.withCachingEnabled();
        }
        return builder;
    }

    private Merger<K, V> mergerForAggregator(Aggregator<K, V, V> aggregator) {
        return (aggKey, aggOne, aggTwo) -> aggregator.apply(aggKey, aggTwo, aggOne);
    }

    private Aggregator<K, V, V> aggregatorForReducer(Reducer<V> reducer) {
        return (aggKey, value, aggregate) -> aggregate == null ? value : reducer.apply(aggregate, value);
    }
}

