/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import java.util.Arrays;
import org.apache.kafka.streams.kstream.internals.KeyValueStoreMaterializer;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.kstream.internals.graph.StreamsGraphNode;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;

public class TableProcessorNode<K, V, S extends StateStore>
extends StreamsGraphNode {
    private final MaterializedInternal<K, V, S> materializedInternal;
    private final ProcessorParameters<K, V> processorParameters;
    private final String[] storeNames;

    public TableProcessorNode(String nodeName, ProcessorParameters<K, V> processorParameters, MaterializedInternal<K, V, S> materializedInternal, String[] storeNames) {
        super(nodeName, false);
        this.processorParameters = processorParameters;
        this.materializedInternal = materializedInternal;
        this.storeNames = storeNames != null ? storeNames : new String[]{};
    }

    @Override
    public String toString() {
        return "TableProcessorNode{materializedInternal=" + this.materializedInternal + ", processorParameters=" + this.processorParameters + ", storeNames=" + Arrays.toString(this.storeNames) + "} " + super.toString();
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        boolean shouldMaterialize = this.materializedInternal != null && this.materializedInternal.isQueryable();
        String processorName = this.processorParameters.processorName();
        topologyBuilder.addProcessor(processorName, this.processorParameters.processorSupplier(), this.parentNodeNames());
        if (this.storeNames.length > 0) {
            topologyBuilder.connectProcessorAndStateStores(processorName, this.storeNames);
        }
        if (shouldMaterialize) {
            topologyBuilder.addStateStore(new KeyValueStoreMaterializer<K, V>(this.materializedInternal).materialize(), processorName);
        }
    }
}

