/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.internals.GlobalStateStoreProvider;
import org.apache.kafka.streams.state.internals.StateStoreProvider;
import org.apache.kafka.streams.state.internals.WrappingStoreProvider;

public class QueryableStoreProvider {
    private final List<StateStoreProvider> storeProviders;
    private final GlobalStateStoreProvider globalStoreProvider;

    public QueryableStoreProvider(List<StateStoreProvider> storeProviders, GlobalStateStoreProvider globalStateStoreProvider) {
        this.storeProviders = new ArrayList<StateStoreProvider>(storeProviders);
        this.globalStoreProvider = globalStateStoreProvider;
    }

    public <T> T getStore(String storeName, QueryableStoreType<T> queryableStoreType) {
        List<T> globalStore = this.globalStoreProvider.stores(storeName, queryableStoreType);
        if (!globalStore.isEmpty()) {
            return queryableStoreType.create(new WrappingStoreProvider(Collections.singletonList(this.globalStoreProvider)), storeName);
        }
        ArrayList<T> allStores = new ArrayList<T>();
        for (StateStoreProvider storeProvider : this.storeProviders) {
            allStores.addAll(storeProvider.stores(storeName, queryableStoreType));
        }
        if (allStores.isEmpty()) {
            throw new InvalidStateStoreException("The state store, " + storeName + ", may have migrated to another instance.");
        }
        return queryableStoreType.create(new WrappingStoreProvider(this.storeProviders), storeName);
    }
}

