/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.kstream.Reducer;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.ForwardingCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.KTableMaterializedValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.KTableProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.TupleForwarder;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.KeyValueStore;

public class KTableReduce<K, V>
implements KTableProcessorSupplier<K, V, V> {
    private final String storeName;
    private final Reducer<V> addReducer;
    private final Reducer<V> removeReducer;
    private boolean sendOldValues = false;

    KTableReduce(String storeName, Reducer<V> addReducer, Reducer<V> removeReducer) {
        this.storeName = storeName;
        this.addReducer = addReducer;
        this.removeReducer = removeReducer;
    }

    @Override
    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    @Override
    public Processor<K, Change<V>> get() {
        return new KTableReduceProcessor();
    }

    @Override
    public KTableValueGetterSupplier<K, V> view() {
        return new KTableMaterializedValueGetterSupplier(this.storeName);
    }

    private class KTableReduceProcessor
    extends AbstractProcessor<K, Change<V>> {
        private KeyValueStore<K, V> store;
        private TupleForwarder<K, V> tupleForwarder;

        private KTableReduceProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.store = (KeyValueStore)context.getStateStore(KTableReduce.this.storeName);
            this.tupleForwarder = new TupleForwarder(this.store, context, new ForwardingCacheFlushListener(context), KTableReduce.this.sendOldValues);
        }

        @Override
        public void process(K key, Change<V> value) {
            if (key == null) {
                throw new StreamsException("Record key for KTable reduce operator with state " + KTableReduce.this.storeName + " should not be null.");
            }
            Object oldAgg = this.store.get(key);
            Object intermediateAgg = value.oldValue != null && oldAgg != null ? KTableReduce.this.removeReducer.apply(oldAgg, value.oldValue) : oldAgg;
            Object newAgg = value.newValue != null ? (intermediateAgg == null ? value.newValue : KTableReduce.this.addReducer.apply(intermediateAgg, value.newValue)) : intermediateAgg;
            this.store.put(key, newAgg);
            this.tupleForwarder.maybeForward(key, newAgg, KTableReduce.this.sendOldValues ? oldAgg : null);
        }
    }
}

