/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;

public class KeyValueStoreMaterializer<K, V> {
    private final MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>> materialized;

    public KeyValueStoreMaterializer(MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>> materialized) {
        this.materialized = materialized;
    }

    public StoreBuilder<KeyValueStore<K, V>> materialize() {
        KeyValueBytesStoreSupplier supplier = (KeyValueBytesStoreSupplier)this.materialized.storeSupplier();
        if (supplier == null) {
            String name = this.materialized.storeName();
            supplier = Stores.persistentKeyValueStore(name);
        }
        StoreBuilder<KeyValueStore<K, V>> builder = Stores.keyValueStoreBuilder(supplier, this.materialized.keySerde(), this.materialized.valueSerde());
        if (this.materialized.loggingEnabled()) {
            builder.withLoggingEnabled(this.materialized.logConfig());
        } else {
            builder.withLoggingDisabled();
        }
        if (this.materialized.cachingEnabled()) {
            builder.withCachingEnabled();
        }
        return builder;
    }
}

