/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collection;
import java.util.List;
import org.rocksdb.AbstractComparator;
import org.rocksdb.AbstractSlice;
import org.rocksdb.AccessHint;
import org.rocksdb.BuiltinComparator;
import org.rocksdb.Cache;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionOptionsFIFO;
import org.rocksdb.CompactionOptionsUniversal;
import org.rocksdb.CompactionPriority;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionOptions;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.DbPath;
import org.rocksdb.Env;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.Logger;
import org.rocksdb.MemTableConfig;
import org.rocksdb.MergeOperator;
import org.rocksdb.Options;
import org.rocksdb.RateLimiter;
import org.rocksdb.SstFileManager;
import org.rocksdb.Statistics;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WALRecoveryMode;

class RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter
extends Options {
    private final DBOptions dbOptions;
    private final ColumnFamilyOptions columnFamilyOptions;

    RocksDBGenericOptionsToDbOptionsColumnFamilyOptionsAdapter(DBOptions dbOptions, ColumnFamilyOptions columnFamilyOptions) {
        this.dbOptions = dbOptions;
        this.columnFamilyOptions = columnFamilyOptions;
    }

    public Options setIncreaseParallelism(int totalThreads) {
        this.dbOptions.setIncreaseParallelism(totalThreads);
        return this;
    }

    public Options setCreateIfMissing(boolean flag) {
        this.dbOptions.setCreateIfMissing(flag);
        return this;
    }

    public Options setCreateMissingColumnFamilies(boolean flag) {
        this.dbOptions.setCreateMissingColumnFamilies(flag);
        return this;
    }

    public Options setEnv(Env env) {
        this.dbOptions.setEnv(env);
        return this;
    }

    public Env getEnv() {
        return this.dbOptions.getEnv();
    }

    public Options prepareForBulkLoad() {
        this.dbOptions.setMaxBackgroundFlushes(4);
        this.columnFamilyOptions.setDisableAutoCompactions(true);
        this.columnFamilyOptions.setLevel0FileNumCompactionTrigger(0x40000000);
        this.columnFamilyOptions.setLevel0SlowdownWritesTrigger(0x40000000);
        this.columnFamilyOptions.setLevel0StopWritesTrigger(0x40000000);
        return this;
    }

    public boolean createIfMissing() {
        return this.dbOptions.createIfMissing();
    }

    public boolean createMissingColumnFamilies() {
        return this.dbOptions.createMissingColumnFamilies();
    }

    public Options optimizeForSmallDb() {
        this.dbOptions.optimizeForSmallDb();
        this.columnFamilyOptions.optimizeForSmallDb();
        return this;
    }

    public Options optimizeForPointLookup(long blockCacheSizeMb) {
        this.columnFamilyOptions.optimizeForPointLookup(blockCacheSizeMb);
        return this;
    }

    public Options optimizeLevelStyleCompaction() {
        this.columnFamilyOptions.optimizeLevelStyleCompaction();
        return this;
    }

    public Options optimizeLevelStyleCompaction(long memtableMemoryBudget) {
        this.columnFamilyOptions.optimizeLevelStyleCompaction(memtableMemoryBudget);
        return this;
    }

    public Options optimizeUniversalStyleCompaction() {
        this.columnFamilyOptions.optimizeUniversalStyleCompaction();
        return this;
    }

    public Options optimizeUniversalStyleCompaction(long memtableMemoryBudget) {
        this.columnFamilyOptions.optimizeUniversalStyleCompaction(memtableMemoryBudget);
        return this;
    }

    public Options setComparator(BuiltinComparator builtinComparator) {
        this.columnFamilyOptions.setComparator(builtinComparator);
        return this;
    }

    public Options setComparator(AbstractComparator<? extends AbstractSlice<?>> comparator) {
        this.columnFamilyOptions.setComparator(comparator);
        return this;
    }

    public Options setMergeOperatorName(String name) {
        this.columnFamilyOptions.setMergeOperatorName(name);
        return this;
    }

    public Options setMergeOperator(MergeOperator mergeOperator) {
        this.columnFamilyOptions.setMergeOperator(mergeOperator);
        return this;
    }

    public Options setWriteBufferSize(long writeBufferSize) {
        this.columnFamilyOptions.setWriteBufferSize(writeBufferSize);
        return this;
    }

    public long writeBufferSize() {
        return this.columnFamilyOptions.writeBufferSize();
    }

    public Options setMaxWriteBufferNumber(int maxWriteBufferNumber) {
        this.columnFamilyOptions.setMaxWriteBufferNumber(maxWriteBufferNumber);
        return this;
    }

    public int maxWriteBufferNumber() {
        return this.columnFamilyOptions.maxWriteBufferNumber();
    }

    public boolean errorIfExists() {
        return this.dbOptions.errorIfExists();
    }

    public Options setErrorIfExists(boolean errorIfExists) {
        this.dbOptions.setErrorIfExists(errorIfExists);
        return this;
    }

    public boolean paranoidChecks() {
        boolean dbOptionsParanoidChecks;
        boolean columnFamilyParanoidFileChecks = this.columnFamilyOptions.paranoidFileChecks();
        if (columnFamilyParanoidFileChecks != (dbOptionsParanoidChecks = this.dbOptions.paranoidChecks())) {
            throw new IllegalStateException("Config for paranoid checks for RockDB and ColumnFamilies should be the same.");
        }
        return dbOptionsParanoidChecks;
    }

    public Options setParanoidChecks(boolean paranoidChecks) {
        this.columnFamilyOptions.paranoidFileChecks();
        this.dbOptions.setParanoidChecks(paranoidChecks);
        return this;
    }

    public int maxOpenFiles() {
        return this.dbOptions.maxOpenFiles();
    }

    public Options setMaxFileOpeningThreads(int maxFileOpeningThreads) {
        this.dbOptions.setMaxFileOpeningThreads(maxFileOpeningThreads);
        return this;
    }

    public int maxFileOpeningThreads() {
        return this.dbOptions.maxFileOpeningThreads();
    }

    public Options setMaxTotalWalSize(long maxTotalWalSize) {
        this.dbOptions.setMaxTotalWalSize(maxTotalWalSize);
        return this;
    }

    public long maxTotalWalSize() {
        return this.dbOptions.maxTotalWalSize();
    }

    public Options setMaxOpenFiles(int maxOpenFiles) {
        this.dbOptions.setMaxOpenFiles(maxOpenFiles);
        return this;
    }

    public boolean useFsync() {
        return this.dbOptions.useFsync();
    }

    public Options setUseFsync(boolean useFsync) {
        this.dbOptions.setUseFsync(useFsync);
        return this;
    }

    public Options setDbPaths(Collection<DbPath> dbPaths) {
        this.dbOptions.setDbPaths(dbPaths);
        return this;
    }

    public List<DbPath> dbPaths() {
        return this.dbOptions.dbPaths();
    }

    public String dbLogDir() {
        return this.dbOptions.dbLogDir();
    }

    public Options setDbLogDir(String dbLogDir) {
        this.dbOptions.setDbLogDir(dbLogDir);
        return this;
    }

    public String walDir() {
        return this.dbOptions.walDir();
    }

    public Options setWalDir(String walDir) {
        this.dbOptions.setWalDir(walDir);
        return this;
    }

    public long deleteObsoleteFilesPeriodMicros() {
        return this.dbOptions.deleteObsoleteFilesPeriodMicros();
    }

    public Options setDeleteObsoleteFilesPeriodMicros(long micros) {
        this.dbOptions.setDeleteObsoleteFilesPeriodMicros(micros);
        return this;
    }

    public int maxBackgroundCompactions() {
        return this.dbOptions.maxBackgroundCompactions();
    }

    public Options setStatistics(Statistics statistics) {
        this.dbOptions.setStatistics(statistics);
        return this;
    }

    public Statistics statistics() {
        return this.dbOptions.statistics();
    }

    public void setBaseBackgroundCompactions(int baseBackgroundCompactions) {
        this.dbOptions.setBaseBackgroundCompactions(baseBackgroundCompactions);
    }

    public int baseBackgroundCompactions() {
        return this.dbOptions.baseBackgroundCompactions();
    }

    public Options setMaxBackgroundCompactions(int maxBackgroundCompactions) {
        this.dbOptions.setMaxBackgroundCompactions(maxBackgroundCompactions);
        return this;
    }

    public void setMaxSubcompactions(int maxSubcompactions) {
        this.dbOptions.setMaxSubcompactions(maxSubcompactions);
    }

    public int maxSubcompactions() {
        return this.dbOptions.maxSubcompactions();
    }

    public int maxBackgroundFlushes() {
        return this.dbOptions.maxBackgroundFlushes();
    }

    public Options setMaxBackgroundFlushes(int maxBackgroundFlushes) {
        this.dbOptions.setMaxBackgroundFlushes(maxBackgroundFlushes);
        return this;
    }

    public int maxBackgroundJobs() {
        return this.dbOptions.maxBackgroundJobs();
    }

    public Options setMaxBackgroundJobs(int maxBackgroundJobs) {
        this.dbOptions.setMaxBackgroundJobs(maxBackgroundJobs);
        return this;
    }

    public long maxLogFileSize() {
        return this.dbOptions.maxLogFileSize();
    }

    public Options setMaxLogFileSize(long maxLogFileSize) {
        this.dbOptions.setMaxLogFileSize(maxLogFileSize);
        return this;
    }

    public long logFileTimeToRoll() {
        return this.dbOptions.logFileTimeToRoll();
    }

    public Options setLogFileTimeToRoll(long logFileTimeToRoll) {
        this.dbOptions.setLogFileTimeToRoll(logFileTimeToRoll);
        return this;
    }

    public long keepLogFileNum() {
        return this.dbOptions.keepLogFileNum();
    }

    public Options setKeepLogFileNum(long keepLogFileNum) {
        this.dbOptions.setKeepLogFileNum(keepLogFileNum);
        return this;
    }

    public Options setRecycleLogFileNum(long recycleLogFileNum) {
        this.dbOptions.setRecycleLogFileNum(recycleLogFileNum);
        return this;
    }

    public long recycleLogFileNum() {
        return this.dbOptions.recycleLogFileNum();
    }

    public long maxManifestFileSize() {
        return this.dbOptions.maxManifestFileSize();
    }

    public Options setMaxManifestFileSize(long maxManifestFileSize) {
        this.dbOptions.setMaxManifestFileSize(maxManifestFileSize);
        return this;
    }

    public Options setMaxTableFilesSizeFIFO(long maxTableFilesSize) {
        this.columnFamilyOptions.setMaxTableFilesSizeFIFO(maxTableFilesSize);
        return this;
    }

    public long maxTableFilesSizeFIFO() {
        return this.columnFamilyOptions.maxTableFilesSizeFIFO();
    }

    public int tableCacheNumshardbits() {
        return this.dbOptions.tableCacheNumshardbits();
    }

    public Options setTableCacheNumshardbits(int tableCacheNumshardbits) {
        this.dbOptions.setTableCacheNumshardbits(tableCacheNumshardbits);
        return this;
    }

    public long walTtlSeconds() {
        return this.dbOptions.walTtlSeconds();
    }

    public Options setWalTtlSeconds(long walTtlSeconds) {
        this.dbOptions.setWalTtlSeconds(walTtlSeconds);
        return this;
    }

    public long walSizeLimitMB() {
        return this.dbOptions.walSizeLimitMB();
    }

    public Options setWalSizeLimitMB(long sizeLimitMB) {
        this.dbOptions.setWalSizeLimitMB(sizeLimitMB);
        return this;
    }

    public long manifestPreallocationSize() {
        return this.dbOptions.manifestPreallocationSize();
    }

    public Options setManifestPreallocationSize(long size) {
        this.dbOptions.setManifestPreallocationSize(size);
        return this;
    }

    public Options setUseDirectReads(boolean useDirectReads) {
        this.dbOptions.setUseDirectReads(useDirectReads);
        return this;
    }

    public boolean useDirectReads() {
        return this.dbOptions.useDirectReads();
    }

    public Options setUseDirectIoForFlushAndCompaction(boolean useDirectIoForFlushAndCompaction) {
        this.dbOptions.setUseDirectIoForFlushAndCompaction(useDirectIoForFlushAndCompaction);
        return this;
    }

    public boolean useDirectIoForFlushAndCompaction() {
        return this.dbOptions.useDirectIoForFlushAndCompaction();
    }

    public Options setAllowFAllocate(boolean allowFAllocate) {
        this.dbOptions.setAllowFAllocate(allowFAllocate);
        return this;
    }

    public boolean allowFAllocate() {
        return this.dbOptions.allowFAllocate();
    }

    public boolean allowMmapReads() {
        return this.dbOptions.allowMmapReads();
    }

    public Options setAllowMmapReads(boolean allowMmapReads) {
        this.dbOptions.setAllowMmapReads(allowMmapReads);
        return this;
    }

    public boolean allowMmapWrites() {
        return this.dbOptions.allowMmapWrites();
    }

    public Options setAllowMmapWrites(boolean allowMmapWrites) {
        this.dbOptions.setAllowMmapWrites(allowMmapWrites);
        return this;
    }

    public boolean isFdCloseOnExec() {
        return this.dbOptions.isFdCloseOnExec();
    }

    public Options setIsFdCloseOnExec(boolean isFdCloseOnExec) {
        this.dbOptions.setIsFdCloseOnExec(isFdCloseOnExec);
        return this;
    }

    public int statsDumpPeriodSec() {
        return this.dbOptions.statsDumpPeriodSec();
    }

    public Options setStatsDumpPeriodSec(int statsDumpPeriodSec) {
        this.dbOptions.setStatsDumpPeriodSec(statsDumpPeriodSec);
        return this;
    }

    public boolean adviseRandomOnOpen() {
        return this.dbOptions.adviseRandomOnOpen();
    }

    public Options setAdviseRandomOnOpen(boolean adviseRandomOnOpen) {
        this.dbOptions.setAdviseRandomOnOpen(adviseRandomOnOpen);
        return this;
    }

    public Options setDbWriteBufferSize(long dbWriteBufferSize) {
        this.dbOptions.setDbWriteBufferSize(dbWriteBufferSize);
        return this;
    }

    public long dbWriteBufferSize() {
        return this.dbOptions.dbWriteBufferSize();
    }

    public Options setAccessHintOnCompactionStart(AccessHint accessHint) {
        this.dbOptions.setAccessHintOnCompactionStart(accessHint);
        return this;
    }

    public AccessHint accessHintOnCompactionStart() {
        return this.dbOptions.accessHintOnCompactionStart();
    }

    public Options setNewTableReaderForCompactionInputs(boolean newTableReaderForCompactionInputs) {
        this.dbOptions.setNewTableReaderForCompactionInputs(newTableReaderForCompactionInputs);
        return this;
    }

    public boolean newTableReaderForCompactionInputs() {
        return this.dbOptions.newTableReaderForCompactionInputs();
    }

    public Options setCompactionReadaheadSize(long compactionReadaheadSize) {
        this.dbOptions.setCompactionReadaheadSize(compactionReadaheadSize);
        return this;
    }

    public long compactionReadaheadSize() {
        return this.dbOptions.compactionReadaheadSize();
    }

    public Options setRandomAccessMaxBufferSize(long randomAccessMaxBufferSize) {
        this.dbOptions.setRandomAccessMaxBufferSize(randomAccessMaxBufferSize);
        return this;
    }

    public long randomAccessMaxBufferSize() {
        return this.dbOptions.randomAccessMaxBufferSize();
    }

    public Options setWritableFileMaxBufferSize(long writableFileMaxBufferSize) {
        this.dbOptions.setWritableFileMaxBufferSize(writableFileMaxBufferSize);
        return this;
    }

    public long writableFileMaxBufferSize() {
        return this.dbOptions.writableFileMaxBufferSize();
    }

    public boolean useAdaptiveMutex() {
        return this.dbOptions.useAdaptiveMutex();
    }

    public Options setUseAdaptiveMutex(boolean useAdaptiveMutex) {
        this.dbOptions.setUseAdaptiveMutex(useAdaptiveMutex);
        return this;
    }

    public long bytesPerSync() {
        return this.dbOptions.bytesPerSync();
    }

    public Options setBytesPerSync(long bytesPerSync) {
        this.dbOptions.setBytesPerSync(bytesPerSync);
        return this;
    }

    public Options setWalBytesPerSync(long walBytesPerSync) {
        this.dbOptions.setWalBytesPerSync(walBytesPerSync);
        return this;
    }

    public long walBytesPerSync() {
        return this.dbOptions.walBytesPerSync();
    }

    public Options setEnableThreadTracking(boolean enableThreadTracking) {
        this.dbOptions.setEnableThreadTracking(enableThreadTracking);
        return this;
    }

    public boolean enableThreadTracking() {
        return this.dbOptions.enableThreadTracking();
    }

    public Options setDelayedWriteRate(long delayedWriteRate) {
        this.dbOptions.setDelayedWriteRate(delayedWriteRate);
        return this;
    }

    public long delayedWriteRate() {
        return this.dbOptions.delayedWriteRate();
    }

    public Options setAllowConcurrentMemtableWrite(boolean allowConcurrentMemtableWrite) {
        this.dbOptions.setAllowConcurrentMemtableWrite(allowConcurrentMemtableWrite);
        return this;
    }

    public boolean allowConcurrentMemtableWrite() {
        return this.dbOptions.allowConcurrentMemtableWrite();
    }

    public Options setEnableWriteThreadAdaptiveYield(boolean enableWriteThreadAdaptiveYield) {
        this.dbOptions.setEnableWriteThreadAdaptiveYield(enableWriteThreadAdaptiveYield);
        return this;
    }

    public boolean enableWriteThreadAdaptiveYield() {
        return this.dbOptions.enableWriteThreadAdaptiveYield();
    }

    public Options setWriteThreadMaxYieldUsec(long writeThreadMaxYieldUsec) {
        this.dbOptions.setWriteThreadMaxYieldUsec(writeThreadMaxYieldUsec);
        return this;
    }

    public long writeThreadMaxYieldUsec() {
        return this.dbOptions.writeThreadMaxYieldUsec();
    }

    public Options setWriteThreadSlowYieldUsec(long writeThreadSlowYieldUsec) {
        this.dbOptions.setWriteThreadSlowYieldUsec(writeThreadSlowYieldUsec);
        return this;
    }

    public long writeThreadSlowYieldUsec() {
        return this.dbOptions.writeThreadSlowYieldUsec();
    }

    public Options setSkipStatsUpdateOnDbOpen(boolean skipStatsUpdateOnDbOpen) {
        this.dbOptions.setSkipStatsUpdateOnDbOpen(skipStatsUpdateOnDbOpen);
        return this;
    }

    public boolean skipStatsUpdateOnDbOpen() {
        return this.dbOptions.skipStatsUpdateOnDbOpen();
    }

    public Options setWalRecoveryMode(WALRecoveryMode walRecoveryMode) {
        this.dbOptions.setWalRecoveryMode(walRecoveryMode);
        return this;
    }

    public WALRecoveryMode walRecoveryMode() {
        return this.dbOptions.walRecoveryMode();
    }

    public Options setAllow2pc(boolean allow2pc) {
        this.dbOptions.setAllow2pc(allow2pc);
        return this;
    }

    public boolean allow2pc() {
        return this.dbOptions.allow2pc();
    }

    public Options setRowCache(Cache rowCache) {
        this.dbOptions.setRowCache(rowCache);
        return this;
    }

    public Cache rowCache() {
        return this.dbOptions.rowCache();
    }

    public Options setFailIfOptionsFileError(boolean failIfOptionsFileError) {
        this.dbOptions.setFailIfOptionsFileError(failIfOptionsFileError);
        return this;
    }

    public boolean failIfOptionsFileError() {
        return this.dbOptions.failIfOptionsFileError();
    }

    public Options setDumpMallocStats(boolean dumpMallocStats) {
        this.dbOptions.setDumpMallocStats(dumpMallocStats);
        return this;
    }

    public boolean dumpMallocStats() {
        return this.dbOptions.dumpMallocStats();
    }

    public Options setAvoidFlushDuringRecovery(boolean avoidFlushDuringRecovery) {
        this.dbOptions.setAvoidFlushDuringRecovery(avoidFlushDuringRecovery);
        return this;
    }

    public boolean avoidFlushDuringRecovery() {
        return this.dbOptions.avoidFlushDuringRecovery();
    }

    public Options setAvoidFlushDuringShutdown(boolean avoidFlushDuringShutdown) {
        this.dbOptions.setAvoidFlushDuringShutdown(avoidFlushDuringShutdown);
        return this;
    }

    public boolean avoidFlushDuringShutdown() {
        return this.dbOptions.avoidFlushDuringShutdown();
    }

    public MemTableConfig memTableConfig() {
        return this.columnFamilyOptions.memTableConfig();
    }

    public Options setMemTableConfig(MemTableConfig config) {
        this.columnFamilyOptions.setMemTableConfig(config);
        return this;
    }

    public Options setRateLimiter(RateLimiter rateLimiter) {
        this.dbOptions.setRateLimiter(rateLimiter);
        return this;
    }

    public Options setSstFileManager(SstFileManager sstFileManager) {
        this.dbOptions.setSstFileManager(sstFileManager);
        return this;
    }

    public Options setLogger(Logger logger) {
        this.dbOptions.setLogger(logger);
        return this;
    }

    public Options setInfoLogLevel(InfoLogLevel infoLogLevel) {
        this.dbOptions.setInfoLogLevel(infoLogLevel);
        return this;
    }

    public InfoLogLevel infoLogLevel() {
        return this.dbOptions.infoLogLevel();
    }

    public String memTableFactoryName() {
        return this.columnFamilyOptions.memTableFactoryName();
    }

    public TableFormatConfig tableFormatConfig() {
        return this.columnFamilyOptions.tableFormatConfig();
    }

    public Options setTableFormatConfig(TableFormatConfig config) {
        this.columnFamilyOptions.setTableFormatConfig(config);
        return this;
    }

    public String tableFactoryName() {
        return this.columnFamilyOptions.tableFactoryName();
    }

    public Options useFixedLengthPrefixExtractor(int n) {
        this.columnFamilyOptions.useFixedLengthPrefixExtractor(n);
        return this;
    }

    public Options useCappedPrefixExtractor(int n) {
        this.columnFamilyOptions.useCappedPrefixExtractor(n);
        return this;
    }

    public CompressionType compressionType() {
        return this.columnFamilyOptions.compressionType();
    }

    public Options setCompressionPerLevel(List<CompressionType> compressionLevels) {
        this.columnFamilyOptions.setCompressionPerLevel(compressionLevels);
        return this;
    }

    public List<CompressionType> compressionPerLevel() {
        return this.columnFamilyOptions.compressionPerLevel();
    }

    public Options setCompressionType(CompressionType compressionType) {
        this.columnFamilyOptions.setCompressionType(compressionType);
        return this;
    }

    public Options setBottommostCompressionType(CompressionType bottommostCompressionType) {
        this.columnFamilyOptions.setBottommostCompressionType(bottommostCompressionType);
        return this;
    }

    public CompressionType bottommostCompressionType() {
        return this.columnFamilyOptions.bottommostCompressionType();
    }

    public Options setCompressionOptions(CompressionOptions compressionOptions) {
        this.columnFamilyOptions.setCompressionOptions(compressionOptions);
        return this;
    }

    public CompressionOptions compressionOptions() {
        return this.columnFamilyOptions.compressionOptions();
    }

    public CompactionStyle compactionStyle() {
        return this.columnFamilyOptions.compactionStyle();
    }

    public Options setCompactionStyle(CompactionStyle compactionStyle) {
        this.columnFamilyOptions.setCompactionStyle(compactionStyle);
        return this;
    }

    public int numLevels() {
        return this.columnFamilyOptions.numLevels();
    }

    public Options setNumLevels(int numLevels) {
        this.columnFamilyOptions.setNumLevels(numLevels);
        return this;
    }

    public int levelZeroFileNumCompactionTrigger() {
        return this.columnFamilyOptions.levelZeroFileNumCompactionTrigger();
    }

    public Options setLevelZeroFileNumCompactionTrigger(int numFiles) {
        this.columnFamilyOptions.setLevelZeroFileNumCompactionTrigger(numFiles);
        return this;
    }

    public int levelZeroSlowdownWritesTrigger() {
        return this.columnFamilyOptions.levelZeroSlowdownWritesTrigger();
    }

    public Options setLevelZeroSlowdownWritesTrigger(int numFiles) {
        this.columnFamilyOptions.setLevelZeroSlowdownWritesTrigger(numFiles);
        return this;
    }

    public int levelZeroStopWritesTrigger() {
        return this.columnFamilyOptions.levelZeroStopWritesTrigger();
    }

    public Options setLevelZeroStopWritesTrigger(int numFiles) {
        this.columnFamilyOptions.setLevelZeroStopWritesTrigger(numFiles);
        return this;
    }

    public long targetFileSizeBase() {
        return this.columnFamilyOptions.targetFileSizeBase();
    }

    public Options setTargetFileSizeBase(long targetFileSizeBase) {
        this.columnFamilyOptions.setTargetFileSizeBase(targetFileSizeBase);
        return this;
    }

    public int targetFileSizeMultiplier() {
        return this.columnFamilyOptions.targetFileSizeMultiplier();
    }

    public Options setTargetFileSizeMultiplier(int multiplier) {
        this.columnFamilyOptions.setTargetFileSizeMultiplier(multiplier);
        return this;
    }

    public Options setMaxBytesForLevelBase(long maxBytesForLevelBase) {
        this.columnFamilyOptions.setMaxBytesForLevelBase(maxBytesForLevelBase);
        return this;
    }

    public long maxBytesForLevelBase() {
        return this.columnFamilyOptions.maxBytesForLevelBase();
    }

    public Options setLevelCompactionDynamicLevelBytes(boolean enableLevelCompactionDynamicLevelBytes) {
        this.columnFamilyOptions.setLevelCompactionDynamicLevelBytes(enableLevelCompactionDynamicLevelBytes);
        return this;
    }

    public boolean levelCompactionDynamicLevelBytes() {
        return this.columnFamilyOptions.levelCompactionDynamicLevelBytes();
    }

    public double maxBytesForLevelMultiplier() {
        return this.columnFamilyOptions.maxBytesForLevelMultiplier();
    }

    public Options setMaxBytesForLevelMultiplier(double multiplier) {
        this.columnFamilyOptions.setMaxBytesForLevelMultiplier(multiplier);
        return this;
    }

    public long maxCompactionBytes() {
        return this.columnFamilyOptions.maxCompactionBytes();
    }

    public Options setMaxCompactionBytes(long maxCompactionBytes) {
        this.columnFamilyOptions.setMaxCompactionBytes(maxCompactionBytes);
        return this;
    }

    public long arenaBlockSize() {
        return this.columnFamilyOptions.arenaBlockSize();
    }

    public Options setArenaBlockSize(long arenaBlockSize) {
        this.columnFamilyOptions.setArenaBlockSize(arenaBlockSize);
        return this;
    }

    public boolean disableAutoCompactions() {
        return this.columnFamilyOptions.disableAutoCompactions();
    }

    public Options setDisableAutoCompactions(boolean disableAutoCompactions) {
        this.columnFamilyOptions.setDisableAutoCompactions(disableAutoCompactions);
        return this;
    }

    public long maxSequentialSkipInIterations() {
        return this.columnFamilyOptions.maxSequentialSkipInIterations();
    }

    public Options setMaxSequentialSkipInIterations(long maxSequentialSkipInIterations) {
        this.columnFamilyOptions.setMaxSequentialSkipInIterations(maxSequentialSkipInIterations);
        return this;
    }

    public boolean inplaceUpdateSupport() {
        return this.columnFamilyOptions.inplaceUpdateSupport();
    }

    public Options setInplaceUpdateSupport(boolean inplaceUpdateSupport) {
        this.columnFamilyOptions.setInplaceUpdateSupport(inplaceUpdateSupport);
        return this;
    }

    public long inplaceUpdateNumLocks() {
        return this.columnFamilyOptions.inplaceUpdateNumLocks();
    }

    public Options setInplaceUpdateNumLocks(long inplaceUpdateNumLocks) {
        this.columnFamilyOptions.setInplaceUpdateNumLocks(inplaceUpdateNumLocks);
        return this;
    }

    public double memtablePrefixBloomSizeRatio() {
        return this.columnFamilyOptions.memtablePrefixBloomSizeRatio();
    }

    public Options setMemtablePrefixBloomSizeRatio(double memtablePrefixBloomSizeRatio) {
        this.columnFamilyOptions.setMemtablePrefixBloomSizeRatio(memtablePrefixBloomSizeRatio);
        return this;
    }

    public int bloomLocality() {
        return this.columnFamilyOptions.bloomLocality();
    }

    public Options setBloomLocality(int bloomLocality) {
        this.columnFamilyOptions.setBloomLocality(bloomLocality);
        return this;
    }

    public long maxSuccessiveMerges() {
        return this.columnFamilyOptions.maxSuccessiveMerges();
    }

    public Options setMaxSuccessiveMerges(long maxSuccessiveMerges) {
        this.columnFamilyOptions.setMaxSuccessiveMerges(maxSuccessiveMerges);
        return this;
    }

    public int minWriteBufferNumberToMerge() {
        return this.columnFamilyOptions.minWriteBufferNumberToMerge();
    }

    public Options setMinWriteBufferNumberToMerge(int minWriteBufferNumberToMerge) {
        this.columnFamilyOptions.setMinWriteBufferNumberToMerge(minWriteBufferNumberToMerge);
        return this;
    }

    public Options setOptimizeFiltersForHits(boolean optimizeFiltersForHits) {
        this.columnFamilyOptions.setOptimizeFiltersForHits(optimizeFiltersForHits);
        return this;
    }

    public boolean optimizeFiltersForHits() {
        return this.columnFamilyOptions.optimizeFiltersForHits();
    }

    public Options setMemtableHugePageSize(long memtableHugePageSize) {
        this.columnFamilyOptions.setMemtableHugePageSize(memtableHugePageSize);
        return this;
    }

    public long memtableHugePageSize() {
        return this.columnFamilyOptions.memtableHugePageSize();
    }

    public Options setSoftPendingCompactionBytesLimit(long softPendingCompactionBytesLimit) {
        this.columnFamilyOptions.setSoftPendingCompactionBytesLimit(softPendingCompactionBytesLimit);
        return this;
    }

    public long softPendingCompactionBytesLimit() {
        return this.columnFamilyOptions.softPendingCompactionBytesLimit();
    }

    public Options setHardPendingCompactionBytesLimit(long hardPendingCompactionBytesLimit) {
        this.columnFamilyOptions.setHardPendingCompactionBytesLimit(hardPendingCompactionBytesLimit);
        return this;
    }

    public long hardPendingCompactionBytesLimit() {
        return this.columnFamilyOptions.hardPendingCompactionBytesLimit();
    }

    public Options setLevel0FileNumCompactionTrigger(int level0FileNumCompactionTrigger) {
        this.columnFamilyOptions.setLevel0FileNumCompactionTrigger(level0FileNumCompactionTrigger);
        return this;
    }

    public int level0FileNumCompactionTrigger() {
        return this.columnFamilyOptions.level0FileNumCompactionTrigger();
    }

    public Options setLevel0SlowdownWritesTrigger(int level0SlowdownWritesTrigger) {
        this.columnFamilyOptions.setLevel0SlowdownWritesTrigger(level0SlowdownWritesTrigger);
        return this;
    }

    public int level0SlowdownWritesTrigger() {
        return this.columnFamilyOptions.level0SlowdownWritesTrigger();
    }

    public Options setLevel0StopWritesTrigger(int level0StopWritesTrigger) {
        this.columnFamilyOptions.setLevel0StopWritesTrigger(level0StopWritesTrigger);
        return this;
    }

    public int level0StopWritesTrigger() {
        return this.columnFamilyOptions.level0StopWritesTrigger();
    }

    public Options setMaxBytesForLevelMultiplierAdditional(int[] maxBytesForLevelMultiplierAdditional) {
        this.columnFamilyOptions.setMaxBytesForLevelMultiplierAdditional(maxBytesForLevelMultiplierAdditional);
        return this;
    }

    public int[] maxBytesForLevelMultiplierAdditional() {
        return this.columnFamilyOptions.maxBytesForLevelMultiplierAdditional();
    }

    public Options setParanoidFileChecks(boolean paranoidFileChecks) {
        this.columnFamilyOptions.setParanoidFileChecks(paranoidFileChecks);
        return this;
    }

    public boolean paranoidFileChecks() {
        return this.columnFamilyOptions.paranoidFileChecks();
    }

    public Options setMaxWriteBufferNumberToMaintain(int maxWriteBufferNumberToMaintain) {
        this.columnFamilyOptions.setMaxWriteBufferNumberToMaintain(maxWriteBufferNumberToMaintain);
        return this;
    }

    public int maxWriteBufferNumberToMaintain() {
        return this.columnFamilyOptions.maxWriteBufferNumberToMaintain();
    }

    public Options setCompactionPriority(CompactionPriority compactionPriority) {
        this.columnFamilyOptions.setCompactionPriority(compactionPriority);
        return this;
    }

    public CompactionPriority compactionPriority() {
        return this.columnFamilyOptions.compactionPriority();
    }

    public Options setReportBgIoStats(boolean reportBgIoStats) {
        this.columnFamilyOptions.setReportBgIoStats(reportBgIoStats);
        return this;
    }

    public boolean reportBgIoStats() {
        return this.columnFamilyOptions.reportBgIoStats();
    }

    public Options setCompactionOptionsUniversal(CompactionOptionsUniversal compactionOptionsUniversal) {
        this.columnFamilyOptions.setCompactionOptionsUniversal(compactionOptionsUniversal);
        return this;
    }

    public CompactionOptionsUniversal compactionOptionsUniversal() {
        return this.columnFamilyOptions.compactionOptionsUniversal();
    }

    public Options setCompactionOptionsFIFO(CompactionOptionsFIFO compactionOptionsFIFO) {
        this.columnFamilyOptions.setCompactionOptionsFIFO(compactionOptionsFIFO);
        return this;
    }

    public CompactionOptionsFIFO compactionOptionsFIFO() {
        return this.columnFamilyOptions.compactionOptionsFIFO();
    }

    public Options setForceConsistencyChecks(boolean forceConsistencyChecks) {
        this.columnFamilyOptions.setForceConsistencyChecks(forceConsistencyChecks);
        return this;
    }

    public boolean forceConsistencyChecks() {
        return this.columnFamilyOptions.forceConsistencyChecks();
    }

    public void close() {
        this.dbOptions.close();
        this.columnFamilyOptions.close();
    }
}

