/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValueTimestamp;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.integration.AbstractJoinIntegrationTest;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.test.IntegrationTest;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={IntegrationTest.class})
@RunWith(value=Parameterized.class)
public class TableTableJoinIntegrationTest
extends AbstractJoinIntegrationTest {
    private KTable<Long, String> leftTable;
    private KTable<Long, String> rightTable;
    private final KeyValueTimestamp<Long, String> expectedFinalJoinResult = new KeyValueTimestamp<Long, String>(0L, "D-d", 15L);
    private final KeyValueTimestamp<Long, String> expectedFinalMultiJoinResult = new KeyValueTimestamp<Long, String>(0L, "D-d-d", 15L);
    private final String storeName = appID + "-store";
    private Materialized<Long, String, KeyValueStore<Bytes, byte[]>> materialized = Materialized.as((String)this.storeName).withKeySerde(Serdes.Long()).withValueSerde(Serdes.String()).withCachingDisabled().withLoggingDisabled();

    public TableTableJoinIntegrationTest(boolean cacheEnabled) {
        super(cacheEnabled);
    }

    @Before
    public void prepareTopology() throws InterruptedException {
        super.prepareEnvironment();
        appID = "table-table-join-integration-test";
        this.builder = new StreamsBuilder();
        this.leftTable = this.builder.table("inputTopicLeft", Materialized.as((String)"left").withLoggingDisabled());
        this.rightTable = this.builder.table("inputTopicRight", Materialized.as((String)"right").withLoggingDisabled());
    }

    @Test
    public void testInner() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner");
        if (this.cacheEnabled) {
            this.leftTable.join(this.rightTable, this.valueJoiner, this.materialized).toStream().peek((ForeachAction)new CountingPeek(false)).to("outputTopic");
            this.runTest(this.expectedFinalJoinResult, this.storeName);
        } else {
            List<List<KeyValueTimestamp<Long, String>>> expectedResult = Arrays.asList(null, null, null, Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "A-a", 4L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "B-a", 5L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "B-b", 6L)), Collections.singletonList(new KeyValueTimestamp<Long, Object>(0L, null, 7L)), null, null, Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "C-c", 10L)), Collections.singletonList(new KeyValueTimestamp<Long, Object>(0L, null, 11L)), null, null, null, Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "D-d", 15L)));
            this.leftTable.join(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
            this.runTest(expectedResult, this.storeName);
        }
    }

    @Test
    public void testLeft() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-left");
        if (this.cacheEnabled) {
            this.leftTable.leftJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().peek((ForeachAction)new CountingPeek(false)).to("outputTopic");
            this.runTest(this.expectedFinalJoinResult, this.storeName);
        } else {
            List<List<KeyValueTimestamp<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "A-null", 3L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "A-a", 4L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "B-a", 5L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "B-b", 6L)), Collections.singletonList(new KeyValueTimestamp<Long, Object>(0L, null, 7L)), null, Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "C-null", 9L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "C-c", 10L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "C-null", 11L)), Collections.singletonList(new KeyValueTimestamp<Long, Object>(0L, null, 12L)), null, null, Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "D-d", 15L)));
            this.leftTable.leftJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
            this.runTest(expectedResult, this.storeName);
        }
    }

    @Test
    public void testOuter() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-outer");
        if (this.cacheEnabled) {
            this.leftTable.outerJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().peek((ForeachAction)new CountingPeek(false)).to("outputTopic");
            this.runTest(this.expectedFinalJoinResult, this.storeName);
        } else {
            List<List<KeyValueTimestamp<Long, String>>> expectedResult = Arrays.asList(null, null, Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "A-null", 3L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "A-a", 4L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "B-a", 5L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "B-b", 6L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "null-b", 7L)), Collections.singletonList(new KeyValueTimestamp<Long, Object>(0L, null, 8L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "C-null", 9L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "C-c", 10L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "C-null", 11L)), Collections.singletonList(new KeyValueTimestamp<Long, Object>(0L, null, 12L)), null, Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "null-d", 14L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "D-d", 15L)));
            this.leftTable.outerJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
            this.runTest(expectedResult, this.storeName);
        }
    }

    @Test
    public void testInnerInner() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-inner");
        if (this.cacheEnabled) {
            this.leftTable.join(this.rightTable, this.valueJoiner).join(this.rightTable, this.valueJoiner, this.materialized).toStream().peek((ForeachAction)new CountingPeek(true)).to("outputTopic");
            this.runTest(this.expectedFinalMultiJoinResult, this.storeName);
        } else {
            List<List<KeyValueTimestamp<Long, String>>> expectedResult = Arrays.asList(null, null, null, Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "A-a-a", 4L), new KeyValueTimestamp<Long, String>(0L, "A-a-a", 4L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "B-a-a", 5L)), Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "B-b-b", 6L), new KeyValueTimestamp<Long, String>(0L, "B-b-b", 6L)), Collections.singletonList(new KeyValueTimestamp<Long, Object>(0L, null, 7L)), null, null, Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "C-c-c", 10L), new KeyValueTimestamp<Long, String>(0L, "C-c-c", 10L)), null, null, null, null, Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "D-d-d", 15L)));
            this.leftTable.join(this.rightTable, this.valueJoiner).join(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
            this.runTest(expectedResult, this.storeName);
        }
    }

    @Test
    public void testInnerLeft() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-left");
        if (this.cacheEnabled) {
            this.leftTable.join(this.rightTable, this.valueJoiner).leftJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().peek((ForeachAction)new CountingPeek(true)).to("outputTopic");
            this.runTest(this.expectedFinalMultiJoinResult, this.storeName);
        } else {
            List<List<KeyValueTimestamp<Long, String>>> expectedResult = Arrays.asList(null, null, null, Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "A-a-a", 4L), new KeyValueTimestamp<Long, String>(0L, "A-a-a", 4L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "B-a-a", 5L)), Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "B-b-b", 6L), new KeyValueTimestamp<Long, String>(0L, "B-b-b", 6L)), Collections.singletonList(new KeyValueTimestamp<Long, Object>(0L, null, 7L)), null, null, Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "C-c-c", 10L), new KeyValueTimestamp<Long, String>(0L, "C-c-c", 10L)), Collections.singletonList(new KeyValueTimestamp<Long, Object>(0L, null, 11L)), null, null, null, Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "D-d-d", 15L)));
            this.leftTable.join(this.rightTable, this.valueJoiner).leftJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
            this.runTest(expectedResult, this.storeName);
        }
    }

    @Test
    public void testInnerOuter() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-outer");
        if (this.cacheEnabled) {
            this.leftTable.join(this.rightTable, this.valueJoiner).outerJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().peek((ForeachAction)new CountingPeek(true)).to("outputTopic");
            this.runTest(this.expectedFinalMultiJoinResult, this.storeName);
        } else {
            List<List<KeyValueTimestamp<Long, String>>> expectedResult = Arrays.asList(null, null, null, Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "A-a-a", 4L), new KeyValueTimestamp<Long, String>(0L, "A-a-a", 4L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "B-a-a", 5L)), Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "B-b-b", 6L), new KeyValueTimestamp<Long, String>(0L, "B-b-b", 6L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "null-b", 7L)), Collections.singletonList(new KeyValueTimestamp<Long, Object>(0L, null, 8L)), null, Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "C-c-c", 10L), new KeyValueTimestamp<Long, String>(0L, "C-c-c", 10L)), Arrays.asList(new KeyValueTimestamp<Long, Object>(0L, null, 11L), new KeyValueTimestamp<Long, Object>(0L, null, 11L)), null, null, null, Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "null-d", 14L), new KeyValueTimestamp<Long, String>(0L, "D-d-d", 15L)));
            this.leftTable.join(this.rightTable, this.valueJoiner).outerJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
            this.runTest(expectedResult, this.storeName);
        }
    }

    @Test
    public void testLeftInner() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-inner");
        if (this.cacheEnabled) {
            this.leftTable.leftJoin(this.rightTable, this.valueJoiner).join(this.rightTable, this.valueJoiner, this.materialized).toStream().peek((ForeachAction)new CountingPeek(true)).to("outputTopic");
            this.runTest(this.expectedFinalMultiJoinResult, this.storeName);
        } else {
            List<List<KeyValueTimestamp<Long, String>>> expectedResult = Arrays.asList(null, null, null, Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "A-a-a", 4L), new KeyValueTimestamp<Long, String>(0L, "A-a-a", 4L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "B-a-a", 5L)), Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "B-b-b", 6L), new KeyValueTimestamp<Long, String>(0L, "B-b-b", 6L)), Collections.singletonList(new KeyValueTimestamp<Long, Object>(0L, null, 7L)), null, null, Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "C-c-c", 10L), new KeyValueTimestamp<Long, String>(0L, "C-c-c", 10L)), Collections.singletonList(new KeyValueTimestamp<Long, Object>(0L, null, 11L)), null, null, null, Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "D-d-d", 15L)));
            this.leftTable.leftJoin(this.rightTable, this.valueJoiner).join(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
            this.runTest(expectedResult, this.storeName);
        }
    }

    @Test
    public void testLeftLeft() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-left");
        if (this.cacheEnabled) {
            this.leftTable.leftJoin(this.rightTable, this.valueJoiner).leftJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().peek((ForeachAction)new CountingPeek(true)).to("outputTopic");
            this.runTest(this.expectedFinalMultiJoinResult, this.storeName);
        } else {
            List<List<KeyValueTimestamp<Long, String>>> expectedResult = Arrays.asList(null, null, null, Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "A-null-null", 3L), new KeyValueTimestamp<Long, String>(0L, "A-a-a", 4L), new KeyValueTimestamp<Long, String>(0L, "A-a-a", 4L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "B-a-a", 5L)), Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "B-b-b", 6L), new KeyValueTimestamp<Long, String>(0L, "B-b-b", 6L)), Collections.singletonList(new KeyValueTimestamp<Long, Object>(0L, null, 7L)), null, null, Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "C-null-null", 9L), new KeyValueTimestamp<Long, String>(0L, "C-c-c", 10L), new KeyValueTimestamp<Long, String>(0L, "C-c-c", 10L)), Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "C-null-null", 11L), new KeyValueTimestamp<Long, String>(0L, "C-null-null", 11L)), Collections.singletonList(new KeyValueTimestamp<Long, Object>(0L, null, 12L)), null, null, Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "D-d-d", 15L)));
            this.leftTable.leftJoin(this.rightTable, this.valueJoiner).leftJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
            this.runTest(expectedResult, this.storeName);
        }
    }

    @Test
    public void testLeftOuter() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-outer");
        if (this.cacheEnabled) {
            this.leftTable.leftJoin(this.rightTable, this.valueJoiner).outerJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().peek((ForeachAction)new CountingPeek(true)).to("outputTopic");
            this.runTest(this.expectedFinalMultiJoinResult, this.storeName);
        } else {
            List<List<KeyValueTimestamp<Long, String>>> expectedResult = Arrays.asList(null, null, null, Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "A-null-null", 3L), new KeyValueTimestamp<Long, String>(0L, "A-a-a", 4L), new KeyValueTimestamp<Long, String>(0L, "A-a-a", 4L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "B-a-a", 5L)), Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "B-b-b", 6L), new KeyValueTimestamp<Long, String>(0L, "B-b-b", 6L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "null-b", 7L)), Collections.singletonList(new KeyValueTimestamp<Long, Object>(0L, null, 8L)), null, Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "C-null-null", 9L), new KeyValueTimestamp<Long, String>(0L, "C-c-c", 10L), new KeyValueTimestamp<Long, String>(0L, "C-c-c", 10L)), Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "C-null-null", 11L), new KeyValueTimestamp<Long, String>(0L, "C-null-null", 11L)), Collections.singletonList(new KeyValueTimestamp<Long, Object>(0L, null, 12L)), null, null, Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "null-d", 14L), new KeyValueTimestamp<Long, String>(0L, "D-d-d", 15L)));
            this.leftTable.leftJoin(this.rightTable, this.valueJoiner).outerJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
            this.runTest(expectedResult, this.storeName);
        }
    }

    @Test
    public void testOuterInner() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-inner");
        if (this.cacheEnabled) {
            this.leftTable.outerJoin(this.rightTable, this.valueJoiner).join(this.rightTable, this.valueJoiner, this.materialized).toStream().peek((ForeachAction)new CountingPeek(true)).to("outputTopic");
            this.runTest(this.expectedFinalMultiJoinResult, this.storeName);
        } else {
            List<List<KeyValueTimestamp<Long, String>>> expectedResult = Arrays.asList(null, null, null, Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "A-a-a", 4L), new KeyValueTimestamp<Long, String>(0L, "A-a-a", 4L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "B-a-a", 5L)), Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "B-b-b", 6L), new KeyValueTimestamp<Long, String>(0L, "B-b-b", 6L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "null-b-b", 7L)), null, null, Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "C-c-c", 10L), new KeyValueTimestamp<Long, String>(0L, "C-c-c", 10L)), Collections.singletonList(new KeyValueTimestamp<Long, Object>(0L, null, 11L)), null, null, Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "null-d-d", 14L), new KeyValueTimestamp<Long, String>(0L, "null-d-d", 14L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "D-d-d", 15L)));
            this.leftTable.outerJoin(this.rightTable, this.valueJoiner).join(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
            this.runTest(expectedResult, this.storeName);
        }
    }

    @Test
    public void testOuterLeft() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-left");
        if (this.cacheEnabled) {
            this.leftTable.outerJoin(this.rightTable, this.valueJoiner).leftJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().peek((ForeachAction)new CountingPeek(true)).to("outputTopic");
            this.runTest(this.expectedFinalMultiJoinResult, this.storeName);
        } else {
            List<List<KeyValueTimestamp<Long, String>>> expectedResult = Arrays.asList(null, null, null, Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "A-null-null", 3L), new KeyValueTimestamp<Long, String>(0L, "A-a-a", 4L), new KeyValueTimestamp<Long, String>(0L, "A-a-a", 4L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "B-a-a", 5L)), Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "B-b-b", 6L), new KeyValueTimestamp<Long, String>(0L, "B-b-b", 6L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "null-b-b", 7L)), Collections.singletonList(new KeyValueTimestamp<Long, Object>(0L, null, 8L)), null, Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "C-null-null", 9L), new KeyValueTimestamp<Long, String>(0L, "C-c-c", 10L), new KeyValueTimestamp<Long, String>(0L, "C-c-c", 10L)), Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "C-null-null", 11L), new KeyValueTimestamp<Long, String>(0L, "C-null-null", 11L)), Collections.singletonList(new KeyValueTimestamp<Long, Object>(0L, null, 12L)), null, Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "null-d-d", 14L), new KeyValueTimestamp<Long, String>(0L, "null-d-d", 14L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "D-d-d", 15L)));
            this.leftTable.outerJoin(this.rightTable, this.valueJoiner).leftJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
            this.runTest(expectedResult, this.storeName);
        }
    }

    @Test
    public void testOuterOuter() throws Exception {
        STREAMS_CONFIG.put("application.id", appID + "-inner-outer");
        if (this.cacheEnabled) {
            this.leftTable.outerJoin(this.rightTable, this.valueJoiner).outerJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().peek((ForeachAction)new CountingPeek(true)).to("outputTopic");
            this.runTest(this.expectedFinalMultiJoinResult, this.storeName);
        } else {
            List<List<KeyValueTimestamp<Long, String>>> expectedResult = Arrays.asList(null, null, null, Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "A-null-null", 3L), new KeyValueTimestamp<Long, String>(0L, "A-a-a", 4L), new KeyValueTimestamp<Long, String>(0L, "A-a-a", 4L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "B-a-a", 5L)), Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "B-b-b", 6L), new KeyValueTimestamp<Long, String>(0L, "B-b-b", 6L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "null-b-b", 7L)), Arrays.asList(new KeyValueTimestamp<Long, Object>(0L, null, 8L), new KeyValueTimestamp<Long, Object>(0L, null, 8L)), Collections.singletonList(new KeyValueTimestamp<Long, String>(0L, "C-null-null", 9L)), Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "C-c-c", 10L), new KeyValueTimestamp<Long, String>(0L, "C-c-c", 10L)), Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "C-null-null", 11L), new KeyValueTimestamp<Long, String>(0L, "C-null-null", 11L)), Collections.singletonList(new KeyValueTimestamp<Long, Object>(0L, null, 12L)), null, null, Arrays.asList(new KeyValueTimestamp<Long, String>(0L, "null-d-d", 14L), new KeyValueTimestamp<Long, String>(0L, "null-d-d", 14L), new KeyValueTimestamp<Long, String>(0L, "D-d-d", 15L)));
            this.leftTable.outerJoin(this.rightTable, this.valueJoiner).outerJoin(this.rightTable, this.valueJoiner, this.materialized).toStream().to("outputTopic");
            this.runTest(expectedResult, this.storeName);
        }
    }

    private final class CountingPeek
    implements ForeachAction<Long, String> {
        private final KeyValueTimestamp<Long, String> expected;

        CountingPeek(boolean multiJoin) {
            this.expected = multiJoin ? TableTableJoinIntegrationTest.this.expectedFinalMultiJoinResult : TableTableJoinIntegrationTest.this.expectedFinalJoinResult;
        }

        public void apply(Long key, String value) {
            boolean ret;
            ++TableTableJoinIntegrationTest.this.numRecordsExpected;
            if (!this.expected.value().equals(value) || !(ret = TableTableJoinIntegrationTest.this.finalResultReached.compareAndSet(false, true))) {
                // empty if block
            }
        }
    }
}

