/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.List;
import java.util.Properties;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.test.ConsumerRecordFactory;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class KStreamBranchTest {
    private final String topicName = "topic";
    private final ConsumerRecordFactory<Integer, String> recordFactory = new ConsumerRecordFactory((Serializer)new IntegerSerializer(), (Serializer)new StringSerializer());
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.String(), Serdes.String());

    @Test
    public void testKStreamBranch() {
        StreamsBuilder builder = new StreamsBuilder();
        Predicate isEven = (key, value) -> key % 2 == 0;
        Predicate isMultipleOfThree = (key, value) -> key % 3 == 0;
        Predicate isOdd = (key, value) -> key % 2 != 0;
        int[] expectedKeys = new int[]{1, 2, 3, 4, 5, 6};
        KStream stream = builder.stream("topic", Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String()));
        KStream[] branches = stream.branch(new Predicate[]{isEven, isMultipleOfThree, isOdd});
        Assert.assertEquals((long)3L, (long)branches.length);
        MockProcessorSupplier supplier = new MockProcessorSupplier();
        for (int i = 0; i < branches.length; ++i) {
            branches[i].process(supplier, new String[0]);
        }
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            for (int expectedKey : expectedKeys) {
                driver.pipeInput(this.recordFactory.create("topic", (Object)expectedKey, (Object)("V" + expectedKey)));
            }
        }
        List processors = supplier.capturedProcessors(3);
        Assert.assertEquals((long)3L, (long)processors.get((int)0).processed.size());
        Assert.assertEquals((long)1L, (long)processors.get((int)1).processed.size());
        Assert.assertEquals((long)2L, (long)processors.get((int)2).processed.size());
    }

    @Test
    public void testTypeVariance() {
        Predicate positive = (key, value) -> key.doubleValue() > 0.0;
        Predicate negative = (key, value) -> key.doubleValue() < 0.0;
        new StreamsBuilder().stream("empty").branch(new Predicate[]{positive, negative});
    }
}

