/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Transformer;
import org.apache.kafka.streams.kstream.TransformerSupplier;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.test.ConsumerRecordFactory;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.StreamsTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class KStreamTransformTest {
    private static final String TOPIC_NAME = "topic";
    private final ConsumerRecordFactory<Integer, Integer> recordFactory = new ConsumerRecordFactory((Serializer)new IntegerSerializer(), (Serializer)new IntegerSerializer(), 0L);
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.Integer(), Serdes.Integer());

    @Test
    public void testTransform() {
        StreamsBuilder builder = new StreamsBuilder();
        TransformerSupplier transformerSupplier = () -> new Transformer<Number, Number, KeyValue<Integer, Integer>>(){
            private int total = 0;

            public void init(ProcessorContext context) {
                context.schedule(Duration.ofMillis(1L), PunctuationType.WALL_CLOCK_TIME, timestamp -> context.forward((Object)-1, (Object)((int)timestamp)));
            }

            public KeyValue<Integer, Integer> transform(Number key, Number value) {
                this.total += value.intValue();
                return KeyValue.pair((Object)(key.intValue() * 2), (Object)this.total);
            }

            public void close() {
            }
        };
        int[] expectedKeys = new int[]{1, 10, 100, 1000};
        MockProcessorSupplier processor = new MockProcessorSupplier();
        KStream stream = builder.stream(TOPIC_NAME, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.Integer()));
        stream.transform(transformerSupplier, new String[0]).process(processor, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), Utils.mkProperties((Map)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"bootstrap.servers", (Object)"dummy"), Utils.mkEntry((Object)"application.id", (Object)"test")})), 0L);){
            ConsumerRecordFactory recordFactory = new ConsumerRecordFactory(TOPIC_NAME, (Serializer)new IntegerSerializer(), (Serializer)new IntegerSerializer());
            for (int expectedKey : expectedKeys) {
                driver.pipeInput(recordFactory.create((Object)expectedKey, (Object)(expectedKey * 10), (long)expectedKey / 2L));
            }
            driver.advanceWallClockTime(2L);
            driver.advanceWallClockTime(1L);
            String[] expected = new String[]{"2:10 (ts: 0)", "20:110 (ts: 5)", "200:1110 (ts: 50)", "2000:11110 (ts: 500)", "-1:2 (ts: 2)", "-1:3 (ts: 3)"};
            Assert.assertEquals((long)expected.length, (long)processor.theCapturedProcessor().processed.size());
            for (int i = 0; i < expected.length; ++i) {
                Assert.assertEquals((Object)expected[i], (Object)processor.theCapturedProcessor().processed.get(i));
            }
        }
    }

    @Test
    public void testTransformWithNewDriverAndPunctuator() {
        StreamsBuilder builder = new StreamsBuilder();
        TransformerSupplier transformerSupplier = () -> new Transformer<Number, Number, KeyValue<Integer, Integer>>(){
            private int total = 0;

            public void init(ProcessorContext context) {
                context.schedule(Duration.ofMillis(1L), PunctuationType.WALL_CLOCK_TIME, timestamp -> context.forward((Object)-1, (Object)((int)timestamp)));
            }

            public KeyValue<Integer, Integer> transform(Number key, Number value) {
                this.total += value.intValue();
                return KeyValue.pair((Object)(key.intValue() * 2), (Object)this.total);
            }

            public void close() {
            }
        };
        int[] expectedKeys = new int[]{1, 10, 100, 1000};
        MockProcessorSupplier processor = new MockProcessorSupplier();
        KStream stream = builder.stream(TOPIC_NAME, Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.Integer()));
        stream.transform(transformerSupplier, new String[0]).process(processor, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props, 0L);){
            for (int expectedKey : expectedKeys) {
                driver.pipeInput(this.recordFactory.create(TOPIC_NAME, (Object)expectedKey, (Object)(expectedKey * 10), 0L));
            }
            driver.advanceWallClockTime(2L);
            driver.advanceWallClockTime(1L);
        }
        Assert.assertEquals((long)6L, (long)processor.theCapturedProcessor().processed.size());
        String[] expected = new String[]{"2:10 (ts: 0)", "20:110 (ts: 0)", "200:1110 (ts: 0)", "2000:11110 (ts: 0)", "-1:2 (ts: 2)", "-1:3 (ts: 3)"};
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)processor.theCapturedProcessor().processed.get(i));
        }
    }
}

