/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.internals.InternalNameProvider;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.kstream.internals.TimestampedKeyValueStoreMaterializer;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.internals.CachingKeyValueStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingKeyValueBytesStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingTimestampedKeyValueBytesStore;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueStore;
import org.apache.kafka.streams.state.internals.MeteredTimestampedKeyValueStore;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.easymock.MockType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class TimestampedKeyValueStoreMaterializerTest {
    private final String storePrefix = "prefix";
    @Mock(type=MockType.NICE)
    private InternalNameProvider nameProvider;

    @Test
    public void shouldCreateBuilderThatBuildsMeteredStoreWithCachingAndLoggingEnabled() {
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((String)"store"), this.nameProvider, "prefix");
        TimestampedKeyValueStoreMaterializer materializer = new TimestampedKeyValueStoreMaterializer(materialized);
        StoreBuilder builder = materializer.materialize();
        TimestampedKeyValueStore store = (TimestampedKeyValueStore)builder.build();
        WrappedStateStore caching = (WrappedStateStore)((WrappedStateStore)store).wrapped();
        StateStore logging = caching.wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredTimestampedKeyValueStore.class));
        MatcherAssert.assertThat((Object)caching, (Matcher)IsInstanceOf.instanceOf(CachingKeyValueStore.class));
        MatcherAssert.assertThat((Object)logging, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingTimestampedKeyValueBytesStore.class));
    }

    @Test
    public void shouldCreateBuilderThatBuildsStoreWithCachingDisabled() {
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((String)"store").withCachingDisabled(), this.nameProvider, "prefix");
        TimestampedKeyValueStoreMaterializer materializer = new TimestampedKeyValueStoreMaterializer(materialized);
        StoreBuilder builder = materializer.materialize();
        TimestampedKeyValueStore store = (TimestampedKeyValueStore)builder.build();
        WrappedStateStore logging = (WrappedStateStore)((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)logging, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingKeyValueBytesStore.class));
    }

    @Test
    public void shouldCreateBuilderThatBuildsStoreWithLoggingDisabled() {
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((String)"store").withLoggingDisabled(), this.nameProvider, "prefix");
        TimestampedKeyValueStoreMaterializer materializer = new TimestampedKeyValueStoreMaterializer(materialized);
        StoreBuilder builder = materializer.materialize();
        TimestampedKeyValueStore store = (TimestampedKeyValueStore)builder.build();
        WrappedStateStore caching = (WrappedStateStore)((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)caching, (Matcher)IsInstanceOf.instanceOf(CachingKeyValueStore.class));
        MatcherAssert.assertThat((Object)caching.wrapped(), (Matcher)IsNot.not((Matcher)IsInstanceOf.instanceOf(ChangeLoggingKeyValueBytesStore.class)));
    }

    @Test
    public void shouldCreateBuilderThatBuildsStoreWithCachingAndLoggingDisabled() {
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((String)"store").withCachingDisabled().withLoggingDisabled(), this.nameProvider, "prefix");
        TimestampedKeyValueStoreMaterializer materializer = new TimestampedKeyValueStoreMaterializer(materialized);
        StoreBuilder builder = materializer.materialize();
        TimestampedKeyValueStore store = (TimestampedKeyValueStore)builder.build();
        StateStore wrapped = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsNot.not((Matcher)IsInstanceOf.instanceOf(CachingKeyValueStore.class)));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsNot.not((Matcher)IsInstanceOf.instanceOf(ChangeLoggingKeyValueBytesStore.class)));
    }

    @Test
    public void shouldCreateKeyValueStoreWithTheProvidedInnerStore() {
        KeyValueBytesStoreSupplier supplier = (KeyValueBytesStoreSupplier)EasyMock.createNiceMock(KeyValueBytesStoreSupplier.class);
        InMemoryKeyValueStore store = new InMemoryKeyValueStore("name");
        EasyMock.expect((Object)supplier.name()).andReturn((Object)"name").anyTimes();
        EasyMock.expect((Object)supplier.get()).andReturn((Object)store);
        EasyMock.replay((Object[])new Object[]{supplier});
        MaterializedInternal materialized = new MaterializedInternal(Materialized.as((KeyValueBytesStoreSupplier)supplier), this.nameProvider, "prefix");
        TimestampedKeyValueStoreMaterializer materializer = new TimestampedKeyValueStoreMaterializer(materialized);
        StoreBuilder builder = materializer.materialize();
        TimestampedKeyValueStore built = (TimestampedKeyValueStore)builder.build();
        MatcherAssert.assertThat((Object)store.name(), (Matcher)CoreMatchers.equalTo((Object)built.name()));
    }
}

