/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.time.Duration;
import java.util.LinkedList;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.internals.testutil.LogCaptureAppender;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.InMemoryWindowBytesStoreSupplier;
import org.apache.kafka.streams.state.internals.InMemoryWindowStore;
import org.apache.kafka.streams.state.internals.WindowBytesStoreTest;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.junit.Assert;
import org.junit.Test;

public class InMemoryWindowStoreTest
extends WindowBytesStoreTest {
    private static final String STORE_NAME = "InMemoryWindowStore";

    @Override
    <K, V> WindowStore<K, V> buildWindowStore(long retentionPeriod, long windowSize, boolean retainDuplicates, Serde<K> keySerde, Serde<V> valueSerde) {
        return (WindowStore)Stores.windowStoreBuilder((WindowBytesStoreSupplier)Stores.inMemoryWindowStore((String)STORE_NAME, (Duration)Duration.ofMillis(retentionPeriod), (Duration)Duration.ofMillis(windowSize), (boolean)retainDuplicates), keySerde, valueSerde).build();
    }

    @Override
    String getMetricsScope() {
        return new InMemoryWindowBytesStoreSupplier(null, 0L, 0L, false).metricsScope();
    }

    @Override
    void setClassLoggerToDebug() {
        LogCaptureAppender.setClassLoggerToDebug(InMemoryWindowStore.class);
    }

    @Test
    public void shouldRestore() {
        Assert.assertFalse((boolean)this.windowStore.all().hasNext());
        StateSerdes serdes = new StateSerdes("", Serdes.Integer(), Serdes.String());
        LinkedList<KeyValue<byte[], byte[]>> restorableEntries = new LinkedList<KeyValue<byte[], byte[]>>();
        restorableEntries.add(new KeyValue((Object)WindowKeySchema.toStoreKeyBinary((Object)1, (long)0L, (int)0, (StateSerdes)serdes).get(), (Object)serdes.rawValue((Object)"one")));
        restorableEntries.add(new KeyValue((Object)WindowKeySchema.toStoreKeyBinary((Object)2, (long)3L, (int)0, (StateSerdes)serdes).get(), (Object)serdes.rawValue((Object)"two")));
        restorableEntries.add(new KeyValue((Object)WindowKeySchema.toStoreKeyBinary((Object)3, (long)6L, (int)0, (StateSerdes)serdes).get(), (Object)serdes.rawValue((Object)"three")));
        this.context.restore(STORE_NAME, restorableEntries);
        KeyValueIterator iterator = this.windowStore.fetchAll(0L, 6L);
        Assert.assertEquals(InMemoryWindowStoreTest.windowedPair(1, "one", 0L), (Object)iterator.next());
        Assert.assertEquals(InMemoryWindowStoreTest.windowedPair(2, "two", 3L), (Object)iterator.next());
        Assert.assertEquals(InMemoryWindowStoreTest.windowedPair(3, "three", 6L), (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldNotExpireFromOpenIterator() {
        this.windowStore.put((Object)1, (Object)"one", 0L);
        this.windowStore.put((Object)1, (Object)"two", 10L);
        this.windowStore.put((Object)2, (Object)"one", 5L);
        this.windowStore.put((Object)2, (Object)"two", 15L);
        WindowStoreIterator iterator1 = this.windowStore.fetch((Object)1, 0L, 50L);
        WindowStoreIterator iterator2 = this.windowStore.fetch((Object)2, 0L, 50L);
        this.windowStore.put((Object)1, (Object)"four", 240000L);
        Assert.assertEquals((Object)new KeyValue((Object)0L, (Object)"one"), (Object)iterator1.next());
        Assert.assertEquals((Object)new KeyValue((Object)5L, (Object)"one"), (Object)iterator2.next());
        Assert.assertEquals((Object)new KeyValue((Object)15L, (Object)"two"), (Object)iterator2.next());
        Assert.assertEquals((Object)new KeyValue((Object)10L, (Object)"two"), (Object)iterator1.next());
        Assert.assertFalse((boolean)iterator1.hasNext());
        Assert.assertFalse((boolean)iterator2.hasNext());
        iterator1.close();
        iterator2.close();
        Assert.assertFalse((boolean)this.windowStore.fetch((Object)1, 0L, 50L).hasNext());
    }

    @Test
    public void testExpiration() {
        long currentTime = 0L;
        this.setCurrentTime(currentTime);
        this.windowStore.put((Object)1, (Object)"one");
        this.setCurrentTime(currentTime += 30000L);
        this.windowStore.put((Object)1, (Object)"two");
        this.setCurrentTime(currentTime += 30000L);
        this.windowStore.put((Object)1, (Object)"three");
        this.setCurrentTime(currentTime += 30000L);
        this.windowStore.put((Object)1, (Object)"four");
        this.setCurrentTime(currentTime += 30000L);
        this.windowStore.put((Object)1, (Object)"five");
        KeyValueIterator iterator = this.windowStore.fetchAll(0L, currentTime);
        this.setCurrentTime(currentTime += 30000L);
        this.windowStore.put((Object)1, (Object)"six");
        Assert.assertEquals(InMemoryWindowStoreTest.windowedPair(1, "two", 30000L), (Object)iterator.next());
        Assert.assertEquals(InMemoryWindowStoreTest.windowedPair(1, "three", 60000L), (Object)iterator.next());
        Assert.assertEquals(InMemoryWindowStoreTest.windowedPair(1, "four", 90000L), (Object)iterator.next());
        Assert.assertEquals(InMemoryWindowStoreTest.windowedPair(1, "five", 120000L), (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = this.windowStore.fetchAll(0L, currentTime);
        Assert.assertEquals(InMemoryWindowStoreTest.windowedPair(1, "three", 60000L), (Object)iterator.next());
        Assert.assertEquals(InMemoryWindowStoreTest.windowedPair(1, "four", 90000L), (Object)iterator.next());
        Assert.assertEquals(InMemoryWindowStoreTest.windowedPair(1, "five", 120000L), (Object)iterator.next());
        Assert.assertEquals(InMemoryWindowStoreTest.windowedPair(1, "six", 150000L), (Object)iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }
}

