/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.DefaultProductionExceptionHandler;
import org.apache.kafka.streams.errors.ProductionExceptionHandler;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.RecordCollectorImpl;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.testutil.LogCaptureAppender;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.TestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class SessionBytesStoreTest {
    protected static final long SEGMENT_INTERVAL = 60000L;
    protected static final long RETENTION_PERIOD = 10000L;
    protected SessionStore<String, Long> sessionStore;
    protected InternalMockProcessorContext context;
    private final List<KeyValue<byte[], byte[]>> changeLog = new ArrayList<KeyValue<byte[], byte[]>>();
    private final Producer<byte[], byte[]> producer = new MockProducer(true, Serdes.ByteArray().serializer(), Serdes.ByteArray().serializer());

    abstract <K, V> SessionStore<K, V> buildSessionStore(long var1, Serde<K> var3, Serde<V> var4);

    abstract String getMetricsScope();

    abstract void setClassLoggerToDebug();

    private RecordCollectorImpl createRecordCollector(String name) {
        return new RecordCollectorImpl(name, new LogContext(name), (ProductionExceptionHandler)new DefaultProductionExceptionHandler(), new Metrics().sensor("skipped-records")){

            public <K1, V1> void send(String topic, K1 key, V1 value, Headers headers, Integer partition, Long timestamp, Serializer<K1> keySerializer, Serializer<V1> valueSerializer) {
                SessionBytesStoreTest.this.changeLog.add(new KeyValue((Object)keySerializer.serialize(topic, headers, key), (Object)valueSerializer.serialize(topic, headers, value)));
            }
        };
    }

    @Before
    public void setUp() {
        this.sessionStore = this.buildSessionStore(10000L, Serdes.String(), Serdes.Long());
        RecordCollectorImpl recordCollector = this.createRecordCollector(this.sessionStore.name());
        recordCollector.init(this.producer);
        this.context = new InternalMockProcessorContext(TestUtils.tempDirectory(), Serdes.String(), Serdes.Long(), (RecordCollector)recordCollector, new ThreadCache(new LogContext("testCache"), 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics())));
        this.sessionStore.init((ProcessorContext)this.context, this.sessionStore);
    }

    @After
    public void after() {
        this.sessionStore.close();
    }

    @Test
    public void shouldPutAndFindSessionsInRange() {
        String key = "a";
        Windowed a1 = new Windowed((Object)"a", (Window)new SessionWindow(10L, 10L));
        Windowed a2 = new Windowed((Object)"a", (Window)new SessionWindow(500L, 1000L));
        this.sessionStore.put(a1, (Object)1L);
        this.sessionStore.put(a2, (Object)2L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(1500L, 2000L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(2500L, 3000L)), (Object)2L);
        List<KeyValue> expected = Arrays.asList(KeyValue.pair((Object)a1, (Object)1L), KeyValue.pair((Object)a2, (Object)2L));
        try (KeyValueIterator values = this.sessionStore.findSessions((Object)"a", 0L, 1000L);){
            Assert.assertEquals(new HashSet<KeyValue>(expected), SessionBytesStoreTest.toSet(values));
        }
        List<KeyValue> expected2 = Collections.singletonList(KeyValue.pair((Object)a2, (Object)2L));
        try (KeyValueIterator values2 = this.sessionStore.findSessions((Object)"a", 400L, 600L);){
            Assert.assertEquals(new HashSet<KeyValue>(expected2), SessionBytesStoreTest.toSet(values2));
        }
    }

    @Test
    public void shouldFetchAllSessionsWithSameRecordKey() {
        List<KeyValue> expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(10L, 10L)), (Object)2L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(100L, 100L)), (Object)3L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(1000L, 1000L)), (Object)4L));
        for (KeyValue kv : expected) {
            this.sessionStore.put((Windowed)kv.key, kv.value);
        }
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(0L, 0L)), (Object)5L);
        try (KeyValueIterator values = this.sessionStore.fetch((Object)"a");){
            Assert.assertEquals(new HashSet<KeyValue>(expected), SessionBytesStoreTest.toSet(values));
        }
    }

    @Test
    public void shouldFetchAllSessionsWithinKeyRange() {
        List<KeyValue> expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"aa", (Window)new SessionWindow(10L, 10L)), (Object)2L), KeyValue.pair((Object)new Windowed((Object)"b", (Window)new SessionWindow(1000L, 1000L)), (Object)4L), KeyValue.pair((Object)new Windowed((Object)"aaa", (Window)new SessionWindow(100L, 100L)), (Object)3L), KeyValue.pair((Object)new Windowed((Object)"bb", (Window)new SessionWindow(1500L, 2000L)), (Object)5L));
        for (KeyValue kv : expected) {
            this.sessionStore.put((Windowed)kv.key, kv.value);
        }
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"bbb", (Window)new SessionWindow(2500L, 3000L)), (Object)6L);
        try (KeyValueIterator values = this.sessionStore.fetch((Object)"aa", (Object)"bb");){
            Assert.assertEquals(new HashSet<KeyValue>(expected), SessionBytesStoreTest.toSet(values));
        }
    }

    @Test
    public void shouldFetchExactSession() {
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 4L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(0L, 3L)), (Object)2L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(0L, 4L)), (Object)3L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(1L, 4L)), (Object)4L);
        this.sessionStore.put(new Windowed((Object)"aaa", (Window)new SessionWindow(0L, 4L)), (Object)5L);
        long result = (Long)this.sessionStore.fetchSession((Object)"aa", 0L, 4L);
        Assert.assertEquals((long)3L, (long)result);
    }

    @Test
    public void shouldReturnNullOnSessionNotFound() {
        Assert.assertNull((Object)this.sessionStore.fetchSession((Object)"any key", 0L, 5L));
    }

    @Test
    public void shouldFindValuesWithinMergingSessionWindowRange() {
        String key = "a";
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(1000L, 1000L)), (Object)2L);
        List<KeyValue> expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(1000L, 1000L)), (Object)2L));
        try (KeyValueIterator results = this.sessionStore.findSessions((Object)"a", -1L, 1000L);){
            Assert.assertEquals(new HashSet<KeyValue>(expected), SessionBytesStoreTest.toSet(results));
        }
    }

    @Test
    public void shouldRemove() {
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 1000L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(1500L, 2500L)), (Object)2L);
        this.sessionStore.remove(new Windowed((Object)"a", (Window)new SessionWindow(0L, 1000L)));
        try (KeyValueIterator results = this.sessionStore.findSessions((Object)"a", 0L, 1000L);){
            Assert.assertFalse((boolean)results.hasNext());
        }
        results = this.sessionStore.findSessions((Object)"a", 1500L, 2500L);
        var2_2 = null;
        try {
            Assert.assertTrue((boolean)results.hasNext());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (results != null) {
                if (var2_2 != null) {
                    try {
                        results.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    results.close();
                }
            }
        }
    }

    @Test
    public void shouldRemoveOnNullAggValue() {
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 1000L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(1500L, 2500L)), (Object)2L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 1000L)), null);
        try (KeyValueIterator results = this.sessionStore.findSessions((Object)"a", 0L, 1000L);){
            Assert.assertFalse((boolean)results.hasNext());
        }
        results = this.sessionStore.findSessions((Object)"a", 1500L, 2500L);
        var2_2 = null;
        try {
            Assert.assertTrue((boolean)results.hasNext());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (results != null) {
                if (var2_2 != null) {
                    try {
                        results.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    results.close();
                }
            }
        }
    }

    @Test
    public void shouldFindSessionsToMerge() {
        Windowed session1 = new Windowed((Object)"a", (Window)new SessionWindow(0L, 100L));
        Windowed session2 = new Windowed((Object)"a", (Window)new SessionWindow(101L, 200L));
        Windowed session3 = new Windowed((Object)"a", (Window)new SessionWindow(201L, 300L));
        Windowed session4 = new Windowed((Object)"a", (Window)new SessionWindow(301L, 400L));
        Windowed session5 = new Windowed((Object)"a", (Window)new SessionWindow(401L, 500L));
        this.sessionStore.put(session1, (Object)1L);
        this.sessionStore.put(session2, (Object)2L);
        this.sessionStore.put(session3, (Object)3L);
        this.sessionStore.put(session4, (Object)4L);
        this.sessionStore.put(session5, (Object)5L);
        List<KeyValue> expected = Arrays.asList(KeyValue.pair((Object)session2, (Object)2L), KeyValue.pair((Object)session3, (Object)3L));
        try (KeyValueIterator results = this.sessionStore.findSessions((Object)"a", 150L, 300L);){
            Assert.assertEquals(new HashSet<KeyValue>(expected), SessionBytesStoreTest.toSet(results));
        }
    }

    @Test
    public void shouldFetchExactKeys() {
        this.sessionStore = this.buildSessionStore(0x7A00000000000000L, Serdes.String(), Serdes.Long());
        this.sessionStore.init((ProcessorContext)this.context, this.sessionStore);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(0L, 10L)), (Object)2L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(10L, 20L)), (Object)3L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(10L, 20L)), (Object)4L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(8791026472627208190L, 0x79FFFFFFFFFFFFFFL)), (Object)5L);
        try (KeyValueIterator iterator = this.sessionStore.findSessions((Object)"a", 0L, Long.MAX_VALUE);){
            MatcherAssert.assertThat(SessionBytesStoreTest.valuesToSet(iterator), (Matcher)CoreMatchers.equalTo(new HashSet<Long>(Arrays.asList(1L, 3L, 5L))));
        }
        iterator = this.sessionStore.findSessions((Object)"aa", 0L, Long.MAX_VALUE);
        var2_2 = null;
        try {
            MatcherAssert.assertThat(SessionBytesStoreTest.valuesToSet(iterator), (Matcher)CoreMatchers.equalTo(new HashSet<Long>(Arrays.asList(2L, 4L))));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (iterator != null) {
                if (var2_2 != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    iterator.close();
                }
            }
        }
        iterator = this.sessionStore.findSessions((Object)"a", (Object)"aa", 0L, Long.MAX_VALUE);
        var2_2 = null;
        try {
            MatcherAssert.assertThat(SessionBytesStoreTest.valuesToSet(iterator), (Matcher)CoreMatchers.equalTo(new HashSet<Long>(Arrays.asList(1L, 2L, 3L, 4L, 5L))));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (iterator != null) {
                if (var2_2 != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    iterator.close();
                }
            }
        }
        iterator = this.sessionStore.findSessions((Object)"a", (Object)"aa", 10L, 0L);
        var2_2 = null;
        try {
            MatcherAssert.assertThat(SessionBytesStoreTest.valuesToSet(iterator), (Matcher)CoreMatchers.equalTo(new HashSet<Long>(Collections.singletonList(2L))));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (iterator != null) {
                if (var2_2 != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    iterator.close();
                }
            }
        }
    }

    @Test
    public void shouldFetchAndIterateOverExactBinaryKeys() {
        SessionStore sessionStore = this.buildSessionStore(10000L, Serdes.Bytes(), Serdes.String());
        sessionStore.init((ProcessorContext)this.context, sessionStore);
        Bytes key1 = Bytes.wrap((byte[])new byte[]{0});
        Bytes key2 = Bytes.wrap((byte[])new byte[]{0, 0});
        Bytes key3 = Bytes.wrap((byte[])new byte[]{0, 0, 0});
        sessionStore.put(new Windowed((Object)key1, (Window)new SessionWindow(1L, 100L)), (Object)"1");
        sessionStore.put(new Windowed((Object)key2, (Window)new SessionWindow(2L, 100L)), (Object)"2");
        sessionStore.put(new Windowed((Object)key3, (Window)new SessionWindow(3L, 100L)), (Object)"3");
        sessionStore.put(new Windowed((Object)key1, (Window)new SessionWindow(4L, 100L)), (Object)"4");
        sessionStore.put(new Windowed((Object)key2, (Window)new SessionWindow(5L, 100L)), (Object)"5");
        sessionStore.put(new Windowed((Object)key3, (Window)new SessionWindow(6L, 100L)), (Object)"6");
        sessionStore.put(new Windowed((Object)key1, (Window)new SessionWindow(7L, 100L)), (Object)"7");
        sessionStore.put(new Windowed((Object)key2, (Window)new SessionWindow(8L, 100L)), (Object)"8");
        sessionStore.put(new Windowed((Object)key3, (Window)new SessionWindow(9L, 100L)), (Object)"9");
        HashSet<String> expectedKey1 = new HashSet<String>(Arrays.asList("1", "4", "7"));
        MatcherAssert.assertThat(SessionBytesStoreTest.valuesToSet(sessionStore.findSessions((Object)key1, 0L, Long.MAX_VALUE)), (Matcher)CoreMatchers.equalTo(expectedKey1));
        HashSet<String> expectedKey2 = new HashSet<String>(Arrays.asList("2", "5", "8"));
        MatcherAssert.assertThat(SessionBytesStoreTest.valuesToSet(sessionStore.findSessions((Object)key2, 0L, Long.MAX_VALUE)), (Matcher)CoreMatchers.equalTo(expectedKey2));
        HashSet<String> expectedKey3 = new HashSet<String>(Arrays.asList("3", "6", "9"));
        MatcherAssert.assertThat(SessionBytesStoreTest.valuesToSet(sessionStore.findSessions((Object)key3, 0L, Long.MAX_VALUE)), (Matcher)CoreMatchers.equalTo(expectedKey3));
    }

    @Test
    public void testIteratorPeek() {
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(0L, 10L)), (Object)2L);
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(10L, 20L)), (Object)3L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(10L, 20L)), (Object)4L);
        KeyValueIterator iterator = this.sessionStore.findSessions((Object)"a", 0L, 20L);
        Assert.assertEquals((Object)iterator.peekNextKey(), (Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)));
        Assert.assertEquals((Object)iterator.peekNextKey(), (Object)((KeyValue)iterator.next()).key);
        Assert.assertEquals((Object)iterator.peekNextKey(), (Object)((KeyValue)iterator.next()).key);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldRestore() {
        List<KeyValue> expected = Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(10L, 10L)), (Object)2L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(100L, 100L)), (Object)3L), KeyValue.pair((Object)new Windowed((Object)"a", (Window)new SessionWindow(1000L, 1000L)), (Object)4L));
        for (KeyValue kv : expected) {
            this.sessionStore.put((Windowed)kv.key, kv.value);
        }
        try (KeyValueIterator values = this.sessionStore.fetch((Object)"a");){
            Assert.assertEquals(new HashSet<KeyValue>(expected), SessionBytesStoreTest.toSet(values));
        }
        this.sessionStore.close();
        values = this.sessionStore.fetch((Object)"a");
        var3_3 = null;
        try {
            Assert.assertEquals(Collections.emptySet(), SessionBytesStoreTest.toSet(values));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (values != null) {
                if (var3_3 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    values.close();
                }
            }
        }
        this.context.restore(this.sessionStore.name(), this.changeLog);
        values = this.sessionStore.fetch((Object)"a");
        var3_3 = null;
        try {
            Assert.assertEquals(new HashSet<KeyValue>(expected), SessionBytesStoreTest.toSet(values));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (values != null) {
                if (var3_3 != null) {
                    try {
                        values.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    values.close();
                }
            }
        }
    }

    @Test
    public void shouldCloseOpenIteratorsWhenStoreIsClosedAndNotThrowInvalidStateStoreExceptionOnHasNext() {
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 0L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"b", (Window)new SessionWindow(10L, 50L)), (Object)2L);
        this.sessionStore.put(new Windowed((Object)"c", (Window)new SessionWindow(100L, 500L)), (Object)3L);
        KeyValueIterator iterator = this.sessionStore.fetch((Object)"a");
        Assert.assertTrue((boolean)iterator.hasNext());
        this.sessionStore.close();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldReturnSameResultsForSingleKeyFindSessionsAndEqualKeyRangeFindSessions() {
        this.sessionStore.put(new Windowed((Object)"a", (Window)new SessionWindow(0L, 1L)), (Object)0L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(2L, 3L)), (Object)1L);
        this.sessionStore.put(new Windowed((Object)"aa", (Window)new SessionWindow(4L, 5L)), (Object)2L);
        this.sessionStore.put(new Windowed((Object)"aaa", (Window)new SessionWindow(6L, 7L)), (Object)3L);
        KeyValueIterator singleKeyIterator = this.sessionStore.findSessions((Object)"aa", 0L, 10L);
        KeyValueIterator rangeIterator = this.sessionStore.findSessions((Object)"aa", (Object)"aa", 0L, 10L);
        Assert.assertEquals((Object)singleKeyIterator.next(), (Object)rangeIterator.next());
        Assert.assertEquals((Object)singleKeyIterator.next(), (Object)rangeIterator.next());
        Assert.assertFalse((boolean)singleKeyIterator.hasNext());
        Assert.assertFalse((boolean)rangeIterator.hasNext());
    }

    @Test
    public void shouldLogAndMeasureExpiredRecords() {
        this.setClassLoggerToDebug();
        LogCaptureAppender appender = LogCaptureAppender.createAndRegister();
        this.sessionStore.put(new Windowed((Object)"initial record", (Window)new SessionWindow(0L, 120000L)), (Object)0L);
        this.sessionStore.put(new Windowed((Object)"late record", (Window)new SessionWindow(0L, 0L)), (Object)0L);
        this.sessionStore.put(new Windowed((Object)"another on-time record", (Window)new SessionWindow(0L, 120000L)), (Object)0L);
        LogCaptureAppender.unregister(appender);
        Map metrics = this.context.metrics().metrics();
        String metricScope = this.getMetricsScope();
        Metric dropTotal = (Metric)metrics.get(new MetricName("expired-window-record-drop-total", "stream-" + metricScope + "-metrics", "The total number of occurrence of expired-window-record-drop operations.", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"client-id", (Object)"mock"), Utils.mkEntry((Object)"task-id", (Object)"0_0"), Utils.mkEntry((Object)(metricScope + "-id"), (Object)this.sessionStore.name())})));
        Metric dropRate = (Metric)metrics.get(new MetricName("expired-window-record-drop-rate", "stream-" + metricScope + "-metrics", "The average number of occurrence of expired-window-record-drop operation per second.", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"client-id", (Object)"mock"), Utils.mkEntry((Object)"task-id", (Object)"0_0"), Utils.mkEntry((Object)(metricScope + "-id"), (Object)this.sessionStore.name())})));
        Assert.assertEquals((Object)1.0, (Object)dropTotal.metricValue());
        Assert.assertNotEquals((Object)0.0, (Object)dropRate.metricValue());
        List<String> messages = appender.getMessages();
        MatcherAssert.assertThat(messages, (Matcher)CoreMatchers.hasItem((Object)"Skipping record for expired segment."));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnFindSessionsNullKey() {
        this.sessionStore.findSessions(null, 1L, 2L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnFindSessionsNullFromKey() {
        this.sessionStore.findSessions(null, (Object)"anyKeyTo", 1L, 2L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnFindSessionsNullToKey() {
        this.sessionStore.findSessions((Object)"anyKeyFrom", null, 1L, 2L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnFetchNullFromKey() {
        this.sessionStore.fetch(null, (Object)"anyToKey");
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnFetchNullToKey() {
        this.sessionStore.fetch((Object)"anyFromKey", null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnFetchNullKey() {
        this.sessionStore.fetch(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnRemoveNullKey() {
        this.sessionStore.remove(null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerExceptionOnPutNullKey() {
        this.sessionStore.put(null, (Object)1L);
    }

    @Test
    public void shouldNotThrowInvalidRangeExceptionWithNegativeFromKey() {
        this.setClassLoggerToDebug();
        LogCaptureAppender appender = LogCaptureAppender.createAndRegister();
        String keyFrom = (String)Serdes.String().deserializer().deserialize("", Serdes.Integer().serializer().serialize("", (Object)-1));
        String keyTo = (String)Serdes.String().deserializer().deserialize("", Serdes.Integer().serializer().serialize("", (Object)1));
        KeyValueIterator iterator = this.sessionStore.findSessions((Object)keyFrom, (Object)keyTo, 0L, 10L);
        Assert.assertFalse((boolean)iterator.hasNext());
        List<String> messages = appender.getMessages();
        MatcherAssert.assertThat(messages, (Matcher)CoreMatchers.hasItem((Object)"Returning empty iterator for fetch with invalid key range: from > to. This may be due to serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers"));
    }

    protected static <K, V> Set<V> valuesToSet(Iterator<KeyValue<K, V>> iterator) {
        HashSet<Object> results = new HashSet<Object>();
        while (iterator.hasNext()) {
            results.add(iterator.next().value);
        }
        return results;
    }

    protected static <K, V> Set<KeyValue<K, V>> toSet(Iterator<KeyValue<K, V>> iterator) {
        HashSet<KeyValue<K, V>> results = new HashSet<KeyValue<K, V>>();
        while (iterator.hasNext()) {
            results.add(iterator.next());
        }
        return results;
    }
}

