/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.internals.CachingKeyValueStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingTimestampedKeyValueBytesStore;
import org.apache.kafka.streams.state.internals.KeyValueToTimestampedKeyValueByteStoreAdapter;
import org.apache.kafka.streams.state.internals.MeteredTimestampedKeyValueStore;
import org.apache.kafka.streams.state.internals.RocksDBStore;
import org.apache.kafka.streams.state.internals.RocksDBTimestampedStore;
import org.apache.kafka.streams.state.internals.TimestampedKeyValueStoreBuilder;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.easymock.MockType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class TimestampedKeyValueStoreBuilderTest {
    @Mock(type=MockType.NICE)
    private KeyValueBytesStoreSupplier supplier;
    @Mock(type=MockType.NICE)
    private RocksDBTimestampedStore inner;
    private TimestampedKeyValueStoreBuilder<String, String> builder;

    @Before
    public void setUp() {
        EasyMock.expect((Object)this.supplier.get()).andReturn((Object)this.inner);
        EasyMock.expect((Object)this.supplier.name()).andReturn((Object)"name");
        EasyMock.expect((Object)this.inner.persistent()).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.supplier, this.inner});
        this.builder = new TimestampedKeyValueStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime());
    }

    @Test
    public void shouldHaveMeteredStoreAsOuterStore() {
        TimestampedKeyValueStore store = this.builder.build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredTimestampedKeyValueStore.class));
    }

    @Test
    public void shouldHaveChangeLoggingStoreByDefault() {
        TimestampedKeyValueStore store = this.builder.build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredTimestampedKeyValueStore.class));
        StateStore next = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)next, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingTimestampedKeyValueBytesStore.class));
    }

    @Test
    public void shouldNotHaveChangeLoggingStoreWhenDisabled() {
        TimestampedKeyValueStore store = (TimestampedKeyValueStore)this.builder.withLoggingDisabled().build();
        StateStore next = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)next, (Matcher)CoreMatchers.equalTo((Object)this.inner));
    }

    @Test
    public void shouldHaveCachingStoreWhenEnabled() {
        TimestampedKeyValueStore store = (TimestampedKeyValueStore)this.builder.withCachingEnabled().build();
        StateStore wrapped = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredTimestampedKeyValueStore.class));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsInstanceOf.instanceOf(CachingKeyValueStore.class));
    }

    @Test
    public void shouldHaveChangeLoggingStoreWhenLoggingEnabled() {
        TimestampedKeyValueStore store = (TimestampedKeyValueStore)this.builder.withLoggingEnabled(Collections.emptyMap()).build();
        StateStore wrapped = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredTimestampedKeyValueStore.class));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingTimestampedKeyValueBytesStore.class));
        MatcherAssert.assertThat((Object)((WrappedStateStore)wrapped).wrapped(), (Matcher)CoreMatchers.equalTo((Object)this.inner));
    }

    @Test
    public void shouldHaveCachingAndChangeLoggingWhenBothEnabled() {
        TimestampedKeyValueStore store = (TimestampedKeyValueStore)this.builder.withLoggingEnabled(Collections.emptyMap()).withCachingEnabled().build();
        WrappedStateStore caching = (WrappedStateStore)((WrappedStateStore)store).wrapped();
        WrappedStateStore changeLogging = (WrappedStateStore)caching.wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(MeteredTimestampedKeyValueStore.class));
        MatcherAssert.assertThat((Object)caching, (Matcher)IsInstanceOf.instanceOf(CachingKeyValueStore.class));
        MatcherAssert.assertThat((Object)changeLogging, (Matcher)IsInstanceOf.instanceOf(ChangeLoggingTimestampedKeyValueBytesStore.class));
        MatcherAssert.assertThat((Object)changeLogging.wrapped(), (Matcher)CoreMatchers.equalTo((Object)this.inner));
    }

    @Test
    public void shouldNotWrapTimestampedByteStore() {
        EasyMock.reset((Object[])new Object[]{this.supplier});
        EasyMock.expect((Object)this.supplier.get()).andReturn((Object)new RocksDBTimestampedStore("name"));
        EasyMock.expect((Object)this.supplier.name()).andReturn((Object)"name");
        EasyMock.replay((Object[])new Object[]{this.supplier});
        TimestampedKeyValueStore store = (TimestampedKeyValueStore)this.builder.withLoggingDisabled().withCachingDisabled().build();
        MatcherAssert.assertThat((Object)((WrappedStateStore)store).wrapped(), (Matcher)IsInstanceOf.instanceOf(RocksDBTimestampedStore.class));
    }

    @Test
    public void shouldWrapPlainKeyValueStoreAsTimestampStore() {
        EasyMock.reset((Object[])new Object[]{this.supplier});
        EasyMock.expect((Object)this.supplier.get()).andReturn((Object)new RocksDBStore("name"));
        EasyMock.expect((Object)this.supplier.name()).andReturn((Object)"name");
        EasyMock.replay((Object[])new Object[]{this.supplier});
        TimestampedKeyValueStore store = (TimestampedKeyValueStore)this.builder.withLoggingDisabled().withCachingDisabled().build();
        MatcherAssert.assertThat((Object)((WrappedStateStore)store).wrapped(), (Matcher)IsInstanceOf.instanceOf(KeyValueToTimestampedKeyValueByteStoreAdapter.class));
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerIfInnerIsNull() {
        new TimestampedKeyValueStoreBuilder(null, Serdes.String(), Serdes.String(), (Time)new MockTime());
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerIfKeySerdeIsNull() {
        new TimestampedKeyValueStoreBuilder(this.supplier, null, Serdes.String(), (Time)new MockTime());
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerIfValueSerdeIsNull() {
        new TimestampedKeyValueStoreBuilder(this.supplier, Serdes.String(), null, (Time)new MockTime());
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerIfTimeIsNull() {
        new TimestampedKeyValueStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), null);
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowNullPointerIfMetricsScopeIsNull() {
        new TimestampedKeyValueStoreBuilder(this.supplier, Serdes.String(), Serdes.String(), (Time)new MockTime());
    }
}

