/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Properties;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.errors.DefaultProductionExceptionHandler;
import org.apache.kafka.streams.errors.ProductionExceptionHandler;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.RecordCollectorImpl;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class ProcessorNodeTest {
    @Test(expected=StreamsException.class)
    public void shouldThrowStreamsExceptionIfExceptionCaughtDuringInit() {
        ProcessorNode node = new ProcessorNode("name", (Processor)new ExceptionalProcessor(), Collections.emptySet());
        node.init(null);
    }

    @Test(expected=StreamsException.class)
    public void shouldThrowStreamsExceptionIfExceptionCaughtDuringClose() {
        ProcessorNode node = new ProcessorNode("name", (Processor)new ExceptionalProcessor(), Collections.emptySet());
        node.close();
    }

    @Test
    public void testMetrics() {
        StateSerdes anyStateSerde = StateSerdes.withBuiltinTypes((String)"anyName", Bytes.class, Bytes.class);
        Metrics metrics = new Metrics();
        InternalMockProcessorContext context = new InternalMockProcessorContext(anyStateSerde, (RecordCollector)new RecordCollectorImpl(null, new LogContext("processnode-test "), (ProductionExceptionHandler)new DefaultProductionExceptionHandler(), metrics.sensor("skipped-records")), metrics);
        ProcessorNode node = new ProcessorNode("name", (Processor)new NoOpProcessor(), Collections.emptySet());
        node.init((InternalProcessorContext)context);
        String threadId = Thread.currentThread().getName();
        String[] latencyOperations = new String[]{"process", "punctuate", "create", "destroy"};
        String throughputOperation = "forward";
        String groupName = "stream-processor-node-metrics";
        LinkedHashMap<String, String> metricTags = new LinkedHashMap<String, String>();
        metricTags.put("processor-node-id", node.name());
        metricTags.put("task-id", context.taskId().toString());
        metricTags.put("client-id", threadId);
        for (String opName : latencyOperations) {
            StreamsTestUtils.getMetricByNameFilterByTags(metrics.metrics(), opName + "-latency-avg", "stream-processor-node-metrics", metricTags);
            StreamsTestUtils.getMetricByNameFilterByTags(metrics.metrics(), opName + "-latency-max", "stream-processor-node-metrics", metricTags);
            StreamsTestUtils.getMetricByNameFilterByTags(metrics.metrics(), opName + "-rate", "stream-processor-node-metrics", metricTags);
            StreamsTestUtils.getMetricByNameFilterByTags(metrics.metrics(), opName + "-total", "stream-processor-node-metrics", metricTags);
        }
        Assert.assertNotNull(metrics.metrics().get(metrics.metricName("forward-rate", "stream-processor-node-metrics", "The average number of occurrence of forward operation per second.", metricTags)));
        metricTags.put("processor-node-id", "all");
        for (String opName : latencyOperations) {
            StreamsTestUtils.getMetricByNameFilterByTags(metrics.metrics(), opName + "-latency-avg", "stream-processor-node-metrics", metricTags);
            StreamsTestUtils.getMetricByNameFilterByTags(metrics.metrics(), opName + "-latency-max", "stream-processor-node-metrics", metricTags);
            StreamsTestUtils.getMetricByNameFilterByTags(metrics.metrics(), opName + "-rate", "stream-processor-node-metrics", metricTags);
            StreamsTestUtils.getMetricByNameFilterByTags(metrics.metrics(), opName + "-total", "stream-processor-node-metrics", metricTags);
        }
        Assert.assertNotNull(metrics.metrics().get(metrics.metricName("forward-rate", "stream-processor-node-metrics", "The average number of occurrence of forward operation per second.", metricTags)));
        JmxReporter reporter = new JmxReporter("kafka.streams");
        metrics.addReporter((MetricsReporter)reporter);
        Assert.assertTrue((boolean)reporter.containsMbean(String.format("kafka.streams:type=%s,client-id=%s,task-id=%s,processor-node-id=%s", "stream-processor-node-metrics", threadId, context.taskId().toString(), node.name())));
    }

    @Test
    public void testTopologyLevelClassCastException() {
        Properties props = new Properties();
        props.put("application.id", "test");
        props.put("bootstrap.servers", "dummy:1234");
        StreamsBuilder builder = new StreamsBuilder();
        builder.stream("streams-plaintext-input").flatMapValues(value -> Arrays.asList(""));
        Topology topology = builder.build();
        TopologyTestDriver testDriver = new TopologyTestDriver(topology, props);
        TestInputTopic topic = testDriver.createInputTopic("streams-plaintext-input", (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        StreamsException se = (StreamsException)Assert.assertThrows(StreamsException.class, () -> topic.pipeInput((Object)"a-key", (Object)"a value"));
        String msg = se.getMessage();
        Assert.assertTrue((String)"Error about class cast with serdes", (boolean)msg.contains("ClassCastException"));
        Assert.assertTrue((String)"Error about class cast with serdes", (boolean)msg.contains("Serdes"));
    }

    @Test
    public void testTopologyLevelClassCastExceptionDirect() {
        ProcessorNode node = new ProcessorNode("name", (Processor)new ClassCastProcessor(), Collections.emptySet());
        StreamsException se = (StreamsException)Assert.assertThrows(StreamsException.class, () -> node.process((Object)"aKey", (Object)"aValue"));
        MatcherAssert.assertThat((Object)se.getCause(), (Matcher)CoreMatchers.instanceOf(ClassCastException.class));
        MatcherAssert.assertThat((Object)se.getMessage(), (Matcher)CoreMatchers.containsString((String)"default Serdes"));
        MatcherAssert.assertThat((Object)se.getMessage(), (Matcher)CoreMatchers.containsString((String)"input types"));
    }

    private static class ClassCastProcessor
    extends ExceptionalProcessor {
        private ClassCastProcessor() {
        }

        @Override
        public void process(Object key, Object value) {
            throw new ClassCastException("Incompatible types simulation exception.");
        }
    }

    private static class NoOpProcessor
    implements Processor<Object, Object> {
        private NoOpProcessor() {
        }

        public void init(ProcessorContext context) {
        }

        public void process(Object key, Object value) {
        }

        public void close() {
        }
    }

    private static class ExceptionalProcessor
    implements Processor<Object, Object> {
        private ExceptionalProcessor() {
        }

        public void init(ProcessorContext context) {
            throw new RuntimeException();
        }

        public void process(Object key, Object value) {
            throw new RuntimeException();
        }

        public void close() {
            throw new RuntimeException();
        }
    }
}

