/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.processor.StateRestoreListener;
import org.apache.kafka.streams.processor.internals.CompositeRestoreListener;
import org.apache.kafka.streams.state.internals.RecordConverter;

public class StateRestorer {
    static final int NO_CHECKPOINT = -1;
    private final long offsetLimit;
    private final boolean persistent;
    private final String storeName;
    private final TopicPartition partition;
    private final CompositeRestoreListener compositeRestoreListener;
    private final RecordConverter recordConverter;
    private long checkpointOffset;
    private long restoredOffset;
    private long startingOffset;
    private long endingOffset;

    StateRestorer(TopicPartition partition, CompositeRestoreListener compositeRestoreListener, Long checkpoint, long offsetLimit, boolean persistent, String storeName, RecordConverter recordConverter) {
        this.partition = partition;
        this.compositeRestoreListener = compositeRestoreListener;
        this.checkpointOffset = checkpoint == null ? -1L : checkpoint;
        this.offsetLimit = offsetLimit;
        this.persistent = persistent;
        this.storeName = storeName;
        this.recordConverter = recordConverter;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    public String storeName() {
        return this.storeName;
    }

    long checkpoint() {
        return this.checkpointOffset;
    }

    void setCheckpointOffset(long checkpointOffset) {
        this.checkpointOffset = checkpointOffset;
    }

    void restoreStarted() {
        this.compositeRestoreListener.onRestoreStart(this.partition, this.storeName, this.startingOffset, this.endingOffset);
    }

    void restoreDone() {
        this.compositeRestoreListener.onRestoreEnd(this.partition, this.storeName, this.restoredNumRecords());
    }

    void restoreBatchCompleted(long currentRestoredOffset, int numRestored) {
        this.compositeRestoreListener.onBatchRestored(this.partition, this.storeName, currentRestoredOffset, numRestored);
    }

    void restore(Collection<ConsumerRecord<byte[], byte[]>> records) {
        ArrayList<ConsumerRecord<byte[], byte[]>> convertedRecords = new ArrayList<ConsumerRecord<byte[], byte[]>>(records.size());
        for (ConsumerRecord<byte[], byte[]> record : records) {
            convertedRecords.add(this.recordConverter.convert(record));
        }
        this.compositeRestoreListener.restoreBatch(convertedRecords);
    }

    boolean isPersistent() {
        return this.persistent;
    }

    void setUserRestoreListener(StateRestoreListener userRestoreListener) {
        this.compositeRestoreListener.setUserRestoreListener(userRestoreListener);
    }

    void setRestoredOffset(long restoredOffset) {
        this.restoredOffset = Math.min(this.offsetLimit, restoredOffset);
    }

    void setStartingOffset(long startingOffset) {
        this.startingOffset = Math.min(this.offsetLimit, startingOffset);
    }

    void setEndingOffset(long endingOffset) {
        this.endingOffset = Math.min(this.offsetLimit, endingOffset);
    }

    long startingOffset() {
        return this.startingOffset;
    }

    boolean hasCompleted(long recordOffset, long endOffset) {
        return endOffset == 0L || recordOffset >= this.readTo(endOffset);
    }

    Long restoredOffset() {
        return this.restoredOffset;
    }

    long restoredNumRecords() {
        return this.restoredOffset - this.startingOffset;
    }

    long offsetLimit() {
        return this.offsetLimit;
    }

    private Long readTo(long endOffset) {
        return endOffset < this.offsetLimit ? endOffset : this.offsetLimit;
    }
}

