/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.streams.kstream.ValueTransformer;
import org.apache.kafka.streams.kstream.ValueTransformerSupplier;
import org.apache.kafka.streams.kstream.ValueTransformerWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerWithKeySupplier;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.kstream.internals.graph.StreamsGraphNode;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;

public abstract class AbstractStream<K, V> {
    protected final String name;
    protected final Serde<K> keySerde;
    protected final Serde<V> valSerde;
    protected final Set<String> subTopologySourceNodes;
    protected final StreamsGraphNode streamsGraphNode;
    protected final InternalStreamsBuilder builder;

    public AbstractStream(AbstractStream<K, V> stream) {
        this.name = stream.name;
        this.builder = stream.builder;
        this.keySerde = stream.keySerde;
        this.valSerde = stream.valSerde;
        this.subTopologySourceNodes = stream.subTopologySourceNodes;
        this.streamsGraphNode = stream.streamsGraphNode;
    }

    AbstractStream(String name, Serde<K> keySerde, Serde<V> valSerde, Set<String> subTopologySourceNodes, StreamsGraphNode streamsGraphNode, InternalStreamsBuilder builder) {
        if (subTopologySourceNodes == null || subTopologySourceNodes.isEmpty()) {
            throw new IllegalArgumentException("parameter <sourceNodes> must not be null or empty");
        }
        this.name = name;
        this.builder = builder;
        this.keySerde = keySerde;
        this.valSerde = valSerde;
        this.subTopologySourceNodes = subTopologySourceNodes;
        this.streamsGraphNode = streamsGraphNode;
    }

    protected InternalTopologyBuilder internalTopologyBuilder() {
        return this.builder.internalTopologyBuilder;
    }

    Set<String> ensureCopartitionWith(Collection<? extends AbstractStream<K, ?>> otherStreams) {
        HashSet<String> allSourceNodes = new HashSet<String>(this.subTopologySourceNodes);
        for (AbstractStream<K, ?> other : otherStreams) {
            allSourceNodes.addAll(other.subTopologySourceNodes);
        }
        this.builder.internalTopologyBuilder.copartitionSources(allSourceNodes);
        return allSourceNodes;
    }

    static <T2, T1, R> ValueJoiner<T2, T1, R> reverseJoiner(ValueJoiner<T1, T2, R> joiner) {
        return (value2, value1) -> joiner.apply(value1, value2);
    }

    static <K, V, VR> ValueMapperWithKey<K, V, VR> withKey(ValueMapper<V, VR> valueMapper) {
        Objects.requireNonNull(valueMapper, "valueMapper can't be null");
        return (readOnlyKey, value) -> valueMapper.apply(value);
    }

    static <K, V, VR> ValueTransformerWithKeySupplier<K, V, VR> toValueTransformerWithKeySupplier(ValueTransformerSupplier<V, VR> valueTransformerSupplier) {
        Objects.requireNonNull(valueTransformerSupplier, "valueTransformerSupplier can't be null");
        return () -> {
            final ValueTransformer valueTransformer = valueTransformerSupplier.get();
            return new ValueTransformerWithKey<K, V, VR>(){

                @Override
                public void init(ProcessorContext context) {
                    valueTransformer.init(context);
                }

                @Override
                public VR transform(K readOnlyKey, V value) {
                    return valueTransformer.transform(value);
                }

                @Override
                public void close() {
                    valueTransformer.close();
                }
            };
        };
    }

    public Serde<K> keySerde() {
        return this.keySerde;
    }

    public Serde<V> valueSerde() {
        return this.valSerde;
    }
}

