/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.kstream.internals.WrappingNullableUtils;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.CachedStateStore;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.apache.kafka.streams.state.internals.metrics.StateStoreMetrics;

public class MeteredKeyValueStore<K, V>
extends WrappedStateStore<KeyValueStore<Bytes, byte[]>, K, V>
implements KeyValueStore<K, V> {
    final Serde<K> keySerde;
    final Serde<V> valueSerde;
    StateSerdes<K, V> serdes;
    private final String metricsScope;
    protected final Time time;
    protected Sensor putSensor;
    private Sensor putIfAbsentSensor;
    protected Sensor getSensor;
    private Sensor deleteSensor;
    private Sensor putAllSensor;
    private Sensor allSensor;
    private Sensor rangeSensor;
    private Sensor flushSensor;
    private StreamsMetricsImpl streamsMetrics;
    private final String threadId;
    private String taskId;

    MeteredKeyValueStore(KeyValueStore<Bytes, byte[]> inner, String metricsScope, Time time, Serde<K> keySerde, Serde<V> valueSerde) {
        super(inner);
        this.metricsScope = metricsScope;
        this.threadId = Thread.currentThread().getName();
        this.time = time != null ? time : Time.SYSTEM;
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.taskId = context.taskId().toString();
        this.initStoreSerde(context);
        this.streamsMetrics = (StreamsMetricsImpl)context.metrics();
        this.putSensor = StateStoreMetrics.putSensor(this.threadId, this.taskId, this.metricsScope, this.name(), this.streamsMetrics);
        this.putIfAbsentSensor = StateStoreMetrics.putIfAbsentSensor(this.threadId, this.taskId, this.metricsScope, this.name(), this.streamsMetrics);
        this.putAllSensor = StateStoreMetrics.putAllSensor(this.threadId, this.taskId, this.metricsScope, this.name(), this.streamsMetrics);
        this.getSensor = StateStoreMetrics.getSensor(this.threadId, this.taskId, this.metricsScope, this.name(), this.streamsMetrics);
        this.allSensor = StateStoreMetrics.allSensor(this.threadId, this.taskId, this.metricsScope, this.name(), this.streamsMetrics);
        this.rangeSensor = StateStoreMetrics.rangeSensor(this.threadId, this.taskId, this.metricsScope, this.name(), this.streamsMetrics);
        this.flushSensor = StateStoreMetrics.flushSensor(this.threadId, this.taskId, this.metricsScope, this.name(), this.streamsMetrics);
        this.deleteSensor = StateStoreMetrics.deleteSensor(this.threadId, this.taskId, this.metricsScope, this.name(), this.streamsMetrics);
        Sensor restoreSensor = StateStoreMetrics.restoreSensor(this.threadId, this.taskId, this.metricsScope, this.name(), this.streamsMetrics);
        StreamsMetricsImpl.maybeMeasureLatency(() -> super.init(context, root), this.time, restoreSensor);
    }

    protected Serde<V> prepareValueSerdeForStore(Serde<V> valueSerde, Serde<?> contextKeySerde, Serde<?> contextValueSerde) {
        return WrappingNullableUtils.prepareValueSerde(valueSerde, contextKeySerde, contextValueSerde);
    }

    @Deprecated
    void initStoreSerde(ProcessorContext context) {
        this.serdes = new StateSerdes<K, V>(ProcessorStateManager.storeChangelogTopic(context.applicationId(), this.name()), WrappingNullableUtils.prepareKeySerde(this.keySerde, context.keySerde(), context.valueSerde()), this.prepareValueSerdeForStore(this.valueSerde, context.keySerde(), context.valueSerde()));
    }

    @Override
    public boolean setFlushListener(CacheFlushListener<K, V> listener, boolean sendOldValues) {
        KeyValueStore wrapped = (KeyValueStore)this.wrapped();
        if (wrapped instanceof CachedStateStore) {
            return ((CachedStateStore)((Object)wrapped)).setFlushListener((rawKey, rawNewValue, rawOldValue, timestamp) -> listener.apply(this.serdes.keyFrom((byte[])rawKey), rawNewValue != null ? (Object)this.serdes.valueFrom((byte[])rawNewValue) : null, rawOldValue != null ? (Object)this.serdes.valueFrom((byte[])rawOldValue) : null, timestamp), sendOldValues);
        }
        return false;
    }

    @Override
    public V get(K key) {
        try {
            return (V)StreamsMetricsImpl.maybeMeasureLatency(() -> this.outerValue((byte[])((KeyValueStore)this.wrapped()).get(this.keyBytes(key))), this.time, this.getSensor);
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), key);
            throw new ProcessorStateException(message, (Throwable)((Object)e));
        }
    }

    @Override
    public void put(K key, V value) {
        try {
            StreamsMetricsImpl.maybeMeasureLatency(() -> ((KeyValueStore)this.wrapped()).put(this.keyBytes(key), this.serdes.rawValue(value)), this.time, this.putSensor);
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), key, value);
            throw new ProcessorStateException(message, (Throwable)((Object)e));
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return (V)StreamsMetricsImpl.maybeMeasureLatency(() -> this.outerValue(((KeyValueStore)this.wrapped()).putIfAbsent(this.keyBytes(key), this.serdes.rawValue(value))), this.time, this.putIfAbsentSensor);
    }

    @Override
    public void putAll(List<KeyValue<K, V>> entries) {
        StreamsMetricsImpl.maybeMeasureLatency(() -> ((KeyValueStore)this.wrapped()).putAll(this.innerEntries(entries)), this.time, this.putAllSensor);
    }

    @Override
    public V delete(K key) {
        try {
            return (V)StreamsMetricsImpl.maybeMeasureLatency(() -> this.outerValue((byte[])((KeyValueStore)this.wrapped()).delete(this.keyBytes(key))), this.time, this.deleteSensor);
        }
        catch (ProcessorStateException e) {
            String message = String.format(e.getMessage(), key);
            throw new ProcessorStateException(message, (Throwable)((Object)e));
        }
    }

    @Override
    public KeyValueIterator<K, V> range(K from, K to) {
        return new MeteredKeyValueIterator(((KeyValueStore)this.wrapped()).range(Bytes.wrap((byte[])this.serdes.rawKey(from)), Bytes.wrap((byte[])this.serdes.rawKey(to))), this.rangeSensor);
    }

    @Override
    public KeyValueIterator<K, V> all() {
        return new MeteredKeyValueIterator(((KeyValueStore)this.wrapped()).all(), this.allSensor);
    }

    @Override
    public void flush() {
        StreamsMetricsImpl.maybeMeasureLatency(() -> super.flush(), this.time, this.flushSensor);
    }

    @Override
    public long approximateNumEntries() {
        return ((KeyValueStore)this.wrapped()).approximateNumEntries();
    }

    @Override
    public void close() {
        try {
            ((KeyValueStore)this.wrapped()).close();
        }
        finally {
            this.streamsMetrics.removeAllStoreLevelSensors(this.threadId, this.taskId, this.name());
        }
    }

    protected V outerValue(byte[] value) {
        return value != null ? (V)this.serdes.valueFrom(value) : null;
    }

    protected Bytes keyBytes(K key) {
        return Bytes.wrap((byte[])this.serdes.rawKey(key));
    }

    private List<KeyValue<Bytes, byte[]>> innerEntries(List<KeyValue<K, V>> from) {
        ArrayList<KeyValue<Bytes, byte[]>> byteEntries = new ArrayList<KeyValue<Bytes, byte[]>>();
        for (KeyValue<K, V> entry : from) {
            byteEntries.add(KeyValue.pair(Bytes.wrap((byte[])this.serdes.rawKey(entry.key)), this.serdes.rawValue(entry.value)));
        }
        return byteEntries;
    }

    private class MeteredKeyValueIterator
    implements KeyValueIterator<K, V> {
        private final KeyValueIterator<Bytes, byte[]> iter;
        private final Sensor sensor;
        private final long startNs;

        private MeteredKeyValueIterator(KeyValueIterator<Bytes, byte[]> iter, Sensor sensor) {
            this.iter = iter;
            this.sensor = sensor;
            this.startNs = MeteredKeyValueStore.this.time.nanoseconds();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public KeyValue<K, V> next() {
            KeyValue keyValue = (KeyValue)this.iter.next();
            return KeyValue.pair(MeteredKeyValueStore.this.serdes.keyFrom(((Bytes)keyValue.key).get()), MeteredKeyValueStore.this.outerValue((byte[])keyValue.value));
        }

        @Override
        public void close() {
            try {
                this.iter.close();
            }
            finally {
                this.sensor.record((double)(MeteredKeyValueStore.this.time.nanoseconds() - this.startNs));
            }
        }

        @Override
        public K peekNextKey() {
            return MeteredKeyValueStore.this.serdes.keyFrom(this.iter.peekNextKey().get());
        }
    }
}

