/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.TimestampedCacheFlushListener;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.To;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.easymock.EasyMock;
import org.junit.Test;

public class TimestampedCacheFlushListenerTest {
    @Test
    public void shouldForwardValueTimestampIfNewValueExists() {
        InternalProcessorContext context = (InternalProcessorContext)EasyMock.mock(InternalProcessorContext.class);
        EasyMock.expect((Object)context.currentNode()).andReturn(null).anyTimes();
        context.setCurrentNode(null);
        context.setCurrentNode(null);
        context.forward((Object)"key", (Object)new Change((Object)"newValue", (Object)"oldValue"), To.all().withTimestamp(42L));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{context});
        new TimestampedCacheFlushListener((ProcessorContext)context).apply((Object)"key", ValueAndTimestamp.make((Object)"newValue", (long)42L), ValueAndTimestamp.make((Object)"oldValue", (long)21L), 73L);
        EasyMock.verify((Object[])new Object[]{context});
    }

    @Test
    public void shouldForwardParameterTimestampIfNewValueIsNull() {
        InternalProcessorContext context = (InternalProcessorContext)EasyMock.mock(InternalProcessorContext.class);
        EasyMock.expect((Object)context.currentNode()).andReturn(null).anyTimes();
        context.setCurrentNode(null);
        context.setCurrentNode(null);
        context.forward((Object)"key", (Object)new Change(null, (Object)"oldValue"), To.all().withTimestamp(73L));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{context});
        new TimestampedCacheFlushListener((ProcessorContext)context).apply((Object)"key", null, ValueAndTimestamp.make((Object)"oldValue", (long)21L), 73L);
        EasyMock.verify((Object[])new Object[]{context});
    }
}

