/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.suppress;

import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.Suppressed;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.suppress.KTableSuppressProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.suppress.SuppressedInternal;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.state.internals.InMemoryTimeOrderedKeyValueBuffer;
import org.apache.kafka.test.MockInternalProcessorContext;
import org.apache.kafka.test.StreamsTestUtils;
import org.apache.kafka.test.TestUtils;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Test;

public class KTableSuppressProcessorMetricsTest {
    private static final long ARBITRARY_LONG = 5L;
    private static final TaskId TASK_ID = new TaskId(0, 0);
    private Properties streamsConfig = StreamsTestUtils.getStreamsConfig();
    private final String threadId = Thread.currentThread().getName();
    private final MetricName evictionTotalMetric0100To24 = new MetricName("suppression-emit-total", "stream-processor-node-metrics", "The total number of emitted records from the suppression buffer", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"client-id", (Object)this.threadId), Utils.mkEntry((Object)"task-id", (Object)TASK_ID.toString()), Utils.mkEntry((Object)"processor-node-id", (Object)"testNode")}));
    private final MetricName evictionTotalMetricLatest = new MetricName("suppression-emit-total", "stream-processor-node-metrics", "The total number of emitted records from the suppression buffer", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"thread-id", (Object)this.threadId), Utils.mkEntry((Object)"task-id", (Object)TASK_ID.toString()), Utils.mkEntry((Object)"processor-node-id", (Object)"testNode")}));
    private final MetricName evictionRateMetric0100To24 = new MetricName("suppression-emit-rate", "stream-processor-node-metrics", "The average number of emitted records from the suppression buffer per second", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"client-id", (Object)this.threadId), Utils.mkEntry((Object)"task-id", (Object)TASK_ID.toString()), Utils.mkEntry((Object)"processor-node-id", (Object)"testNode")}));
    private final MetricName evictionRateMetricLatest = new MetricName("suppression-emit-rate", "stream-processor-node-metrics", "The average number of emitted records from the suppression buffer per second", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"thread-id", (Object)this.threadId), Utils.mkEntry((Object)"task-id", (Object)TASK_ID.toString()), Utils.mkEntry((Object)"processor-node-id", (Object)"testNode")}));
    private final MetricName bufferSizeAvgMetric0100To24 = new MetricName("suppression-buffer-size-avg", "stream-buffer-metrics", "The average size of buffered records", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"client-id", (Object)this.threadId), Utils.mkEntry((Object)"task-id", (Object)TASK_ID.toString()), Utils.mkEntry((Object)"buffer-id", (Object)"test-store")}));
    private final MetricName bufferSizeAvgMetricLatest = new MetricName("suppression-buffer-size-avg", "stream-state-metrics", "The average size of buffered records", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"thread-id", (Object)this.threadId), Utils.mkEntry((Object)"task-id", (Object)TASK_ID.toString()), Utils.mkEntry((Object)"in-memory-suppression-state-id", (Object)"test-store")}));
    private final MetricName bufferSizeCurrentMetric = new MetricName("suppression-buffer-size-current", "stream-buffer-metrics", "The current size of buffered records", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"client-id", (Object)this.threadId), Utils.mkEntry((Object)"task-id", (Object)TASK_ID.toString()), Utils.mkEntry((Object)"buffer-id", (Object)"test-store")}));
    private final MetricName bufferSizeMaxMetric0100To24 = new MetricName("suppression-buffer-size-max", "stream-buffer-metrics", "The maximum size of buffered records", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"client-id", (Object)this.threadId), Utils.mkEntry((Object)"task-id", (Object)TASK_ID.toString()), Utils.mkEntry((Object)"buffer-id", (Object)"test-store")}));
    private final MetricName bufferSizeMaxMetricLatest = new MetricName("suppression-buffer-size-max", "stream-state-metrics", "The maximum size of buffered records", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"thread-id", (Object)this.threadId), Utils.mkEntry((Object)"task-id", (Object)TASK_ID.toString()), Utils.mkEntry((Object)"in-memory-suppression-state-id", (Object)"test-store")}));
    private final MetricName bufferCountAvgMetric0100To24 = new MetricName("suppression-buffer-count-avg", "stream-buffer-metrics", "The average count of buffered records", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"client-id", (Object)this.threadId), Utils.mkEntry((Object)"task-id", (Object)TASK_ID.toString()), Utils.mkEntry((Object)"buffer-id", (Object)"test-store")}));
    private final MetricName bufferCountAvgMetricLatest = new MetricName("suppression-buffer-count-avg", "stream-state-metrics", "The average count of buffered records", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"thread-id", (Object)this.threadId), Utils.mkEntry((Object)"task-id", (Object)TASK_ID.toString()), Utils.mkEntry((Object)"in-memory-suppression-state-id", (Object)"test-store")}));
    private final MetricName bufferCountCurrentMetric = new MetricName("suppression-buffer-count-current", "stream-buffer-metrics", "The current count of buffered records", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"client-id", (Object)this.threadId), Utils.mkEntry((Object)"task-id", (Object)TASK_ID.toString()), Utils.mkEntry((Object)"buffer-id", (Object)"test-store")}));
    private final MetricName bufferCountMaxMetric0100To24 = new MetricName("suppression-buffer-count-max", "stream-buffer-metrics", "The maximum count of buffered records", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"client-id", (Object)this.threadId), Utils.mkEntry((Object)"task-id", (Object)TASK_ID.toString()), Utils.mkEntry((Object)"buffer-id", (Object)"test-store")}));
    private final MetricName bufferCountMaxMetricLatest = new MetricName("suppression-buffer-count-max", "stream-state-metrics", "The maximum count of buffered records", Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"thread-id", (Object)this.threadId), Utils.mkEntry((Object)"task-id", (Object)TASK_ID.toString()), Utils.mkEntry((Object)"in-memory-suppression-state-id", (Object)"test-store")}));

    @Test
    public void shouldRecordMetricsWithBuiltInMetricsVersionLatest() {
        this.shouldRecordMetrics("latest");
    }

    @Test
    public void shouldRecordMetricsWithBuiltInMetricsVersion0100To24() {
        this.shouldRecordMetrics("0.10.0-2.4");
    }

    private void shouldRecordMetrics(String builtInMetricsVersion) {
        String storeName = "test-store";
        StateStore buffer = new InMemoryTimeOrderedKeyValueBuffer.Builder("test-store", Serdes.String(), Serdes.Long()).withLoggingDisabled().build();
        KTableImpl mock = (KTableImpl)EasyMock.mock(KTableImpl.class);
        Processor processor = new KTableSuppressProcessorSupplier((SuppressedInternal)Suppressed.untilTimeLimit((Duration)Duration.ofDays(100L), (Suppressed.BufferConfig)Suppressed.BufferConfig.maxRecords((long)1L)), "test-store", mock).get();
        this.streamsConfig.setProperty("built.in.metrics.version", builtInMetricsVersion);
        MockInternalProcessorContext context = new MockInternalProcessorContext(this.streamsConfig, TASK_ID, TestUtils.tempDirectory());
        SystemTime time = new SystemTime();
        context.setCurrentNode(new ProcessorNode("testNode"));
        context.setSystemTimeMs(time.milliseconds());
        buffer.init((StateStoreContext)context, buffer);
        processor.init((ProcessorContext)context);
        long timestamp = 100L;
        context.setRecordMetadata("", 0, 0L, null, 100L);
        String key = "longKey";
        Change value = new Change(null, (Object)5L);
        processor.process((Object)"longKey", (Object)value);
        MetricName evictionRateMetric = "0.10.0-2.4".equals(builtInMetricsVersion) ? this.evictionRateMetric0100To24 : this.evictionRateMetricLatest;
        MetricName evictionTotalMetric = "0.10.0-2.4".equals(builtInMetricsVersion) ? this.evictionTotalMetric0100To24 : this.evictionTotalMetricLatest;
        MetricName bufferSizeAvgMetric = "0.10.0-2.4".equals(builtInMetricsVersion) ? this.bufferSizeAvgMetric0100To24 : this.bufferSizeAvgMetricLatest;
        MetricName bufferSizeMaxMetric = "0.10.0-2.4".equals(builtInMetricsVersion) ? this.bufferSizeMaxMetric0100To24 : this.bufferSizeMaxMetricLatest;
        MetricName bufferCountAvgMetric = "0.10.0-2.4".equals(builtInMetricsVersion) ? this.bufferCountAvgMetric0100To24 : this.bufferCountAvgMetricLatest;
        MetricName bufferCountMaxMetric = "0.10.0-2.4".equals(builtInMetricsVersion) ? this.bufferCountMaxMetric0100To24 : this.bufferCountMaxMetricLatest;
        Map metrics = context.metrics().metrics();
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, evictionRateMetric, Is.is((Object)0.0));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, evictionTotalMetric, Is.is((Object)0.0));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, bufferSizeAvgMetric, Is.is((Object)21.5));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, bufferSizeMaxMetric, Is.is((Object)43.0));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, bufferCountAvgMetric, Is.is((Object)0.5));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, bufferCountMaxMetric, Is.is((Object)1.0));
        if ("0.10.0-2.4".equals(builtInMetricsVersion)) {
            KTableSuppressProcessorMetricsTest.verifyMetric(metrics, this.bufferSizeCurrentMetric, Is.is((Object)43.0));
            KTableSuppressProcessorMetricsTest.verifyMetric(metrics, this.bufferCountCurrentMetric, Is.is((Object)1.0));
        }
        context.setRecordMetadata("", 0, 1L, null, 101L);
        processor.process((Object)"key", (Object)value);
        metrics = context.metrics().metrics();
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, evictionRateMetric, Matchers.greaterThan((Comparable)Double.valueOf(0.0)));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, evictionTotalMetric, Is.is((Object)1.0));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, bufferSizeAvgMetric, Is.is((Object)41.0));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, bufferSizeMaxMetric, Is.is((Object)82.0));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, bufferCountAvgMetric, Is.is((Object)1.0));
        KTableSuppressProcessorMetricsTest.verifyMetric(metrics, bufferCountMaxMetric, Is.is((Object)2.0));
        if ("0.10.0-2.4".equals(builtInMetricsVersion)) {
            KTableSuppressProcessorMetricsTest.verifyMetric(metrics, this.bufferSizeCurrentMetric, Is.is((Object)39.0));
            KTableSuppressProcessorMetricsTest.verifyMetric(metrics, this.bufferCountCurrentMetric, Is.is((Object)1.0));
        }
    }

    private static <T> void verifyMetric(Map<MetricName, ? extends Metric> metrics, MetricName metricName, Matcher<T> matcher) {
        MatcherAssert.assertThat((Object)metrics.get(metricName).metricName().description(), (Matcher)Is.is((Object)metricName.description()));
        MatcherAssert.assertThat((Object)metrics.get(metricName).metricValue(), matcher);
    }
}

