/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.NamedOperation;

public class Joined<K, V, VO>
implements NamedOperation<Joined<K, V, VO>> {
    protected final Serde<K> keySerde;
    protected final Serde<V> valueSerde;
    protected final Serde<VO> otherValueSerde;
    protected final String name;

    private Joined(Serde<K> keySerde, Serde<V> valueSerde, Serde<VO> otherValueSerde, String name) {
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.otherValueSerde = otherValueSerde;
        this.name = name;
    }

    protected Joined(Joined<K, V, VO> joined) {
        this(joined.keySerde, joined.valueSerde, joined.otherValueSerde, joined.name);
    }

    public static <K, V, VO> Joined<K, V, VO> with(Serde<K> keySerde, Serde<V> valueSerde, Serde<VO> otherValueSerde) {
        return new Joined<K, V, VO>(keySerde, valueSerde, otherValueSerde, null);
    }

    public static <K, V, VO> Joined<K, V, VO> with(Serde<K> keySerde, Serde<V> valueSerde, Serde<VO> otherValueSerde, String name) {
        return new Joined<K, V, VO>(keySerde, valueSerde, otherValueSerde, name);
    }

    public static <K, V, VO> Joined<K, V, VO> keySerde(Serde<K> keySerde) {
        return new Joined<K, V, VO>(keySerde, null, null, null);
    }

    public static <K, V, VO> Joined<K, V, VO> valueSerde(Serde<V> valueSerde) {
        return new Joined<K, V, VO>(null, valueSerde, null, null);
    }

    public static <K, V, VO> Joined<K, V, VO> otherValueSerde(Serde<VO> otherValueSerde) {
        return new Joined<K, V, VO>(null, null, otherValueSerde, null);
    }

    @Deprecated
    public static <K, V, VO> Joined<K, V, VO> named(String name) {
        return new Joined<K, V, VO>(null, null, null, name);
    }

    public static <K, V, VO> Joined<K, V, VO> as(String name) {
        return new Joined<K, V, VO>(null, null, null, name);
    }

    public Joined<K, V, VO> withKeySerde(Serde<K> keySerde) {
        return new Joined<K, V, VO>(keySerde, this.valueSerde, this.otherValueSerde, this.name);
    }

    public Joined<K, V, VO> withValueSerde(Serde<V> valueSerde) {
        return new Joined<K, V, VO>(this.keySerde, valueSerde, this.otherValueSerde, this.name);
    }

    public Joined<K, V, VO> withOtherValueSerde(Serde<VO> otherValueSerde) {
        return new Joined<K, V, VO>(this.keySerde, this.valueSerde, otherValueSerde, this.name);
    }

    @Override
    public Joined<K, V, VO> withName(String name) {
        return new Joined<K, V, VO>(this.keySerde, this.valueSerde, this.otherValueSerde, name);
    }

    public Serde<K> keySerde() {
        return this.keySerde;
    }

    public Serde<V> valueSerde() {
        return this.valueSerde;
    }

    public Serde<VO> otherValueSerde() {
        return this.otherValueSerde;
    }

    @Deprecated
    public String name() {
        return this.name;
    }
}

