/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableReduce;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.test.GenericInMemoryTimestampedKeyValueStore;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.junit.Assert;
import org.junit.Test;

public class KTableReduceTest {
    @Test
    public void shouldAddAndSubtract() {
        InternalMockProcessorContext context = new InternalMockProcessorContext();
        Processor reduceProcessor = new KTableReduce("myStore", this::unionNotNullArgs, this::differenceNotNullArgs).get();
        GenericInMemoryTimestampedKeyValueStore myStore = new GenericInMemoryTimestampedKeyValueStore("myStore");
        context.register((StateStore)myStore, null);
        reduceProcessor.init(context);
        context.setCurrentNode(new ProcessorNode("reduce", reduceProcessor, Collections.singleton("myStore")));
        context.setTime(10L);
        reduceProcessor.process((Object)"A", (Object)new Change(Collections.singleton("a"), null));
        Assert.assertEquals((Object)ValueAndTimestamp.make(Collections.singleton("a"), (long)10L), (Object)myStore.get("A"));
        context.setTime(15L);
        reduceProcessor.process((Object)"A", (Object)new Change(Collections.singleton("b"), Collections.singleton("a")));
        Assert.assertEquals((Object)ValueAndTimestamp.make(Collections.singleton("b"), (long)15L), (Object)myStore.get("A"));
        context.setTime(12L);
        reduceProcessor.process((Object)"A", (Object)new Change(null, Collections.singleton("b")));
        Assert.assertEquals((Object)ValueAndTimestamp.make(Collections.emptySet(), (long)15L), (Object)myStore.get("A"));
    }

    private Set<String> differenceNotNullArgs(Set<String> left, Set<String> right) {
        Assert.assertNotNull(left);
        Assert.assertNotNull(right);
        HashSet<String> strings = new HashSet<String>(left);
        strings.removeAll(right);
        return strings;
    }

    private Set<String> unionNotNullArgs(Set<String> left, Set<String> right) {
        Assert.assertNotNull(left);
        Assert.assertNotNull(right);
        HashSet<String> strings = new HashSet<String>();
        strings.addAll(left);
        strings.addAll(right);
        return strings;
    }
}

