/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.time.Instant;
import java.util.Properties;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.KeyValueTimestamp;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.internals.KStreamMap;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class KStreamMapTest {
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.Integer(), Serdes.String());

    @Test
    public void testMap() {
        StreamsBuilder builder = new StreamsBuilder();
        String topicName = "topic";
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        MockProcessorSupplier supplier = new MockProcessorSupplier();
        KStream stream = builder.stream("topic", Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String()));
        stream.map((key, value) -> KeyValue.pair((Object)value, (Object)key)).process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            for (int expectedKey : expectedKeys) {
                TestInputTopic inputTopic = driver.createInputTopic("topic", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
                inputTopic.pipeInput((Object)expectedKey, (Object)("V" + expectedKey), 10L - (long)expectedKey);
            }
        }
        KeyValueTimestamp[] expected = new KeyValueTimestamp[]{new KeyValueTimestamp<String, Integer>("V0", 0, 10L), new KeyValueTimestamp<String, Integer>("V1", 1, 9L), new KeyValueTimestamp<String, Integer>("V2", 2, 8L), new KeyValueTimestamp<String, Integer>("V3", 3, 7L)};
        Assert.assertEquals((long)4L, (long)supplier.theCapturedProcessor().processed().size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], supplier.theCapturedProcessor().processed().get(i));
        }
    }

    @Test
    public void testKeyValueMapperResultNotNull() {
        KStreamMap supplier = new KStreamMap((key, value) -> null);
        Throwable throwable = Assert.assertThrows(NullPointerException.class, () -> supplier.get().process(new Record((Object)"K", (Object)0, 0L)));
        MatcherAssert.assertThat((Object)throwable.getMessage(), (Matcher)Is.is((Object)"The provided KeyValueMapper returned null which is not allowed."));
    }

    @Test
    public void testTypeVariance() {
        new StreamsBuilder().stream("numbers").map((key, value) -> KeyValue.pair((Object)key, (Object)(key + ":" + value))).to("strings");
    }
}

