/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals.metrics;

import java.math.BigInteger;
import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecorder;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.powermock.api.easymock.PowerMock;
import org.rocksdb.Cache;
import org.rocksdb.RocksDB;
import org.rocksdb.Statistics;

public class RocksDBMetricsRecorderGaugesTest {
    private static final String METRICS_SCOPE = "metrics-scope";
    private static final TaskId TASK_ID = new TaskId(0, 0);
    private static final String STORE_NAME = "store-name";
    private static final String SEGMENT_STORE_NAME_1 = "segment-store-name-1";
    private static final String SEGMENT_STORE_NAME_2 = "segment-store-name-2";
    private static final String ROCKSDB_PROPERTIES_PREFIX = "rocksdb.";
    private final RocksDB dbToAdd1 = (RocksDB)EasyMock.mock(RocksDB.class);
    private final RocksDB dbToAdd2 = (RocksDB)EasyMock.mock(RocksDB.class);
    private final Cache cacheToAdd1 = (Cache)EasyMock.mock(Cache.class);
    private final Cache cacheToAdd2 = (Cache)EasyMock.mock(Cache.class);
    private final Statistics statisticsToAdd1 = (Statistics)EasyMock.mock(Statistics.class);
    private final Statistics statisticsToAdd2 = (Statistics)EasyMock.mock(Statistics.class);

    @Test
    public void shouldGetNumberOfImmutableMemTables() throws Exception {
        this.runAndVerifySumOfProperties("num-immutable-mem-table");
    }

    @Test
    public void shouldGetCurrentSizeofActiveMemTable() throws Exception {
        this.runAndVerifySumOfProperties("cur-size-active-mem-table");
    }

    @Test
    public void shouldGetCurrentSizeofAllMemTables() throws Exception {
        this.runAndVerifySumOfProperties("cur-size-all-mem-tables");
    }

    @Test
    public void shouldGetSizeofAllMemTables() throws Exception {
        this.runAndVerifySumOfProperties("size-all-mem-tables");
    }

    @Test
    public void shouldGetNumberOfEntriesActiveMemTable() throws Exception {
        this.runAndVerifySumOfProperties("num-entries-active-mem-table");
    }

    @Test
    public void shouldGetNumberOfDeletesActiveMemTable() throws Exception {
        this.runAndVerifySumOfProperties("num-deletes-active-mem-table");
    }

    @Test
    public void shouldGetNumberOfEntriesImmutableMemTables() throws Exception {
        this.runAndVerifySumOfProperties("num-entries-imm-mem-tables");
    }

    @Test
    public void shouldGetNumberOfDeletesImmutableMemTables() throws Exception {
        this.runAndVerifySumOfProperties("num-deletes-imm-mem-tables");
    }

    @Test
    public void shouldGetMemTableFlushPending() throws Exception {
        this.runAndVerifySumOfProperties("mem-table-flush-pending");
    }

    @Test
    public void shouldGetNumberOfRunningFlushes() throws Exception {
        this.runAndVerifySumOfProperties("num-running-flushes");
    }

    @Test
    public void shouldGetCompactionPending() throws Exception {
        this.runAndVerifySumOfProperties("compaction-pending");
    }

    @Test
    public void shouldGetNumberOfRunningCompactions() throws Exception {
        this.runAndVerifySumOfProperties("num-running-compactions");
    }

    @Test
    public void shouldGetEstimatedBytesOfPendingCompactions() throws Exception {
        this.runAndVerifySumOfProperties("estimate-pending-compaction-bytes");
    }

    @Test
    public void shouldGetTotalSstFilesSize() throws Exception {
        this.runAndVerifySumOfProperties("total-sst-files-size");
    }

    @Test
    public void shouldGetLiveSstFilesSize() throws Exception {
        this.runAndVerifySumOfProperties("live-sst-files-size");
    }

    @Test
    public void shouldGetEstimatedNumberOfKeys() throws Exception {
        this.runAndVerifySumOfProperties("estimate-num-keys");
    }

    @Test
    public void shouldGetEstimatedMemoryOfTableReaders() throws Exception {
        this.runAndVerifySumOfProperties("estimate-table-readers-mem");
    }

    @Test
    public void shouldGetNumberOfBackgroundErrors() throws Exception {
        this.runAndVerifySumOfProperties("background-errors");
    }

    @Test
    public void shouldGetCapacityOfBlockCacheWithMultipleCaches() throws Exception {
        this.runAndVerifyBlockCacheMetricsWithMultipleCaches("block-cache-capacity");
    }

    @Test
    public void shouldGetCapacityOfBlockCacheWithSingleCache() throws Exception {
        this.runAndVerifyBlockCacheMetricsWithSingleCache("block-cache-capacity");
    }

    @Test
    public void shouldGetUsageOfBlockCacheWithMultipleCaches() throws Exception {
        this.runAndVerifyBlockCacheMetricsWithMultipleCaches("block-cache-usage");
    }

    @Test
    public void shouldGetUsageOfBlockCacheWithSingleCache() throws Exception {
        this.runAndVerifyBlockCacheMetricsWithSingleCache("block-cache-usage");
    }

    @Test
    public void shouldGetPinnedUsageOfBlockCacheWithMultipleCaches() throws Exception {
        this.runAndVerifyBlockCacheMetricsWithMultipleCaches("block-cache-pinned-usage");
    }

    @Test
    public void shouldGetPinnedUsageOfBlockCacheWithSingleCache() throws Exception {
        this.runAndVerifyBlockCacheMetricsWithSingleCache("block-cache-pinned-usage");
    }

    private void runAndVerifySumOfProperties(String propertyName) throws Exception {
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(new Metrics(), "test-client", "latest", (Time)new MockTime());
        RocksDBMetricsRecorder recorder = new RocksDBMetricsRecorder(METRICS_SCOPE, STORE_NAME);
        recorder.init(streamsMetrics, TASK_ID);
        recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        recorder.addValueProviders(SEGMENT_STORE_NAME_2, this.dbToAdd2, this.cacheToAdd2, this.statisticsToAdd2);
        long recordedValue1 = 5L;
        long recordedValue2 = 3L;
        EasyMock.expect((Object)this.dbToAdd1.getAggregatedLongProperty(ROCKSDB_PROPERTIES_PREFIX + propertyName)).andStubReturn((Object)5L);
        EasyMock.expect((Object)this.dbToAdd2.getAggregatedLongProperty(ROCKSDB_PROPERTIES_PREFIX + propertyName)).andStubReturn((Object)3L);
        PowerMock.replay((Object[])new Object[]{this.dbToAdd1, this.dbToAdd2});
        this.verifyMetrics(streamsMetrics, propertyName, 8L);
    }

    private void runAndVerifyBlockCacheMetricsWithMultipleCaches(String propertyName) throws Exception {
        this.runAndVerifySumOfProperties(propertyName);
    }

    private void runAndVerifyBlockCacheMetricsWithSingleCache(String propertyName) throws Exception {
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(new Metrics(), "test-client", "latest", (Time)new MockTime());
        RocksDBMetricsRecorder recorder = new RocksDBMetricsRecorder(METRICS_SCOPE, STORE_NAME);
        recorder.init(streamsMetrics, TASK_ID);
        recorder.addValueProviders(SEGMENT_STORE_NAME_1, this.dbToAdd1, this.cacheToAdd1, this.statisticsToAdd1);
        recorder.addValueProviders(SEGMENT_STORE_NAME_2, this.dbToAdd2, this.cacheToAdd1, this.statisticsToAdd2);
        long recordedValue = 5L;
        EasyMock.expect((Object)this.dbToAdd1.getAggregatedLongProperty(ROCKSDB_PROPERTIES_PREFIX + propertyName)).andStubReturn((Object)5L);
        EasyMock.expect((Object)this.dbToAdd2.getAggregatedLongProperty(ROCKSDB_PROPERTIES_PREFIX + propertyName)).andStubReturn((Object)5L);
        PowerMock.replay((Object[])new Object[]{this.dbToAdd1, this.dbToAdd2});
        this.verifyMetrics(streamsMetrics, propertyName, 5L);
    }

    private void verifyMetrics(StreamsMetricsImpl streamsMetrics, String propertyName, long expectedValue) {
        Map metrics = streamsMetrics.metrics();
        Map tagMap = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"thread-id", (Object)Thread.currentThread().getName()), Utils.mkEntry((Object)"task-id", (Object)TASK_ID.toString()), Utils.mkEntry((Object)"metrics-scope-state-id", (Object)STORE_NAME)});
        KafkaMetric metric = (KafkaMetric)metrics.get(new MetricName(propertyName, "stream-state-metrics", "description is ignored", tagMap));
        MatcherAssert.assertThat((Object)metric, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)metric.metricValue(), (Matcher)CoreMatchers.is((Object)BigInteger.valueOf(expectedValue)));
    }
}

