/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ReadOnlySessionStore;
import org.apache.kafka.test.KeyValueIteratorStub;

public class ReadOnlySessionStoreStub<K, V>
implements ReadOnlySessionStore<K, V>,
StateStore {
    private final NavigableMap<K, List<KeyValue<Windowed<K>, V>>> sessions = new TreeMap<K, List<KeyValue<Windowed<K>, V>>>();
    private boolean open = true;

    public void put(Windowed<K> sessionKey, V value) {
        if (!this.sessions.containsKey(sessionKey.key())) {
            this.sessions.put(sessionKey.key(), new ArrayList());
        }
        ((List)this.sessions.get(sessionKey.key())).add(KeyValue.pair(sessionKey, value));
    }

    public KeyValueIterator<Windowed<K>, V> findSessions(K key, long earliestSessionEndTime, long latestSessionStartTime) {
        throw new UnsupportedOperationException("Moved from Session Store. Implement if needed");
    }

    public KeyValueIterator<Windowed<K>, V> backwardFindSessions(K key, long earliestSessionEndTime, long latestSessionStartTime) {
        throw new UnsupportedOperationException("Moved from Session Store. Implement if needed");
    }

    public KeyValueIterator<Windowed<K>, V> findSessions(K keyFrom, K keyTo, long earliestSessionEndTime, long latestSessionStartTime) {
        throw new UnsupportedOperationException("Moved from Session Store. Implement if needed");
    }

    public KeyValueIterator<Windowed<K>, V> backwardFindSessions(K keyFrom, K keyTo, long earliestSessionEndTime, long latestSessionStartTime) {
        throw new UnsupportedOperationException("Moved from Session Store. Implement if needed");
    }

    public V fetchSession(K key, long earliestSessionEndTime, long latestSessionStartTime) {
        throw new UnsupportedOperationException("Moved from Session Store. Implement if needed");
    }

    public KeyValueIterator<Windowed<K>, V> fetch(K key) {
        if (!this.open) {
            throw new InvalidStateStoreException("not open");
        }
        if (!this.sessions.containsKey(key)) {
            return new KeyValueIteratorStub(Collections.emptyIterator());
        }
        return new KeyValueIteratorStub(((List)this.sessions.get(key)).iterator());
    }

    public KeyValueIterator<Windowed<K>, V> backwardFetch(K key) {
        if (!this.open) {
            throw new InvalidStateStoreException("not open");
        }
        if (!this.sessions.containsKey(key)) {
            return new KeyValueIteratorStub(Collections.emptyIterator());
        }
        return new KeyValueIteratorStub(((List)this.sessions.descendingMap().get(key)).iterator());
    }

    public KeyValueIterator<Windowed<K>, V> fetch(K keyFrom, K keyTo) {
        if (!this.open) {
            throw new InvalidStateStoreException("not open");
        }
        NavigableMap<K, List<KeyValue<Windowed<K>, V>>> subSessionsMap = this.getSubSessionsMap(keyFrom, keyTo);
        if (subSessionsMap.isEmpty()) {
            return new KeyValueIteratorStub(Collections.emptyIterator());
        }
        final Iterator keysIterator = subSessionsMap.values().iterator();
        return new KeyValueIteratorStub(new Iterator<KeyValue<Windowed<K>, V>>(){
            Iterator<KeyValue<Windowed<K>, V>> it;

            @Override
            public boolean hasNext() {
                while (this.it == null || !this.it.hasNext()) {
                    if (!keysIterator.hasNext()) {
                        return false;
                    }
                    this.it = ((List)keysIterator.next()).iterator();
                }
                return true;
            }

            @Override
            public KeyValue<Windowed<K>, V> next() {
                return this.it.next();
            }
        });
    }

    private NavigableMap<K, List<KeyValue<Windowed<K>, V>>> getSubSessionsMap(K keyFrom, K keyTo) {
        NavigableMap<K, List<Object>> subSessionsMap = keyFrom == null && keyTo == null ? this.sessions : (keyFrom == null ? this.sessions.headMap(keyTo, true) : (keyTo == null ? this.sessions.tailMap(keyFrom, true) : this.sessions.subMap(keyFrom, true, keyTo, true)));
        return subSessionsMap;
    }

    public KeyValueIterator<Windowed<K>, V> backwardFetch(K keyFrom, K keyTo) {
        if (!this.open) {
            throw new InvalidStateStoreException("not open");
        }
        NavigableMap<K, List<KeyValue<Windowed<K>, V>>> subSessionsMap = this.getSubSessionsMap(keyFrom, keyTo);
        if (subSessionsMap.isEmpty()) {
            return new KeyValueIteratorStub(Collections.emptyIterator());
        }
        final Iterator keysIterator = subSessionsMap.descendingMap().values().iterator();
        return new KeyValueIteratorStub(new Iterator<KeyValue<Windowed<K>, V>>(){
            Iterator<KeyValue<Windowed<K>, V>> it;

            @Override
            public boolean hasNext() {
                while (this.it == null || !this.it.hasNext()) {
                    if (!keysIterator.hasNext()) {
                        return false;
                    }
                    this.it = ((List)keysIterator.next()).iterator();
                }
                return true;
            }

            @Override
            public KeyValue<Windowed<K>, V> next() {
                return this.it.next();
            }
        });
    }

    public String name() {
        return "";
    }

    @Deprecated
    public void init(ProcessorContext context, StateStore root) {
    }

    public void flush() {
    }

    public void close() {
    }

    public boolean persistent() {
        return false;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }
}

