/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.clients.producer.internals.BuiltInPartitioner;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.processor.StreamPartitioner;

public class DefaultStreamPartitioner<K, V>
implements StreamPartitioner<K, V> {
    private final Serializer<K> keySerializer;

    public DefaultStreamPartitioner(Serializer<K> keySerializer) {
        this.keySerializer = keySerializer;
    }

    @Override
    public Integer partition(String topic, K key, V value, int numPartitions) {
        byte[] keyBytes = this.keySerializer.serialize(topic, key);
        if (keyBytes == null) {
            return null;
        }
        return BuiltInPartitioner.partitionForKey((byte[])keyBytes, (int)numPartitions);
    }
}

