/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.kafka.streams.processor.TaskId;

class ConstrainedPrioritySet {
    private final PriorityQueue<UUID> clientsByTaskLoad;
    private final BiFunction<UUID, TaskId, Boolean> constraint;
    private final Set<UUID> uniqueClients = new HashSet<UUID>();

    ConstrainedPrioritySet(BiFunction<UUID, TaskId, Boolean> constraint, Function<UUID, Double> weight) {
        this.constraint = constraint;
        this.clientsByTaskLoad = new PriorityQueue<UUID>(Comparator.comparing(weight).thenComparing(clientId -> clientId));
    }

    UUID poll(TaskId task, Function<UUID, Boolean> extraConstraint) {
        HashSet<UUID> invalidPolledClients = new HashSet<UUID>();
        while (!this.clientsByTaskLoad.isEmpty()) {
            UUID candidateClient = this.pollNextClient();
            if (this.constraint.apply(candidateClient, task).booleanValue() && extraConstraint.apply(candidateClient).booleanValue()) {
                this.offerAll(invalidPolledClients);
                return candidateClient;
            }
            invalidPolledClients.add(candidateClient);
        }
        this.offerAll(invalidPolledClients);
        return null;
    }

    UUID poll(TaskId task) {
        return this.poll(task, client -> true);
    }

    void offerAll(Collection<UUID> clients) {
        for (UUID client : clients) {
            this.offer(client);
        }
    }

    void offer(UUID client) {
        if (this.uniqueClients.contains(client)) {
            this.clientsByTaskLoad.remove(client);
        } else {
            this.uniqueClients.add(client);
        }
        this.clientsByTaskLoad.offer(client);
    }

    private UUID pollNextClient() {
        UUID client = (UUID)this.clientsByTaskLoad.remove();
        this.uniqueClients.remove(client);
        return client;
    }
}

